/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.core.P4JChangeList;
import com.perforce.p4java.core.P4JChangeListStatus;
import com.perforce.p4java.core.P4JFix;
import com.perforce.p4java.core.P4JJob;
import com.perforce.p4java.core.file.P4JDiffType;
import com.perforce.p4java.core.file.P4JFileSpec;
import com.perforce.p4java.core.file.P4JFileSpecOpStatus;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.exception.P4JUnimplementedError;
import com.perforce.p4java.impl.generic.core.P4JInputMapper;
import com.perforce.p4java.impl.generic.core.P4JServerResourceImpl;
import com.perforce.p4java.impl.generic.core.file.P4JFileSpecImpl;
import com.perforce.p4java.impl.mapbased.server.P4JServerImpl;
import com.perforce.p4java.server.P4JCmdSpec;
import com.perforce.p4java.server.P4JServer;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JChangeListImpl
extends P4JServerResourceImpl
implements P4JChangeList {
    private static final String CHANGE_KEY = "Change";
    private static final String NEW_KEY = "new";
    private static final String CLIENT_KEY = "Client";
    private static final String USER_KEY = "User";
    private static final String STATUS_KEY = "Status";
    private static final String DATE_KEY = "Date";
    private static final String DESCRIPTION_KEY = "Description";
    private static final String JOBS_KEY = "Jobs";
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private int id = -1;
    private String clientId = null;
    private String username = null;
    private P4JChangeListStatus status = null;
    private Date date = null;
    private String description = null;
    private P4JServerImpl serverImpl = null;
    List<P4JFileSpec> fileSpecs = null;
    List<String> jobIds = null;

    public P4JChangeListImpl() {
    }

    public P4JChangeListImpl(int id, String clientId, String username, P4JChangeListStatus status, Date date, String description, P4JServerImpl serverImpl) {
        super(false, true, true, true, serverImpl);
        this.id = id;
        this.clientId = clientId;
        this.username = username;
        this.status = status;
        this.date = date;
        this.description = description;
        this.serverImpl = serverImpl;
    }

    public P4JChangeListImpl(Map<String, Object> map, P4JServerImpl serverImpl) {
        super(true, true, true, true, serverImpl);
        this.serverImpl = serverImpl;
        if (map != null) {
            String idString = (String)map.get(CHANGE_KEY);
            if (idString != null && idString.equalsIgnoreCase(NEW_KEY)) {
                this.id = 0;
            } else {
                try {
                    this.id = new Integer(idString);
                }
                catch (Exception exc) {
                    P4JLog.exception(exc);
                    this.id = -1;
                }
            }
            this.clientId = (String)map.get(CLIENT_KEY);
            this.username = (String)map.get(USER_KEY);
            this.status = P4JChangeListStatus.fromString((String)map.get(STATUS_KEY));
            String dateStr = (String)map.get(DATE_KEY);
            if (dateStr == null) {
                this.date = new Date();
            } else {
                try {
                    this.date = new SimpleDateFormat(DATE_FORMAT).parse(dateStr);
                }
                catch (ParseException pe) {
                    P4JLog.error("Date parse error in P4JChangeListImpl constructor: " + pe.getLocalizedMessage());
                }
            }
            this.description = (String)map.get(DESCRIPTION_KEY);
            if (map.containsKey("Jobs0")) {
                String jobId;
                this.jobIds = new ArrayList<String>();
                for (int job = 0; job >= 0 && (jobId = (String)map.get(JOBS_KEY + job)) != null; ++job) {
                    this.jobIds.add(jobId);
                }
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public P4JChangeListStatus getStatus() {
        return this.status;
    }

    public void setStatus(P4JChangeListStatus status) {
        this.status = status;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String setDescription(String description) {
        String oldVal = this.description;
        this.description = description;
        return oldVal;
    }

    public P4JServer getServer() {
        return this.serverImpl;
    }

    public void setServerImpl(P4JServerImpl serverImpl) {
        this.serverImpl = serverImpl;
    }

    @Override
    public List<P4JFileSpec> getFiles(boolean refresh) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.getFiles(refresh, false);
    }

    public List<P4JFileSpec> getFiles(boolean refresh, boolean bypassServer) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (!refresh && this.fileSpecs != null) {
            return this.fileSpecs;
        }
        if (bypassServer && !refresh && this.fileSpecs == null) {
            this.fileSpecs = new ArrayList<P4JFileSpec>();
            return this.fileSpecs;
        }
        if (this.serverImpl == null) {
            throw new P4JRequestException("Changelist not associated with a Perforce server");
        }
        if (!refresh && this.fileSpecs != null) {
            return this.fileSpecs;
        }
        if (this.serverImpl == null) {
            throw new P4JRequestException("Changelist not associated with a Perforce server");
        }
        if (this.id == 0) {
            List<P4JFileSpec> openList = this.serverImpl.openedFiles(null, false, this.clientId, 0, 0);
            ArrayList<P4JFileSpec> defList = new ArrayList<P4JFileSpec>();
            if (openList != null) {
                for (P4JFileSpec fSpec : openList) {
                    if (fSpec.getChangeListId() != 0) continue;
                    defList.add(fSpec);
                }
            }
            this.fileSpecs = defList;
        } else {
            this.fileSpecs = this.serverImpl.getChangeListFiles(this.id);
        }
        return this.fileSpecs;
    }

    @Override
    public InputStream getDiffs(P4JDiffType diffType) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (this.serverImpl == null) {
            throw new P4JRequestException("Changelist not associated with a Perforce server");
        }
        return this.serverImpl.getChangeListDiffs(this.id, diffType);
    }

    @Override
    public List<String> getJobIdList() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        List<P4JFix> fixList;
        ArrayList<String> idList = new ArrayList<String>();
        if (this.serverImpl != null && (fixList = this.serverImpl.getFixList(null, this.id, null, false, 0)) != null) {
            for (P4JFix fix : fixList) {
                if (fix == null || fix.getJobId() == null) continue;
                idList.add(fix.getJobId());
            }
            this.jobIds = idList;
        }
        return idList;
    }

    @Override
    public List<String> getCachedJobIdList() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (this.jobIds != null) {
            return this.jobIds;
        }
        return new ArrayList<String>();
    }

    @Override
    public List<P4JJob> getJobList() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        List<String> idList = this.getJobIdList();
        ArrayList<P4JJob> jobList = new ArrayList<P4JJob>();
        if (idList != null && this.serverImpl != null) {
            for (String id : idList) {
                jobList.add(this.serverImpl.getJob(id));
            }
        }
        return jobList;
    }

    @Override
    public List<P4JFileSpec> submit(boolean reOpen, List<String> jobIds, String jobStatus) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        int i;
        if (this.serverImpl == null) {
            throw new P4JRequestException("Changelist not associated with a Perforce server");
        }
        HashMap<String, Object> inMap = new HashMap<String, Object>();
        if (this.id == -1 || this.id == 0) {
            inMap.put(CHANGE_KEY, NEW_KEY);
        } else {
            inMap.put(CHANGE_KEY, Integer.toString(this.id));
        }
        inMap.put(CLIENT_KEY, this.clientId);
        inMap.put(USER_KEY, this.username);
        inMap.put(DESCRIPTION_KEY, this.description);
        if (this.fileSpecs != null) {
            i = 0;
            for (P4JFileSpec spec : this.fileSpecs) {
                inMap.put("Files" + i++, spec.getDepotPath());
            }
        }
        if (jobIds != null) {
            i = 0;
            for (String id : jobIds) {
                if (jobStatus != null) {
                    inMap.put(JOBS_KEY + i++, id + " " + jobStatus);
                    continue;
                }
                inMap.put(JOBS_KEY + i++, id);
            }
        }
        int argNum = 1;
        if (reOpen) {
            ++argNum;
        }
        if (jobStatus != null) {
            ++argNum;
        }
        String[] cmdArgs = new String[argNum];
        int i2 = 0;
        cmdArgs[i2++] = "-i";
        if (reOpen) {
            cmdArgs[i2++] = "-r";
        }
        if (jobStatus != null) {
            cmdArgs[i2++] = "-s";
        }
        Map<String, Object>[] syncMap = this.serverImpl.execMapCmd(P4JCmdSpec.SUBMIT, cmdArgs, inMap);
        ArrayList<P4JFileSpec> fileList = new ArrayList<P4JFileSpec>();
        if (syncMap != null) {
            for (Map<String, Object> map : syncMap) {
                if (map.get("submittedChange") != null) {
                    this.id = new Integer((String)map.get("submittedChange"));
                    this.status = P4JChangeListStatus.SUBMITTED;
                    fileList.add(new P4JFileSpecImpl(P4JFileSpecOpStatus.INFO, "Submitted as change " + this.id));
                    continue;
                }
                if (map.get("locked") != null) continue;
                fileList.add(this.serverImpl.handleFileReturn(map));
            }
        }
        return fileList;
    }

    @Override
    public List<P4JFileSpec> submit(boolean reOpen) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.submit(reOpen, null, null);
    }

    private void updateFlags() {
        this.complete = this.status != null && this.clientId != null && this.date != null && this.description != null && this.username != null && this.fileSpecs != null;
    }

    @Override
    public void complete() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (!this.completable) {
            throw new P4JUnimplementedError("tried to complete non-completeable changelist");
        }
        this.refresh();
    }

    @Override
    public void refresh() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (this.serverImpl == null) {
            throw new P4JRequestException("Changelist not associated with a Perforce server");
        }
        if (!this.refreshable) {
            throw new P4JUnimplementedError("tried to refresh non-refreshable changelist");
        }
        P4JChangeList cList = this.serverImpl.getChangeList(this.id);
        this.status = cList.getStatus();
        this.clientId = cList.getClientId();
        this.date = cList.getDate();
        this.description = cList.getDescription();
        this.username = cList.getUsername();
        this.getFiles(true);
        this.updateFlags();
    }

    @Override
    public void update() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (this.serverImpl == null) {
            throw new P4JRequestException("Changelist not associated with a Perforce server");
        }
        if (!this.updateable) {
            throw new P4JUnimplementedError("tried to refresh non-updateable changelist");
        }
        if (this.id == -1 || this.id == 0) {
            throw new P4JRequestException("Tried to update new or default changelist");
        }
        Map<String, Object>[] changeMap = this.serverImpl.execMapCmd(P4JCmdSpec.CHANGE, new String[]{"-i"}, P4JInputMapper.map(this));
        if (changeMap != null) {
            for (Map<String, Object> map : changeMap) {
                this.serverImpl.handleErrorStr(map);
            }
        }
    }

    @Override
    public void updateOnServer(boolean refresh) throws P4JConnectionException, P4JRequestException, P4JAccessException {
        this.update();
        if (refresh) {
            this.refresh();
        }
    }

    public List<P4JFileSpec> getFileSpecs() {
        return this.fileSpecs;
    }
}

