/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.core.P4JBranchSpec;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.impl.generic.core.P4JServerResourceImpl;
import com.perforce.p4java.server.P4JServer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JBranchSpecImpl
extends P4JServerResourceImpl
implements P4JBranchSpec {
    private Date accessed = null;
    private Date updated = null;
    private String name = null;
    private String ownerName = null;
    private String description = null;
    private boolean locked = false;
    private List<P4JBranchSpec.P4JBranchViewMapping> branchView = null;

    public P4JBranchSpecImpl() {
    }

    public P4JBranchSpecImpl(Map<String, Object> map, boolean fromList, P4JServer server) {
        super(true, false, false, false);
        this.server = server;
        String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
        if (map != null) {
            try {
                if (fromList) {
                    this.name = (String)map.get("branch");
                    this.accessed = new Date(Long.parseLong((String)map.get("Access")) * 1000L);
                    this.updated = new Date(Long.parseLong((String)map.get("Update")) * 1000L);
                } else {
                    this.name = (String)map.get("Branch");
                    if (map.containsKey("Update")) {
                        this.updated = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Update"));
                    }
                    if (map.containsKey("Access")) {
                        this.accessed = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Access"));
                    }
                    String key = "View";
                    int i = 0;
                    while (map.containsKey(key + i)) {
                        if (map.get(key + i) != null) {
                            String[] view;
                            if (this.branchView == null) {
                                this.branchView = new ArrayList<P4JBranchSpec.P4JBranchViewMapping>();
                            }
                            if ((view = ((String)map.get(key + i)).split(" ")).length == 2) {
                                this.branchView.add(new P4JBranchViewMappingImpl(i, view[0], view[1]));
                            } else {
                                P4JLog.warn("Bad branch view map length in P4JBranchSpecImpl constructor: " + view.length);
                            }
                        }
                        ++i;
                    }
                }
                this.description = (String)map.get("Description");
                this.ownerName = (String)map.get("Owner");
                String opts = (String)map.get("Options");
                if (opts != null && opts.equalsIgnoreCase("locked")) {
                    this.locked = true;
                }
            }
            catch (Throwable thr) {
                P4JLog.warn("Unexpected exception in P4JBranchSpecImpl constructor: " + thr.getMessage());
                P4JLog.exception(thr);
            }
        }
    }

    private void updateFlags() {
        this.complete = this.name != null && this.branchView != null && this.description != null && this.ownerName != null;
    }

    @Override
    public void complete() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        this.refresh();
    }

    @Override
    public void refresh() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        P4JBranchSpec refreshedBranch;
        P4JServer refreshServer = this.server;
        String refreshName = this.name;
        if (refreshServer != null && refreshName != null && (refreshedBranch = refreshServer.getBranchSpec(refreshName)) != null) {
            this.name = refreshedBranch.getName();
            this.accessed = refreshedBranch.getAccessed();
            this.updated = refreshedBranch.getUpdated();
            this.branchView = refreshedBranch.getBranchView();
            this.description = refreshedBranch.getDescription();
            this.ownerName = refreshedBranch.getOwnerName();
            this.locked = refreshedBranch.isLocked();
        }
        this.updateFlags();
    }

    @Override
    public Date getAccessed() {
        return this.accessed;
    }

    @Override
    public List<P4JBranchSpec.P4JBranchViewMapping> getBranchView() {
        return this.branchView;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setAccessed(Date accessed) {
        this.accessed = accessed;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setBranchView(List<P4JBranchSpec.P4JBranchViewMapping> branchView) {
        this.branchView = branchView;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public class P4JBranchViewMappingImpl
    implements P4JBranchSpec.P4JBranchViewMapping {
        private int order = 0;
        private String sourceSpec = null;
        private String targetSpec = null;

        public P4JBranchViewMappingImpl() {
        }

        public P4JBranchViewMappingImpl(int order, String sourceSpec, String targetSpec) {
            this.order = order;
            this.sourceSpec = sourceSpec;
            this.targetSpec = targetSpec;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public String getSourceSpec() {
            return this.sourceSpec;
        }

        public void setSourceSpec(String sourceSpec) {
            this.sourceSpec = sourceSpec;
        }

        public String getTargetSpec() {
            return this.targetSpec;
        }

        public void setTargetSpec(String targetSpec) {
            this.targetSpec = targetSpec;
        }
    }
}

