/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java;

import com.perforce.p4java.server.callback.P4JLogCallback;

public class P4JLog {
    private static P4JLogCallback logCallback = null;

    public static P4JLogCallback getLogCallback() {
        return logCallback;
    }

    public static P4JLogCallback setLogCallback(P4JLogCallback logCallback) {
        P4JLogCallback oldCallback = P4JLog.logCallback;
        P4JLog.logCallback = logCallback;
        return oldCallback;
    }

    public static void error(String errorString) {
        if (logCallback != null) {
            logCallback.internalError(errorString);
        }
    }

    public static void warn(String warnString) {
        if (logCallback != null) {
            logCallback.internalWarn(warnString);
        }
    }

    public static void info(String infoString) {
        if (logCallback != null) {
            logCallback.internalInfo(infoString);
        }
    }

    public static void stats(String statsString) {
        if (logCallback != null) {
            logCallback.internalStats(statsString);
        }
    }

    public static void exception(Throwable thr) {
        if (logCallback != null && thr != null) {
            logCallback.internalException(thr);
        }
    }

    public static void trace(P4JLogCallback.P4JLogTraceLevel traceLevel, String traceMessage) {
        if (logCallback != null && traceLevel != null && traceMessage != null && P4JLog.isTracingAtLevel(traceLevel)) {
            logCallback.internalTrace(traceLevel, traceMessage);
        }
    }

    public static boolean isTracingAtLevel(P4JLogCallback.P4JLogTraceLevel traceLevel) {
        return logCallback != null && logCallback.getTraceLevel() != null && traceLevel.compareTo(logCallback.getTraceLevel()) <= 0;
    }
}

