/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JLookahead;
import com.perforce.p4java.exception.P4JClientError;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class P4JCharsetConverter {
    private CharsetDecoder decoder;
    private CharsetEncoder encoder;
    private byte[] underflow;
    private boolean checkBOM = false;
    private boolean ignoreBOM = false;

    public P4JCharsetConverter(Charset fromCharset, Charset toCharset, boolean ignoreBOM) {
        this.decoder = fromCharset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.encoder = toCharset.newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPORT);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        if ("UTF-16".equals(toCharset.name())) {
            this.checkBOM = true;
        }
        this.ignoreBOM = ignoreBOM;
    }

    public String getFromCharsetName() {
        return this.decoder.charset().name();
    }

    public String getToCharsetName() {
        return this.encoder.charset().name();
    }

    public P4JCharsetConverter(Charset fromCharset, Charset toCharset) {
        this(fromCharset, toCharset, false);
    }

    public byte[] clearUnderflow() {
        byte[] cleared = this.underflow;
        this.underflow = null;
        return cleared;
    }

    public ByteBuffer convert(CharBuffer from) {
        ByteBuffer converted = null;
        try {
            converted = this.encoder.encode(from);
            if (this.checkBOM) {
                if (this.ignoreBOM) {
                    int limit = converted.limit();
                    if (limit > 2) {
                        byte[] bom = new byte[2];
                        converted.get(bom);
                        if (bom[0] == -2 && bom[1] == -1 || bom[0] == -1 && bom[1] == -2) {
                            converted.position(2);
                            converted.limit(limit - 2);
                        } else {
                            converted.rewind();
                        }
                    }
                } else {
                    this.ignoreBOM = true;
                }
            } else {
                converted.position(0);
            }
        }
        catch (CharacterCodingException cce) {
            P4JLog.exception(cce);
            throw new P4JClientError("Translation of file content failed", cce);
        }
        return converted;
    }

    public ByteBuffer convert(ByteBuffer from, P4JLookahead lookahead) {
        ByteBuffer converted = null;
        if (this.underflow != null) {
            ByteBuffer joinedBuffer = ByteBuffer.allocate(from.array().length + this.underflow.length);
            joinedBuffer.put(this.underflow);
            joinedBuffer.put(from);
            from = joinedBuffer;
            from.rewind();
            this.underflow = null;
        }
        CharBuffer sourceChars = CharBuffer.allocate(Math.round(this.decoder.maxCharsPerByte() * (float)from.limit()) + 1);
        this.decoder.decode(from, sourceChars, true);
        sourceChars.flip();
        if (lookahead != null && sourceChars.limit() > 0) {
            byte[] ahead = lookahead.bytesToAdd(sourceChars.charAt(sourceChars.limit() - 1));
            while (ahead != null && ahead.length > 0) {
                byte[] next = null;
                if (from.hasRemaining()) {
                    int remaining = from.remaining();
                    next = new byte[ahead.length + remaining];
                    from.get(next, 0, remaining);
                    System.arraycopy(ahead, 0, next, remaining, ahead.length);
                } else {
                    next = ahead;
                }
                from = ByteBuffer.wrap(next);
                CharBuffer aheadChars = CharBuffer.allocate(Math.round(this.decoder.maxCharsPerByte() * (float)from.limit()) + 1);
                this.decoder.decode(from, aheadChars, true);
                aheadChars.flip();
                if (aheadChars.limit() > 0) {
                    CharBuffer joinedChars = CharBuffer.allocate(aheadChars.limit() + sourceChars.limit());
                    joinedChars.put(sourceChars);
                    joinedChars.put(aheadChars);
                    sourceChars = joinedChars;
                    sourceChars.rewind();
                    ahead = lookahead.bytesToAdd(sourceChars.charAt(sourceChars.limit() - 1));
                    continue;
                }
                ahead = null;
            }
        }
        if (from.hasRemaining()) {
            byte[] leftOver = new byte[from.remaining()];
            from.get(leftOver, 0, from.remaining());
            this.underflow = leftOver;
        }
        converted = this.convert(sourceChars);
        return converted;
    }

    public ByteBuffer convert(ByteBuffer from) {
        return this.convert(from, null);
    }
}

