/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http.service;

import android.app.Service;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import com.peirr.http.service.ISimpleHttpServiceClient;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class SimpleHttpServiceServerHandler
extends Handler {
    private final WeakReference<ISimpleHttpServiceClient> reference;
    private final ArrayList<Messenger> clients = new ArrayList();

    public SimpleHttpServiceServerHandler(ISimpleHttpServiceClient reference) {
        this.reference = new WeakReference<ISimpleHttpServiceClient>(reference);
    }

    public void handleMessage(Message msg) {
        ISimpleHttpServiceClient service = (ISimpleHttpServiceClient)this.reference.get();
        if (service != null) {
            switch (msg.what) {
                case -10: {
                    this.clients.add(msg.replyTo);
                    Message message = Message.obtain(null, (int)-10);
                    this.send(message);
                    break;
                }
                case -20: {
                    this.clients.remove(msg.replyTo);
                    Message message1 = Message.obtain(null, (int)-20);
                    this.send(message1);
                    break;
                }
                case -30: {
                    ((Service)service).stopSelf();
                    break;
                }
                case 12: {
                    service.bootup((Integer)msg.obj);
                    break;
                }
                case 14: {
                    service.shutdown();
                    break;
                }
                case 16: {
                    service.info((Integer)msg.obj);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
            this.removeMessages(msg.what);
        }
    }

    public void send(Message message) {
        for (int i = 0; i < this.clients.size(); ++i) {
            try {
                this.clients.get(i).send(message);
                continue;
            }
            catch (Exception e) {
                this.clients.remove(i);
            }
        }
    }

    ArrayList<Messenger> getClients() {
        return this.clients;
    }
}

