/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http.service;

import android.os.Handler;
import android.os.Message;
import com.peirr.http.service.ISimpleHttpServiceServer;
import com.peirr.http.service.SimpleHttpInfo;
import java.lang.ref.WeakReference;

public class SimpleHttpServiceClientHandler
extends Handler {
    private final WeakReference<ISimpleHttpServiceServer> reference;

    public SimpleHttpServiceClientHandler(ISimpleHttpServiceServer reference) {
        this.reference = new WeakReference<ISimpleHttpServiceServer>(reference);
    }

    public void handleMessage(Message msg) {
        ISimpleHttpServiceServer stub = (ISimpleHttpServiceServer)this.reference.get();
        if (stub != null) {
            switch (msg.what) {
                case -10: {
                    stub.onBoundServiceConnectionChanged(true);
                    break;
                }
                case -20: {
                    stub.onBoundServiceConnectionChanged(false);
                    break;
                }
                case -30: {
                    stub.onBoundServiceConnectionChanged(false);
                    break;
                }
                case 1: {
                    stub.onHttpServerStateChanged(1, (SimpleHttpInfo)msg.obj);
                    break;
                }
                case 2: {
                    stub.onHttpServerStateChanged(2, (SimpleHttpInfo)msg.obj);
                    break;
                }
                case 3: {
                    stub.onHttpServerStateChanged(3, (SimpleHttpInfo)msg.obj);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
            this.removeMessages(msg.what);
        }
    }
}

