/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http.service;

import android.app.Service;
import android.content.Intent;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.peirr.http.SimpleHttpServer;
import com.peirr.http.service.ISimpleHttpServiceClient;
import com.peirr.http.service.SimpleHttpInfo;
import com.peirr.http.service.SimpleHttpServiceConnector;
import java.lang.ref.WeakReference;
import java.security.SecureRandom;
import mbanje.kurt.remote_service.RemoteService;
import mbanje.kurt.remote_service.RemoteServiceType;

@RemoteService(value=RemoteServiceType.STARTED_BOUND)
public class SimpleHttpService
extends Service
implements ISimpleHttpServiceClient {
    String TAG = SimpleHttpService.class.getSimpleName();
    public static final int STATE_RUNNING = 1;
    public static final int STATE_STOPPED = 2;
    public static final int STATE_ERROR = 3;
    public static final int REQUEST_START = 12;
    public static final int REQUEST_STOP = 14;
    public static final int REQUEST_INFO = 16;
    private String ip;
    private int port;
    private SimpleHttpServiceConnector connector;
    private SimpleHttpServer server;
    private String serverRoot = "";
    private Handler serverHandler = new ServerHandler(this);
    private SecureRandom random = new SecureRandom();
    private int currentState = 2;

    public SimpleHttpService() {
        this.connector = new SimpleHttpServiceConnector(this);
    }

    public IBinder onBind(Intent intent) {
        return this.connector.getBinder();
    }

    public void onCreate() {
        super.onCreate();
        this.port = this.randomPort(9960, 9999);
    }

    @Override
    public void bootup(int port) {
        Log.d((String)this.TAG, (String)"bootup()");
        try {
            if (port != 0) {
                this.port = port;
            }
            SimpleHttpInfo info = this.getInfo();
            this.server = new SimpleHttpServer(this.serverHandler, this.serverRoot, info.ip, info.port, this.getApplicationContext());
            this.server.start();
            this.currentState = 1;
            Log.d((String)this.TAG, (String)"boot success...");
        }
        catch (Exception e) {
            this.currentState = 3;
            Log.d((String)this.TAG, (String)"boot failure...");
            Log.e((String)this.TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        this.connector.send(this.currentState, new SimpleHttpInfo(this.ip, port));
    }

    @Override
    public void shutdown() {
        Log.d((String)this.TAG, (String)"shutdown()");
        this.currentState = 2;
        if (this.server != null) {
            this.server.stopServer();
        }
        this.connector.send(2, this.getInfo());
        this.stopSelf();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.currentState == 1) {
            this.shutdown();
        }
    }

    @Override
    public void info(int port) {
        if (port != 0) {
            this.port = port;
        }
        Log.d((String)this.TAG, (String)"info()");
        this.connector.send(this.currentState, this.getInfo());
    }

    public String getIp() {
        WifiManager wifiManager = (WifiManager)this.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (wifiInfo.getSupplicantState() != SupplicantState.COMPLETED) {
            return null;
        }
        return this.intToIp(wifiInfo.getIpAddress());
    }

    private SimpleHttpInfo getInfo() {
        if (TextUtils.isEmpty((CharSequence)this.ip)) {
            this.ip = this.getIp();
        }
        return new SimpleHttpInfo(this.ip, this.port);
    }

    private String intToIp(int i) {
        return (i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }

    private int randomPort(int min, int max) {
        return this.random.nextInt(max - min + 1) + min;
    }

    private static class ServerHandler
    extends Handler {
        final WeakReference<SimpleHttpService> reference;

        private ServerHandler(SimpleHttpService service) {
            this.reference = new WeakReference<SimpleHttpService>(service);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
        }
    }
}

