/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.recorder.wifi;

import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.pecpwee.lib.envmock.AbsConfig;
import com.pecpwee.lib.envmock.RecordConfig;
import com.pecpwee.lib.envmock.hook.CenterServiceManager;
import com.pecpwee.lib.envmock.model.wifi.GetConnectionInfo;
import com.pecpwee.lib.envmock.model.wifi.GetScanResult;
import com.pecpwee.lib.envmock.recorder.AbsRecorder;
import com.pecpwee.lib.envmock.utils.TimerJob;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class WifiRecorder
extends AbsRecorder {
    private TimerJob wifiTimedJob = new TimerJob();
    private WifiManager wifiManager = (WifiManager)CenterServiceManager.getInstance().getServiceFetcher("wifi").getOrigManagerObj();

    public WifiRecorder() {
        this.wifiTimedJob = new TimerJob().setInterval(RecordConfig.getInstance().getSampleInterval()).setRunnable(new Runnable(){

            @Override
            public void run() {
                WifiRecorder.this.wifiManager.startScan();
                WifiRecorder.this.doRecord(new GetScanResult(WifiRecorder.this.filterList(WifiRecorder.this.wifiManager.getScanResults())));
                WifiInfo wifiInfo = WifiRecorder.this.wifiManager.getConnectionInfo();
                WifiRecorder.this.doRecord(new GetConnectionInfo(wifiInfo));
            }
        });
    }

    private List<ScanResult> filterList(List<ScanResult> list) {
        Collections.sort(list, new Comparator<ScanResult>(){

            @Override
            public int compare(ScanResult o1, ScanResult o2) {
                if (o1.level < o2.level) {
                    return 1;
                }
                if (o1.level > o2.level) {
                    return -1;
                }
                return 0;
            }
        });
        while (list.size() > RecordConfig.getInstance().getWifiScanCountUpperLimit()) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    @Override
    public void onStart() {
        this.wifiTimedJob.setInterval(RecordConfig.getInstance().getSampleInterval());
        this.wifiTimedJob.start();
    }

    @Override
    public void onStop() {
        this.wifiTimedJob.stop();
    }

    @Override
    public String getDefaultFilePath() {
        return AbsConfig.DEFAULT_FILEPATH_WIFI;
    }
}

