/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.recorder.telephony;

import android.content.Context;
import android.os.Bundle;
import com.pecpwee.lib.envmock.AbsConfig;
import com.pecpwee.lib.envmock.RecordConfig;
import com.pecpwee.lib.envmock.hook.CenterServiceManager;
import com.pecpwee.lib.envmock.model.telephony.GetCellLocation;
import com.pecpwee.lib.envmock.model.telephony.GetNetworkType;
import com.pecpwee.lib.envmock.recorder.AbsRecorder;
import com.pecpwee.lib.envmock.utils.TimerJob;
import com.pecpwee.lib.envmock.utils.reflect.MethodUtils;
import java.lang.reflect.InvocationTargetException;

public class TelephonyRecorder
extends AbsRecorder {
    private TimerJob cellTimedJob = new TimerJob();
    private Context context;
    private Object mOrigBinderObj;

    public TelephonyRecorder(Context context) {
        this.context = context;
        this.mOrigBinderObj = CenterServiceManager.getInstance().getServiceFetcher("phone").getOrigBinderProxyObj();
        this.cellTimedJob.setInterval(RecordConfig.getInstance().getSampleInterval()).setRunnable(new Runnable(){

            @Override
            public void run() {
                Bundle bundle = TelephonyRecorder.this.getCellLocation();
                TelephonyRecorder.this.doRecord(new GetCellLocation(bundle));
                TelephonyRecorder.this.doRecord(new GetNetworkType(TelephonyRecorder.this.getNetworkType()));
            }
        });
    }

    public int getNetworkType() {
        try {
            return (Integer)MethodUtils.invokeMethod(this.mOrigBinderObj, "getNetworkType", new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return -10;
    }

    public Bundle getCellLocation() {
        Bundle bundle = null;
        try {
            bundle = (Bundle)MethodUtils.invokeMethod(this.mOrigBinderObj, "getCellLocation", this.context.getPackageName());
        }
        catch (NoSuchMethodException e) {
            try {
                bundle = (Bundle)MethodUtils.invokeMethod(this.mOrigBinderObj, "getCellLocation", new Object[0]);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return bundle;
    }

    @Override
    public void onStart() {
        this.cellTimedJob.setInterval(RecordConfig.getInstance().getSampleInterval());
        this.cellTimedJob.start();
    }

    @Override
    public void onStop() {
        this.cellTimedJob.stop();
    }

    @Override
    public String getDefaultFilePath() {
        return AbsConfig.DEFAULT_FILEPATH_CELL;
    }
}

