/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.recorder.location;

import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import com.pecpwee.lib.envmock.AbsConfig;
import com.pecpwee.lib.envmock.EnvMockInstaller;
import com.pecpwee.lib.envmock.hook.CenterServiceManager;
import com.pecpwee.lib.envmock.model.location.OnFirstFix;
import com.pecpwee.lib.envmock.model.location.OnGpsStarted;
import com.pecpwee.lib.envmock.model.location.OnGpsStopped;
import com.pecpwee.lib.envmock.model.location.OnLocationChanged;
import com.pecpwee.lib.envmock.model.location.OnNmeaReceived;
import com.pecpwee.lib.envmock.model.location.OnProviderDisable;
import com.pecpwee.lib.envmock.model.location.OnProviderEnabled;
import com.pecpwee.lib.envmock.model.location.OnStatusChanged;
import com.pecpwee.lib.envmock.model.location.OnSvStatusChanged;
import com.pecpwee.lib.envmock.player.location.LM.IGpsStatusListener;
import com.pecpwee.lib.envmock.player.location.N.IGnssStatusListener;
import com.pecpwee.lib.envmock.recorder.AbsRecorder;
import com.pecpwee.lib.envmock.utils.LogUtils;
import com.pecpwee.lib.envmock.utils.reflect.MethodUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class GpsRecorder
extends AbsRecorder {
    private LocationManager locationManager;
    GpsStatus.NmeaListener nmeaListener = new GpsStatus.NmeaListener(){

        public void onNmeaReceived(long timestamp, String nmea) {
            GpsRecorder.this.doRecord(new OnNmeaReceived(timestamp, nmea));
        }
    };
    LocationListener locationlistner = new LocationListener(){

        public void onLocationChanged(Location location) {
            GpsRecorder.this.doRecord(new OnLocationChanged(location));
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            GpsRecorder.this.doRecord(new OnStatusChanged(provider, status, extras));
        }

        public void onProviderEnabled(String provider) {
            GpsRecorder.this.doRecord(new OnProviderEnabled(provider));
        }

        public void onProviderDisabled(String provider) {
            GpsRecorder.this.doRecord(new OnProviderDisable(provider));
        }
    };
    private Object gpsStatusTrasnportListener = this.getGpsStatusTransport();

    public GpsRecorder() {
        this.locationManager = (LocationManager)CenterServiceManager.getInstance().getServiceFetcher("location").getOrigManagerObj();
    }

    @Override
    public void onStart() {
        try {
            this.locationManager.requestLocationUpdates("gps", 1000L, 1.0f, this.locationlistner);
            this.locationManager.addNmeaListener(this.nmeaListener);
            this.registerGpsStatusListener();
        }
        catch (SecurityException e) {
            LogUtils.log(e);
        }
    }

    @Override
    public void onStop() {
        this.locationManager.removeNmeaListener(this.nmeaListener);
        this.locationManager.removeUpdates(this.locationlistner);
        this.removeGpsStatusListener();
    }

    @Override
    public String getDefaultFilePath() {
        return AbsConfig.DEFAULT_FILEPATH_GPS;
    }

    private void registerGpsStatusListener() {
        Object binderInterfaceObj = CenterServiceManager.getInstance().getServiceFetcher("location").getOrigBinderProxyObj();
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                MethodUtils.invokeMethod(binderInterfaceObj, "registerGnssStatusCallback", this.gpsStatusTrasnportListener, CenterServiceManager.getInstance().getPackageName());
            } else if (Build.VERSION.SDK_INT >= 21) {
                MethodUtils.invokeMethod(binderInterfaceObj, "addGpsStatusListener", this.gpsStatusTrasnportListener, CenterServiceManager.getInstance().getPackageName());
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void removeGpsStatusListener() {
        Object binderObj = CenterServiceManager.getInstance().getServiceFetcher("location").getOrigBinderProxyObj();
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                MethodUtils.invokeMethod(binderObj, "unregisterGnssStatusCallback", this.gpsStatusTrasnportListener);
            } else if (Build.VERSION.SDK_INT >= 21) {
                MethodUtils.invokeMethod(binderObj, "removeGpsStatusListener", this.gpsStatusTrasnportListener);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Object getGpsStatusTransport() {
        Class<?> clazz = null;
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                clazz = Class.forName("android.location.IGnssStatusListener");
            } else if (Build.VERSION.SDK_INT >= 21) {
                clazz = Class.forName("android.location.IGpsStatusListener");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Object obj = Proxy.newProxyInstance(EnvMockInstaller.class.getClassLoader(), new Class[]{IBinder.class, IInterface.class, clazz}, (InvocationHandler)new GpsTransportRecord());
        return obj;
    }

    private class GpsTransportRecord
    implements InvocationHandler {
        private IBinder baseObj;

        public GpsTransportRecord() {
            if (Build.VERSION.SDK_INT >= 24) {
                this.baseObj = new IGnssStatusListener(){

                    @Override
                    public void onSvStatusChanged(int _arg01, int[] _arg1, float[] _arg12, float[] arg3, float[] _arg4) {
                        GpsRecorder.this.doRecord(new OnSvStatusChanged(_arg01, _arg1, _arg12, arg3, _arg4, 0, 0, 0));
                    }

                    @Override
                    public void onGnssStarted() {
                        GpsRecorder.this.doRecord(new OnGpsStarted());
                    }

                    @Override
                    public void onGnssStopped() {
                        GpsRecorder.this.doRecord(new OnGpsStopped());
                    }

                    @Override
                    public void onFirstFix(int ttff) {
                        GpsRecorder.this.doRecord(new OnFirstFix(ttff));
                    }
                };
            } else if (Build.VERSION.SDK_INT >= 21) {
                this.baseObj = new IGpsStatusListener(){

                    @Override
                    public void onSvStatusChanged(int _arg01, int[] _arg1, float[] _arg12, float[] arg3, float[] _arg4, int _arg5, int _arg6, int _arg7) {
                        GpsRecorder.this.doRecord(new OnSvStatusChanged(_arg01, _arg1, _arg12, arg3, _arg4, _arg5, _arg6, _arg7));
                    }

                    @Override
                    public void onGpsStarted() {
                        GpsRecorder.this.doRecord(new OnGpsStarted());
                    }

                    @Override
                    public void onGpsStopped() {
                        GpsRecorder.this.doRecord(new OnGpsStopped());
                    }

                    @Override
                    public void onFirstFix(int ttff) {
                        GpsRecorder.this.doRecord(new OnFirstFix(ttff));
                    }
                };
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.baseObj, args);
        }
    }
}

