/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.recorder;

import android.text.TextUtils;
import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.model.AbsTimeModel;
import com.pecpwee.lib.envmock.recorder.RecordListener;
import com.pecpwee.lib.envmock.utils.GsonFactory;
import com.pecpwee.lib.envmock.utils.LogUtils;
import com.pecpwee.lib.envmock.utils.ThreadManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

public abstract class AbsRecorder {
    private static final String TAG = "AbsRecorder ";
    protected File mFile;
    private StringBuilder sb = new StringBuilder();
    private CountDownLatch latchlock = null;
    private ArrayList<RecordListener> listeners = new ArrayList();

    public final void start() {
        if (this.latchlock != null) {
            try {
                this.latchlock.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.sb == null) {
            this.sb = new StringBuilder();
        }
        this.doRecord(-1, String.valueOf(System.currentTimeMillis()));
        this.onStart();
    }

    public final void stop() {
        this.onStop();
        this.latchlock = new CountDownLatch(1);
        this.doRecord(-2, String.valueOf(System.currentTimeMillis()));
        this.storeRecord(this.mFile, this.sb);
        this.sb = null;
    }

    public abstract void onStart();

    public abstract void onStop();

    public synchronized void setFilePath(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new IllegalArgumentException();
        }
        this.mFile = new File(filePath);
    }

    public void addRecordListener(RecordListener recordListener) {
        this.listeners.add(recordListener);
    }

    public void removeRecordListener(RecordListener listener) {
        this.listeners.remove(listener);
    }

    private void storeRecord(final File file, final StringBuilder sb) {
        ThreadManager.RECORD_HANDLER.post(new Runnable(){

            @Override
            public void run() {
                if (file.exists()) {
                    file.delete();
                }
                AbsRecorder.writeSDCardFile(file, sb.toString(), true);
                AbsRecorder.this.latchlock.countDown();
            }
        });
    }

    public abstract String getDefaultFilePath();

    protected synchronized void doRecord(int type, String objStr) {
        if (this.mFile == null) {
            File dir = new File(PlayConfig.DEFAULT_RECORD_DIR_PATH);
            dir.mkdirs();
            this.mFile = new File(this.getDefaultFilePath());
        }
        this.sb.append(type + "\n" + objStr + "\n");
    }

    protected void doRecord(AbsTimeModel obj) {
        LogUtils.d("AbsRecorder doRecord " + obj.getClass().getSimpleName());
        this.notifyNewRecord(obj);
        this.doRecord(obj.getType(), GsonFactory.getGson().toJson((Object)obj));
    }

    private void notifyNewRecord(AbsTimeModel obj) {
        for (RecordListener listener : this.listeners) {
            listener.onRecordNew(obj);
        }
    }

    public static void writeSDCardFile(File file, String content, boolean append) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, append));
            bos.write(content.getBytes("UTF-8"));
            bos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

