/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.player.wifi;

import android.net.wifi.ScanResult;
import android.os.SystemClock;
import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.middle.wifi.IWifiPlayerListener;
import com.pecpwee.lib.envmock.model.wifi.GetConnectionInfo;
import com.pecpwee.lib.envmock.model.wifi.GetScanResult;
import com.pecpwee.lib.envmock.player.AbsPlayer;
import com.pecpwee.lib.envmock.player.ILineDataParser;
import com.pecpwee.lib.envmock.utils.GsonFactory;
import java.util.List;

public class WifiPlayer
extends AbsPlayer<IWifiPlayerListener> {
    public WifiPlayer(IWifiPlayerListener listenr) {
        super(listenr);
    }

    @Override
    public String getDefaultFilePath() {
        return PlayConfig.DEFAULT_FILEPATH_WIFI;
    }

    @Override
    public String getConfigFilePath() {
        return PlayConfig.getInstance().getWifiRecordFilePath();
    }

    @Override
    protected ILineDataParser getParser() {
        return new AbsPlayer.AbsParser(){

            @Override
            protected void parseValue(int type, String line) {
                switch (type) {
                    case 1: {
                        final GetScanResult getScanResultObj = (GetScanResult)GsonFactory.getGson().fromJson(line, GetScanResult.class);
                        WifiPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(getScanResultObj.getTime()){

                            @Override
                            public void run() {
                                List<ScanResult> scanResults = getScanResultObj.getScanResults();
                                for (ScanResult sc : scanResults) {
                                    sc.timestamp = SystemClock.elapsedRealtime() * 1000L;
                                }
                                ((IWifiPlayerListener)WifiPlayer.this.mListener).setScanWifiList(getScanResultObj.getScanResults());
                            }
                        });
                        break;
                    }
                    case 2: {
                        final GetConnectionInfo getConnectionInfoObj = (GetConnectionInfo)GsonFactory.getGson().fromJson(line, GetConnectionInfo.class);
                        WifiPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(getConnectionInfoObj.getTime()){

                            @Override
                            public void run() {
                                ((IWifiPlayerListener)WifiPlayer.this.mListener).setConnectionWifiInfo(getConnectionInfoObj.getWifiInfo());
                            }
                        });
                    }
                }
            }
        };
    }
}

