/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.player.location;

import android.location.Location;
import android.os.Bundle;
import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.middle.location.IGpsPlayerListener;
import com.pecpwee.lib.envmock.model.AbsTimeModel;
import com.pecpwee.lib.envmock.model.location.OnFirstFix;
import com.pecpwee.lib.envmock.model.location.OnLocationChanged;
import com.pecpwee.lib.envmock.model.location.OnNmeaReceived;
import com.pecpwee.lib.envmock.model.location.OnProviderDisable;
import com.pecpwee.lib.envmock.model.location.OnProviderEnabled;
import com.pecpwee.lib.envmock.model.location.OnStatusChanged;
import com.pecpwee.lib.envmock.model.location.OnSvStatusChanged;
import com.pecpwee.lib.envmock.player.AbsPlayer;
import com.pecpwee.lib.envmock.player.ILineDataParser;
import com.pecpwee.lib.envmock.utils.GsonFactory;
import java.util.ArrayList;

public class GpsPlayer
extends AbsPlayer<IGpsPlayerListener> {
    private static final String TAG = "GpsPlayer ";
    private ArrayList<Location> mGpsLocationList = new ArrayList();
    private Location mLastPlayedLocation;

    public GpsPlayer(IGpsPlayerListener listener) {
        super(listener);
    }

    @Override
    public String getDefaultFilePath() {
        return PlayConfig.DEFAULT_FILEPATH_GPS;
    }

    @Override
    public String getConfigFilePath() {
        return PlayConfig.getInstance().getGpsRecordFilePath();
    }

    @Override
    protected ILineDataParser getParser() {
        return new Parser();
    }

    public ArrayList getCompleteGpsPathLocation() {
        if (!this.isDataLoadedOK()) {
            return null;
        }
        return this.mGpsLocationList;
    }

    public Location getLastPlayedLocation() {
        return this.mLastPlayedLocation;
    }

    public void resetLastPlayedLocation() {
        this.mLastPlayedLocation = null;
    }

    class Parser
    extends AbsPlayer.AbsParser {
        Parser() {
        }

        @Override
        protected void parseValue(int type, String line) {
            switch (type) {
                case 1: {
                    OnLocationChanged obj = (OnLocationChanged)GsonFactory.getGson().fromJson(line, OnLocationChanged.class);
                    final Location location = obj.getLocation();
                    GpsPlayer.this.mGpsLocationList.add(location);
                    GpsPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(obj.getTime()){

                        @Override
                        public void run() {
                            ((IGpsPlayerListener)GpsPlayer.this.mListener).onLocationChanged(location);
                            GpsPlayer.this.mLastPlayedLocation = location;
                        }
                    });
                    break;
                }
                case 9: {
                    final OnNmeaReceived nmeaParam = (OnNmeaReceived)GsonFactory.getGson().fromJson(line, OnNmeaReceived.class);
                    GpsPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(nmeaParam.getTime()){

                        @Override
                        public void run() {
                            ((IGpsPlayerListener)GpsPlayer.this.mListener).onNmeaReceived(nmeaParam.getTime(), nmeaParam.getNmea());
                        }
                    });
                    break;
                }
                case 2: {
                    final OnStatusChanged statusChangedParam = (OnStatusChanged)GsonFactory.getGson().fromJson(line, OnStatusChanged.class);
                    Bundle b = statusChangedParam.getExtras();
                    long time = statusChangedParam.getTime();
                    GpsPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(statusChangedParam.getTime()){

                        @Override
                        public void run() {
                            ((IGpsPlayerListener)GpsPlayer.this.mListener).onStatusChanged(statusChangedParam.getProvider(), statusChangedParam.getStatus(), statusChangedParam.getExtras());
                        }
                    });
                    break;
                }
                case 3: {
                    final OnProviderEnabled model = (OnProviderEnabled)GsonFactory.getGson().fromJson(line, OnProviderEnabled.class);
                    GpsPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(model.getTime()){

                        @Override
                        public void run() {
                            ((IGpsPlayerListener)GpsPlayer.this.mListener).onProviderEnabled(model.getProviderName());
                        }
                    });
                    break;
                }
                case 4: {
                    final OnProviderDisable model = (OnProviderDisable)GsonFactory.getGson().fromJson(line, OnProviderDisable.class);
                    GpsPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(model.getTime()){

                        @Override
                        public void run() {
                            ((IGpsPlayerListener)GpsPlayer.this.mListener).onProviderDisabled(model.getProviderName());
                        }
                    });
                    break;
                }
                case 7: {
                    final OnFirstFix firstfix = (OnFirstFix)GsonFactory.getGson().fromJson(line, OnFirstFix.class);
                    GpsPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(firstfix.getTime()){

                        @Override
                        public void run() {
                            ((IGpsPlayerListener)GpsPlayer.this.mListener).onFirstFix(firstfix.getFtt());
                        }
                    });
                    break;
                }
                case 5: {
                    AbsTimeModel model = (AbsTimeModel)GsonFactory.getGson().fromJson(line, AbsTimeModel.class);
                    GpsPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(model.getTime()){

                        @Override
                        public void run() {
                            ((IGpsPlayerListener)GpsPlayer.this.mListener).onGpsStarted();
                        }
                    });
                    break;
                }
                case 6: {
                    AbsTimeModel model = (AbsTimeModel)GsonFactory.getGson().fromJson(line, AbsTimeModel.class);
                    GpsPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(model.getTime()){

                        @Override
                        public void run() {
                            ((IGpsPlayerListener)GpsPlayer.this.mListener).onGpsStopped();
                        }
                    });
                    break;
                }
                case 8: {
                    final OnSvStatusChanged onSvStatusChanged = (OnSvStatusChanged)GsonFactory.getGson().fromJson(line, OnSvStatusChanged.class);
                    GpsPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(onSvStatusChanged.getTime()){

                        @Override
                        public void run() {
                            ((IGpsPlayerListener)GpsPlayer.this.mListener).onSvStatusChanged(onSvStatusChanged.svCount, onSvStatusChanged.prns, onSvStatusChanged.snrs, onSvStatusChanged.elevations, onSvStatusChanged.azimuths, onSvStatusChanged.ephemerisMask, onSvStatusChanged.almanacMask, onSvStatusChanged.usedInFixMask);
                        }
                    });
                    break;
                }
            }
        }
    }
}

