/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.player.connect;

import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.middle.connect.IConnectivityListener;
import com.pecpwee.lib.envmock.model.connect.GetActiveNetwork;
import com.pecpwee.lib.envmock.model.connect.GetAllNetworks;
import com.pecpwee.lib.envmock.player.AbsPlayer;
import com.pecpwee.lib.envmock.player.ILineDataParser;
import com.pecpwee.lib.envmock.utils.GsonFactory;

public class ConnPlayer
extends AbsPlayer<IConnectivityListener> {
    public ConnPlayer(IConnectivityListener listener) {
        super(listener);
    }

    @Override
    public String getDefaultFilePath() {
        return PlayConfig.DEFAULT_FILEPATH_CONN;
    }

    @Override
    public String getConfigFilePath() {
        return PlayConfig.getInstance().getConnRecordFilePath();
    }

    @Override
    protected ILineDataParser getParser() {
        return new AbsPlayer.AbsParser(){

            @Override
            protected void parseValue(int type, String line) {
                switch (type) {
                    case 1: {
                        final GetActiveNetwork getActiveNetwork = (GetActiveNetwork)GsonFactory.getGson().fromJson(line, GetActiveNetwork.class);
                        ConnPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(getActiveNetwork.getTime()){

                            @Override
                            public void run() {
                                ((IConnectivityListener)ConnPlayer.this.mListener).setActiveNetwork(getActiveNetwork.getNetwork(), getActiveNetwork.getNetworkInfo());
                            }
                        });
                        break;
                    }
                    case 2: {
                        final GetAllNetworks getAllNetworks = (GetAllNetworks)GsonFactory.getGson().fromJson(line, GetAllNetworks.class);
                        ConnPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(getAllNetworks.getTime()){

                            @Override
                            public void run() {
                                ((IConnectivityListener)ConnPlayer.this.mListener).setAllNetworks(getAllNetworks.getAllNetworks(), getAllNetworks.getNetworkInfos(), getAllNetworks.getNetworkCapabilities());
                            }
                        });
                        break;
                    }
                }
            }
        };
    }
}

