/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.player;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.player.ILineDataParser;
import com.pecpwee.lib.envmock.player.PlayerDataSource;
import com.pecpwee.lib.envmock.utils.LogUtils;
import com.pecpwee.lib.envmock.utils.ThreadManager;
import java.util.concurrent.CountDownLatch;

public abstract class AbsPlayer<T> {
    private static final String TAG = "AbsPlayer ";
    protected T mListener;
    private static final int HANDLER_DO_PLAY = 1;
    private int mCurrentTimedActionIndex = 0;
    private volatile boolean isNeedNextAction = false;
    private float mStartPlayOffset = 0.0f;
    private long mCurrentStartTime;
    private long mFileRecordStartTime;
    private long mFileRecordStopTime;
    private long mAcutalStartPastTimestamp;
    private CountDownLatch latchLock = null;
    private Handler workHandler = new Handler(ThreadManager.PLAY_LOOPER);
    private PlayerDataSource mDataSource;
    private Handler mainHandler = new Handler(ThreadManager.MAIN_LOOPER){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AbsPlayer.this.doAction();
                    AbsPlayer.this.scheduleAction(AbsPlayer.this.mCurrentTimedActionIndex + 1);
                    AbsPlayer.this.mCurrentTimedActionIndex++;
                }
            }
        }
    };

    public final void setListener(T listener) {
        this.mListener = listener;
    }

    public AbsPlayer(T listener) {
        this.mListener = listener;
        this.mDataSource = new PlayerDataSource();
    }

    public float getCurrentPlayProgress() {
        return (float)this.mCurrentTimedActionIndex / (float)this.mDataSource.getSize();
    }

    protected void addTimedAction(TimedRunnable timeRunnable) {
        this.mDataSource.addTimedAction(timeRunnable);
    }

    public final synchronized void startPlay(long startBaseTime) {
        this.isNeedNextAction = true;
        this.mCurrentStartTime = startBaseTime;
        this.mStartPlayOffset = PlayConfig.getInstance().getStartPlayPercentage();
        this.latchLock = new CountDownLatch(1);
        this.workHandler.post(new Runnable(){

            @Override
            public void run() {
                AbsPlayer.this.tryLoadData();
                AbsPlayer.this.dealWithPlayOffset();
                AbsPlayer.this.scheduleAction(AbsPlayer.this.mCurrentTimedActionIndex);
                AbsPlayer.this.latchLock.countDown();
            }
        });
        LogUtils.d(this.getClass().getSimpleName() + "doStartPlay");
    }

    public void tryLoadData() {
        String path = this.getConfigFilePath();
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = this.getDefaultFilePath();
        }
        this.mDataSource.loadDataIfNeed(path, this.getParser());
    }

    public boolean isDataLoadedOK() {
        return this.mDataSource.isDataLoadedOk();
    }

    public abstract String getDefaultFilePath();

    public abstract String getConfigFilePath();

    private synchronized void doAction() {
        LogUtils.d(TAG + this.getDefaultFilePath() + "doAction");
        if (this.mCurrentTimedActionIndex >= this.mDataSource.getSize()) {
            this.stopPlay();
            return;
        }
        TimedRunnable action = this.mDataSource.getAction(this.mCurrentTimedActionIndex);
        this.mainHandler.post((Runnable)action);
    }

    private void scheduleAction(int actionIndex) {
        if (!this.isNeedNextAction) {
            return;
        }
        if (actionIndex >= this.mDataSource.getSize()) {
            return;
        }
        long nextOnePastTime = this.mDataSource.getAction(actionIndex).getTime();
        long intervalTime = nextOnePastTime - this.mAcutalStartPastTimestamp + this.mCurrentStartTime - System.currentTimeMillis();
        intervalTime = intervalTime < 0L ? 0L : intervalTime;
        LogUtils.d(TAG + this.getDefaultFilePath() + " intervalTime " + intervalTime);
        this.mainHandler.sendEmptyMessageDelayed(1, intervalTime);
    }

    protected abstract ILineDataParser getParser();

    private void dealWithPlayOffset() {
        long recordTimeInterval = this.mFileRecordStopTime - this.mFileRecordStartTime;
        LogUtils.d("mFileRecordStartTime" + this.mFileRecordStartTime);
        LogUtils.d("mFileRecordStopTime" + this.mFileRecordStopTime);
        LogUtils.d("recordTimeInterval" + recordTimeInterval);
        long startOffsetTime = (long)((float)recordTimeInterval * this.mStartPlayOffset);
        LogUtils.d("startOffsetTime" + startOffsetTime);
        for (int i = 0; i < this.mDataSource.getSize(); ++i) {
            if (this.mDataSource.getAction(i).getTime() - this.mFileRecordStartTime <= startOffsetTime) continue;
            this.mCurrentTimedActionIndex = i;
            LogUtils.d("mCurrentTimedActionIndex" + this.mCurrentTimedActionIndex);
            this.mAcutalStartPastTimestamp = this.mDataSource.getAction(i).getTime();
            LogUtils.d("mAcutalStartPastTimestamp" + this.mAcutalStartPastTimestamp);
            break;
        }
    }

    public void notifyDataSourceChanged() {
        this.mDataSource.setNeedReloadData();
    }

    public final synchronized void resetPlayProgress() {
        this.mCurrentTimedActionIndex = 0;
    }

    public final synchronized void stopPlay() {
        if (this.latchLock != null) {
            try {
                this.latchLock.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.isNeedNextAction = false;
        this.mainHandler.removeMessages(1);
        LogUtils.d(this.getClass().getSimpleName() + "doStopPlay");
    }

    public abstract class AbsParser
    implements ILineDataParser {
        private int type;
        private boolean isNeedParsingType = true;

        @Override
        public void onNewLineGot(String line) {
            if (this.isNeedParsingType) {
                this.type = this.parseType(line);
                this.isNeedParsingType = false;
            } else {
                if (this.type == -1) {
                    long time = 0L;
                    time = Long.parseLong(line);
                    AbsPlayer.this.mFileRecordStartTime = time;
                    AbsPlayer.this.mAcutalStartPastTimestamp = time;
                } else if (this.type == -2) {
                    long time = 0L;
                    time = Long.parseLong(line);
                    AbsPlayer.this.mFileRecordStopTime = time;
                } else {
                    this.parseValue(this.type, line);
                }
                this.isNeedParsingType = true;
            }
        }

        protected int parseType(String line) {
            return Integer.valueOf(line);
        }

        protected abstract void parseValue(int var1, String var2);
    }

    public static abstract class TimedRunnable
    implements Runnable {
        long time = 0L;

        public TimedRunnable(long time) {
            this.time = time;
        }

        @Override
        public abstract void run();

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }
}

