/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.middle.connect;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import com.pecpwee.lib.envmock.hook.CenterServiceManager;
import com.pecpwee.lib.envmock.middle.IMiddleService;
import com.pecpwee.lib.envmock.middle.connect.IConnectivityListener;
import com.pecpwee.lib.envmock.utils.reflect.MethodUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class MiddleConnectivityManager
implements IMiddleService,
IConnectivityListener {
    private HashMap<Network, NetworkWrapper> mNetworkMap = new HashMap();
    private Network[] mAllNetworks;
    private NetworkInfo[] mAllNetworkInfos;
    private NetworkCapabilities[] mAllNetworkCapacities;
    private NetworkInfo mActiveNetworkInfo;
    private Network mActiveNetwork;
    private ConnectivityManager connManager = (ConnectivityManager)CenterServiceManager.getInstance().getServiceFetcher("connectivity").getOrigManagerObj();

    @Override
    public void resetMockData() {
        this.mActiveNetwork = null;
        this.mAllNetworks = null;
        this.mAllNetworkCapacities = null;
        this.mAllNetworkInfos = null;
        this.mNetworkMap.clear();
    }

    public synchronized NetworkInfo[] getAllNetworkInfo() {
        return this.mAllNetworkInfos;
    }

    public synchronized NetworkCapabilities[] getAllNetworkCapacities() {
        return this.mAllNetworkCapacities;
    }

    public synchronized Network getActiveNetwork() {
        return this.mActiveNetwork;
    }

    public synchronized NetworkInfo getActiveNetworkInfo() {
        return this.mActiveNetworkInfo;
    }

    public synchronized NetworkInfo getNetworkInfo(int nettype) {
        if (this.getActiveNetworkInfo().getType() == nettype) {
            return this.mActiveNetworkInfo;
        }
        for (Network network : this.mNetworkMap.keySet()) {
            NetworkWrapper valueWrapper = this.mNetworkMap.get(network);
            if (valueWrapper.networkInfo.getType() != nettype) continue;
            return valueWrapper.networkInfo;
        }
        return this.createDefaultNetworkInfo(nettype);
    }

    private NetworkInfo createDefaultNetworkInfo(int networkType) {
        NetworkInfo networkinfo = null;
        try {
            networkinfo = MethodUtils.invokeConstructor(NetworkInfo.class, networkType, 0, this.getNetworkTypeName(networkType), "");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        try {
            MethodUtils.invokeMethod(networkinfo, "setDetailedState", NetworkInfo.DetailedState.DISCONNECTED, null, null);
            MethodUtils.invokeMethod((Object)networkinfo, "setIsAvailable", true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return networkinfo;
    }

    public String getNetworkTypeName(int nettype) {
        try {
            return (String)MethodUtils.invokeStaticMethod(ConnectivityManager.class, "getNetworkTypeName", nettype);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    NetworkInfo getNetworkInfo(Network network) {
        if (network == null) {
            return null;
        }
        NetworkWrapper wrapper = this.mNetworkMap.get(network);
        if (wrapper == null) {
            return null;
        }
        return wrapper.networkInfo;
    }

    public Network[] getAllNetworks() {
        return this.mAllNetworks;
    }

    public NetworkCapabilities getNetworkCapabilities(Network network) {
        if (network == null) {
            return null;
        }
        NetworkWrapper wrapper = this.mNetworkMap.get(network);
        if (wrapper == null) {
            return null;
        }
        return wrapper.networkCapabilities;
    }

    @Override
    public synchronized void setActiveNetwork(Network network, NetworkInfo networkInfo) {
        this.mActiveNetwork = network;
        this.mActiveNetworkInfo = networkInfo;
    }

    @Override
    public synchronized void setAllNetworks(Network[] networks, NetworkInfo[] networkInfos, NetworkCapabilities[] capabilitiesArray) {
        this.mAllNetworks = networks;
        this.mAllNetworkInfos = networkInfos;
        this.mAllNetworkCapacities = capabilitiesArray;
        this.mNetworkMap.clear();
        for (int i = 0; i < networks.length; ++i) {
            this.mNetworkMap.put(networks[i], new NetworkWrapper(networkInfos[i], capabilitiesArray[i]));
        }
    }

    public static class NetworkWrapper {
        private NetworkInfo networkInfo;
        private NetworkCapabilities networkCapabilities;

        public NetworkWrapper(NetworkInfo networkInfo, NetworkCapabilities networkCapabilities) {
            this.networkInfo = networkInfo;
            this.networkCapabilities = networkCapabilities;
        }
    }
}

