/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock;

import android.content.Context;
import com.pecpwee.lib.envmock.EnvMockInstaller;
import com.pecpwee.lib.envmock.RecordConfig;
import com.pecpwee.lib.envmock.recorder.AbsRecorder;
import com.pecpwee.lib.envmock.recorder.RecordListener;
import com.pecpwee.lib.envmock.recorder.connect.ConnRecorder;
import com.pecpwee.lib.envmock.recorder.location.GpsRecorder;
import com.pecpwee.lib.envmock.recorder.telephony.TelephonyRecorder;
import com.pecpwee.lib.envmock.recorder.wifi.WifiRecorder;
import java.util.Collection;
import java.util.HashMap;

public class RecordController {
    HashMap<String, ModulePack> mModuleStateMap;
    boolean isRecording = false;

    public RecordController(Context context) {
        if (!EnvMockInstaller.isRecordServiceInstalled) {
            throw new RuntimeException("you should installed the envMock service first");
        }
        this.mModuleStateMap = new HashMap();
        this.mModuleStateMap.put("connectivity", new ModulePack(true, new ConnRecorder()));
        this.mModuleStateMap.put("wifi", new ModulePack(true, new WifiRecorder()));
        this.mModuleStateMap.put("location", new ModulePack(true, new GpsRecorder()));
        this.mModuleStateMap.put("phone", new ModulePack(true, new TelephonyRecorder(context)));
    }

    public void addRecordListener(RecordListener listener) {
        for (ModulePack pack : this.mModuleStateMap.values()) {
            pack.recorder.addRecordListener(listener);
        }
    }

    public void removeRecordListener(RecordListener listener) {
        for (ModulePack pack : this.mModuleStateMap.values()) {
            pack.recorder.removeRecordListener(listener);
        }
    }

    public synchronized void start() {
        if (this.isRecording) {
            throw new RuntimeException("you have started a recording");
        }
        Collection<ModulePack> modulePacks = this.mModuleStateMap.values();
        for (ModulePack modulePack : modulePacks) {
            if (!modulePack.isEnable) continue;
            modulePack.recorder.start();
        }
        this.isRecording = true;
    }

    public synchronized void stop() {
        if (!this.isRecording) {
            throw new RuntimeException("there is no record action are executing");
        }
        Collection<ModulePack> modulePacks = this.mModuleStateMap.values();
        for (ModulePack modulePack : modulePacks) {
            if (!modulePack.isEnable) continue;
            modulePack.recorder.stop();
        }
        this.isRecording = false;
    }

    public synchronized void setSampleInterval(long sampleInterval) {
        this.ensureNoRecording();
        RecordConfig.getInstance().setSampleInterval(sampleInterval);
    }

    public synchronized void setWifiRecordCountUpperLimit(int countLimit) {
        this.ensureNoRecording();
        RecordConfig.getInstance().setWifiScanUpperCount(countLimit);
    }

    public synchronized RecordController setWifiEnable(boolean isEnable) {
        this.ensureNoRecording();
        this.mModuleStateMap.get((Object)"wifi").isEnable = isEnable;
        return this;
    }

    public synchronized RecordController setGpsEnable(boolean isEnable) {
        this.ensureNoRecording();
        this.mModuleStateMap.get((Object)"location").isEnable = isEnable;
        return this;
    }

    public synchronized RecordController setCellEnable(boolean isEnable) {
        this.ensureNoRecording();
        this.mModuleStateMap.get((Object)"phone").isEnable = isEnable;
        return this;
    }

    public synchronized RecordController setGpsRecordFilePath(String filepath) {
        this.ensureNoRecording();
        this.mModuleStateMap.get((Object)"location").recorder.setFilePath(filepath);
        return this;
    }

    public RecordController setWifiRecordFilePath(String filepath) {
        this.ensureNoRecording();
        this.mModuleStateMap.get((Object)"wifi").recorder.setFilePath(filepath);
        return this;
    }

    public RecordController setCellRecordFilePath(String filepath) {
        this.ensureNoRecording();
        this.mModuleStateMap.get((Object)"phone").recorder.setFilePath(filepath);
        return this;
    }

    public RecordController setConnRecordFilePath(String filepath) {
        this.ensureNoRecording();
        this.mModuleStateMap.get((Object)"connectivity").recorder.setFilePath(filepath);
        return this;
    }

    private void ensureNoRecording() {
        if (this.isRecording) {
            throw new RuntimeException("you should stop the record before setting ");
        }
    }

    private static class ModulePack {
        public boolean isEnable;
        public AbsRecorder recorder;

        public ModulePack(boolean isEnable, AbsRecorder recorder) {
            this.isEnable = isEnable;
            this.recorder = recorder;
        }
    }
}

