/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock;

import android.content.Context;
import android.os.Looper;
import com.pecpwee.lib.envmock.AbsConfig;
import java.util.HashMap;

public class PlayConfig
extends AbsConfig {
    private static PlayConfig CONFIG_INSTANCE;
    private Context context;
    private Looper looper;
    private HashMap<String, ModuleStateWrapper> mModuleStateMap = new HashMap();
    private boolean isAutoPlayMode = true;
    private boolean isAutoStopMode = true;
    private String GpsRecordFilePath = null;
    private String WifiRecordFilePath = null;
    private String CellRecordFilePath = null;
    private String ConnRecordFilePath = null;
    private float mStartPlayPercentage = 0.0f;

    public static PlayConfig getInstance() {
        return CONFIG_INSTANCE;
    }

    public boolean isAutoMode() {
        return this.isAutoPlayMode || this.isAutoStopMode;
    }

    public static void setInstance(PlayConfig config) {
        CONFIG_INSTANCE = config;
    }

    PlayConfig() {
        this.mModuleStateMap.put("wifi", new ModuleStateWrapper());
        this.mModuleStateMap.put("location", new ModuleStateWrapper());
        this.mModuleStateMap.put("phone", new ModuleStateWrapper());
        this.mModuleStateMap.put("connectivity", new ModuleStateWrapper());
    }

    public Context getContext() {
        return this.context;
    }

    public Looper getLooper() {
        return this.looper;
    }

    public HashMap<String, ModuleStateWrapper> getModuleStateMap() {
        return this.mModuleStateMap;
    }

    public boolean isAutoPlayMode() {
        return this.isAutoPlayMode;
    }

    public boolean isAutoStopMode() {
        return this.isAutoStopMode;
    }

    public String getGpsRecordFilePath() {
        return this.GpsRecordFilePath;
    }

    public void setGpsRecordFilePath(String gpsRecordFilePath) {
        this.ensureConfigCanChange();
        this.GpsRecordFilePath = gpsRecordFilePath;
    }

    public String getWifiRecordFilePath() {
        return this.WifiRecordFilePath;
    }

    public void setWifiRecordFilePath(String wifiRecordFilePath) {
        this.ensureConfigCanChange();
        this.WifiRecordFilePath = wifiRecordFilePath;
    }

    public String getCellRecordFilePath() {
        return this.CellRecordFilePath;
    }

    public String getConnRecordFilePath() {
        return this.ConnRecordFilePath;
    }

    public String setConnRecordFilePath() {
        this.ensureConfigCanChange();
        return this.ConnRecordFilePath;
    }

    public void setCellRecordFilePath(String cellRecordFilePath) {
        this.ensureConfigCanChange();
        this.CellRecordFilePath = cellRecordFilePath;
    }

    public float getStartPlayPercentage() {
        return this.mStartPlayPercentage;
    }

    public void setStartPlayPercentage(float mStartPlayPercentage) {
        this.ensureConfigCanChange();
        this.mStartPlayPercentage = mStartPlayPercentage;
    }

    private void ensureConfigCanChange() {
        if (this.isAutoPlayMode || this.isAutoStopMode) {
            throw new RuntimeException("the config cannot be change");
        }
    }

    public static class ModuleStateWrapper {
        public boolean isPlayEnable = true;
        public boolean isHookEnable = true;
    }

    public static class Builder {
        private PlayConfig config;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("parameters should not be null");
            }
            this.config = new PlayConfig();
            this.config.context = context;
            this.config.looper = context.getMainLooper();
        }

        public Builder setWorkingLooper(Looper looper) {
            this.config.looper = looper;
            return this;
        }

        public Builder setAutoPlayMode(boolean isEnbale) {
            this.config.isAutoPlayMode = isEnbale;
            return this;
        }

        public Builder setAutoStopMode(boolean isEnbale) {
            this.config.isAutoStopMode = isEnbale;
            return this;
        }

        public Builder setBeginOffsetPercent(float percentOffset) {
            this.config.mStartPlayPercentage = percentOffset;
            return this;
        }

        public Builder setGpsMockFile(String filePath) {
            this.config.GpsRecordFilePath = filePath;
            return this;
        }

        public Builder setWifiMockFilePath(String filePath) {
            this.config.WifiRecordFilePath = filePath;
            return this;
        }

        public Builder setCellMockFilePath(String filePath) {
            this.config.CellRecordFilePath = filePath;
            return this;
        }

        public Builder setConnMockFilePath(String filePath) {
            this.config.ConnRecordFilePath = filePath;
            return this;
        }

        public Builder setWifiPlayerEnable(boolean isEnable) {
            ((ModuleStateWrapper)((PlayConfig)this.config).mModuleStateMap.get((Object)"wifi")).isPlayEnable = isEnable;
            return this;
        }

        public Builder setGpsPlayerEnable(boolean isEnable) {
            ((ModuleStateWrapper)((PlayConfig)this.config).mModuleStateMap.get((Object)"location")).isPlayEnable = isEnable;
            return this;
        }

        public Builder setConnPlayerEnable(boolean isEnable) {
            ((ModuleStateWrapper)((PlayConfig)this.config).mModuleStateMap.get((Object)"connectivity")).isPlayEnable = isEnable;
            return this;
        }

        public Builder setCellPlayerEnable(boolean isEnable) {
            ((ModuleStateWrapper)((PlayConfig)this.config).mModuleStateMap.get((Object)"phone")).isPlayEnable = isEnable;
            return this;
        }

        public Builder setWifiHookEnable(boolean isEnable) {
            ((ModuleStateWrapper)((PlayConfig)this.config).mModuleStateMap.get((Object)"wifi")).isHookEnable = isEnable;
            return this;
        }

        public Builder setGpsHookEnable(boolean isEnable) {
            ((ModuleStateWrapper)((PlayConfig)this.config).mModuleStateMap.get((Object)"location")).isHookEnable = isEnable;
            return this;
        }

        public Builder setConnHookEnable(boolean isEnable) {
            ((ModuleStateWrapper)((PlayConfig)this.config).mModuleStateMap.get((Object)"connectivity")).isHookEnable = isEnable;
            return this;
        }

        public Builder setCellHookEnable(boolean isEnable) {
            ((ModuleStateWrapper)((PlayConfig)this.config).mModuleStateMap.get((Object)"phone")).isHookEnable = isEnable;
            return this;
        }

        public Builder setDebugEnable(boolean isDebug) {
            this.config.isDebug = isDebug;
            return this;
        }

        public PlayConfig build() {
            return this.config;
        }
    }
}

