/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock.utils;

import android.net.wifi.ScanResult;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Pair;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GsonFactory {
    public static Gson gsonInstance;

    public static Gson getGson() {
        if (gsonInstance == null) {
            gsonInstance = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new ScanResultStrategy()).registerTypeAdapterFactory((TypeAdapterFactory)new BundleTypeAdapterFactory()).create();
        }
        return gsonInstance;
    }

    public static class BundleTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Bundle.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            return new TypeAdapter<Bundle>(){

                public void write(JsonWriter out, Bundle bundle) throws IOException {
                    if (bundle == null) {
                        out.nullValue();
                        return;
                    }
                    out.beginObject();
                    for (String key : bundle.keySet()) {
                        out.name(key);
                        Object value = bundle.get(key);
                        if (value == null) {
                            out.nullValue();
                            continue;
                        }
                        gson.toJson(value, value.getClass(), out);
                    }
                    out.endObject();
                }

                public Bundle read(JsonReader in) throws IOException {
                    switch (in.peek()) {
                        case NULL: {
                            in.nextNull();
                            return null;
                        }
                        case BEGIN_OBJECT: {
                            return this.toBundle(this.readObject(in));
                        }
                    }
                    throw new IOException("expecting object: " + in.getPath());
                }

                private Bundle toBundle(List<Pair<String, Object>> values) throws IOException {
                    Bundle bundle = new Bundle();
                    for (Pair<String, Object> entry : values) {
                        String key = (String)entry.first;
                        Object value = entry.second;
                        if (value instanceof String) {
                            bundle.putString(key, (String)value);
                            continue;
                        }
                        if (value instanceof Integer) {
                            bundle.putInt(key, ((Integer)value).intValue());
                            continue;
                        }
                        if (value instanceof Long) {
                            bundle.putLong(key, ((Long)value).longValue());
                            continue;
                        }
                        if (value instanceof Double) {
                            bundle.putDouble(key, ((Double)value).doubleValue());
                            continue;
                        }
                        if (value instanceof Parcelable) {
                            bundle.putParcelable(key, (Parcelable)value);
                            continue;
                        }
                        if (value instanceof List) {
                            List objectValues = (List)value;
                            Bundle subBundle = this.toBundle(objectValues);
                            bundle.putParcelable(key, (Parcelable)subBundle);
                            continue;
                        }
                        throw new IOException("Unparcelable key, value: " + key + ", " + value);
                    }
                    return bundle;
                }

                private List<Pair<String, Object>> readObject(JsonReader in) throws IOException {
                    ArrayList<Pair<String, Object>> object = new ArrayList<Pair<String, Object>>();
                    in.beginObject();
                    block4: while (in.peek() != JsonToken.END_OBJECT) {
                        switch (in.peek()) {
                            case NAME: {
                                String name = in.nextName();
                                Object value = this.readValue(in);
                                object.add((Pair<String, Object>)new Pair((Object)name, value));
                                continue block4;
                            }
                            case END_OBJECT: {
                                continue block4;
                            }
                        }
                        throw new IOException("expecting object: " + in.getPath());
                    }
                    in.endObject();
                    return object;
                }

                private Object readValue(JsonReader in) throws IOException {
                    switch (in.peek()) {
                        case BEGIN_ARRAY: {
                            return this.readArray(in);
                        }
                        case BEGIN_OBJECT: {
                            return this.readObject(in);
                        }
                        case BOOLEAN: {
                            return in.nextBoolean();
                        }
                        case NULL: {
                            in.nextNull();
                            return null;
                        }
                        case NUMBER: {
                            return this.readNumber(in);
                        }
                        case STRING: {
                            return in.nextString();
                        }
                    }
                    throw new IOException("expecting value: " + in.getPath());
                }

                private Object readNumber(JsonReader in) throws IOException {
                    double doubleValue = in.nextDouble();
                    if (doubleValue - Math.ceil(doubleValue) == 0.0) {
                        long longValue = (long)doubleValue;
                        if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                            return (int)longValue;
                        }
                        return longValue;
                    }
                    return doubleValue;
                }

                private List readArray(JsonReader in) throws IOException {
                    ArrayList<Object> list = new ArrayList<Object>();
                    in.beginArray();
                    while (in.peek() != JsonToken.END_ARRAY) {
                        Object element = this.readValue(in);
                        list.add(element);
                    }
                    in.endArray();
                    return list;
                }
            };
        }
    }

    public static class ScanResultStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> arg0) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getDeclaringClass().equals(ScanResult.class) && f.getDeclaredClass().equals(CharSequence.class);
        }
    }

    public static class NoBundleGsonStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> arg0) {
            return arg0 == Bundle.class;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }
    }
}

