/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock.recorder;

import android.text.TextUtils;
import com.pecpwee.lib.envMock.PlayConfig;
import com.pecpwee.lib.envMock.model.AbsTimeModel;
import com.pecpwee.lib.envMock.utils.GsonFactory;
import com.pecpwee.lib.envMock.utils.ThreadManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.CountDownLatch;

public abstract class AbsRecorder {
    protected File mFile;
    private StringBuilder sb = new StringBuilder();
    private CountDownLatch latchlock = null;

    public final void start() {
        if (this.latchlock != null) {
            try {
                this.latchlock.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.sb.setLength(0);
        this.doRecord(-1, String.valueOf(System.currentTimeMillis()));
        this.onStart();
    }

    public final void stop() {
        this.onStop();
        this.latchlock = new CountDownLatch(1);
        this.storeRecord();
        this.doRecord(-2, String.valueOf(System.currentTimeMillis()));
    }

    public abstract void onStart();

    public abstract void onStop();

    public synchronized void setFilePath(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new IllegalArgumentException();
        }
        this.mFile = new File(filePath);
    }

    private void storeRecord() {
        ThreadManager.RECORD_HANDLER.post(new Runnable(){

            @Override
            public void run() {
                AbsRecorder.writeSDCardFile(AbsRecorder.this.mFile, AbsRecorder.this.sb.toString(), true);
                AbsRecorder.this.latchlock.countDown();
            }
        });
    }

    public abstract String getDefaultFilePath();

    protected synchronized void doRecord(int type, String objStr) {
        if (this.mFile == null) {
            File dir = new File(PlayConfig.DEFAULT_RECORD_DIR_PATH);
            dir.mkdirs();
            this.mFile = new File(this.getDefaultFilePath());
        }
        this.sb.append(type + "\n" + objStr + "\n");
    }

    protected void doRecord(AbsTimeModel obj) {
        this.doRecord(obj.getType(), GsonFactory.getGson().toJson((Object)obj));
    }

    public static void writeSDCardFile(File file, String content, boolean append) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, append));
            bos.write(content.getBytes("UTF-8"));
            bos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

