/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock.player.telephony;

import com.pecpwee.lib.envMock.PlayConfig;
import com.pecpwee.lib.envMock.middle.telephony.ITelephonyPlayerListener;
import com.pecpwee.lib.envMock.model.telephony.GetCellLocation;
import com.pecpwee.lib.envMock.model.telephony.GetNetworkType;
import com.pecpwee.lib.envMock.player.AbsPlayer;
import com.pecpwee.lib.envMock.utils.GsonFactory;
import com.pecpwee.lib.envMock.utils.TimerJob;

public class TelephonyPlayer
extends AbsPlayer<ITelephonyPlayerListener> {
    private TimerJob wifiTimer = new TimerJob();

    public TelephonyPlayer(ITelephonyPlayerListener listener) {
        super(listener);
    }

    @Override
    public String getDefaultFilePath() {
        return PlayConfig.DEFAULT_FILEPATH_CELL;
    }

    @Override
    public String getConfigFilePath() {
        return PlayConfig.getInstance().getCellRecordFilePath();
    }

    @Override
    protected AbsPlayer.ILineDataParser getParser() {
        return new AbsPlayer.AbsParser(){

            @Override
            protected void parseValue(int type, String line) {
                switch (type) {
                    case 1: {
                        final GetCellLocation getCellLocationObj = (GetCellLocation)GsonFactory.getGson().fromJson(line, GetCellLocation.class);
                        TelephonyPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(getCellLocationObj.getTime()){

                            @Override
                            public void run() {
                                ((ITelephonyPlayerListener)TelephonyPlayer.this.mListener).setCellLocation(getCellLocationObj.getBundle());
                            }
                        });
                        break;
                    }
                    case 2: {
                        final GetNetworkType networkType = (GetNetworkType)GsonFactory.getGson().fromJson(line, GetNetworkType.class);
                        TelephonyPlayer.this.addTimedAction(new AbsPlayer.TimedRunnable(networkType.getTime()){

                            @Override
                            public void run() {
                                ((ITelephonyPlayerListener)TelephonyPlayer.this.mListener).setNetworkType(networkType.getNetworkType());
                            }
                        });
                        break;
                    }
                }
            }
        };
    }
}

