/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock.middle.location;

import android.content.Context;
import android.location.LocationManager;
import android.os.Build;
import android.os.IBinder;
import com.pecpwee.lib.envMock.hook.AbsServiceFetcher;
import com.pecpwee.lib.envMock.middle.location.IGpsPlayerListener;
import com.pecpwee.lib.envMock.middle.location.ILocationManager;
import com.pecpwee.lib.envMock.middle.location.N.MiddleLocationManagerService;
import com.pecpwee.lib.envMock.player.AbsPlayer;
import com.pecpwee.lib.envMock.player.location.GpsPlayer;
import com.pecpwee.lib.envMock.utils.reflect.MethodUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;

public class LocationServiceFactory
extends AbsServiceFetcher {
    public LocationServiceFactory(Context context) {
        super(context);
    }

    @Override
    public Object createManagerObj(IBinder binder) {
        try {
            Class<?> lmsInterfaceStub = Class.forName("android.location.ILocationManager$Stub");
            Object serviceInterface = MethodUtils.invokeStaticMethod(lmsInterfaceStub, "asInterface", binder);
            return MethodUtils.invokeConstructor(LocationManager.class, this.context, serviceInterface);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public InvocationHandler createProxyServiceBinder() {
        return new ILocationManager(this.getOrigBinderProxyObj());
    }

    @Override
    public Object createMiddleManagerService() {
        if (Build.VERSION.SDK_INT >= 24) {
            return new MiddleLocationManagerService();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return new com.pecpwee.lib.envMock.middle.location.LM.MiddleLocationManagerService();
        }
        return null;
    }

    @Override
    public AbsPlayer createPlayer() {
        return new GpsPlayer((IGpsPlayerListener)this.getMiddleManagerService());
    }

    @Override
    public String getServiceName() {
        return "location";
    }

    @Override
    public String getServiceBinderFullName() {
        return "android.location.ILocationManager";
    }
}

