/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock.hook;

import android.content.Context;
import android.text.TextUtils;
import com.pecpwee.lib.envMock.hook.AbsServiceFetcher;
import com.pecpwee.lib.envMock.player.AbsPlayer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CenterServiceManager {
    private Map<String, AbsServiceFetcher> mInstalledServiceMap = new HashMap<String, AbsServiceFetcher>();
    private static CenterServiceManager instance;
    private static boolean hasInit;
    private static Context context;
    private String packageName = context.getPackageName();

    public static void init(Context context) {
        CenterServiceManager.context = context;
        instance = new CenterServiceManager();
        hasInit = true;
    }

    public static boolean isInited() {
        return hasInit;
    }

    public static CenterServiceManager getInstance() {
        if (instance == null) {
            throw new RuntimeException("you should invoke installPlayService method first");
        }
        return instance;
    }

    private CenterServiceManager() {
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void addService(String serviceName, AbsServiceFetcher factory) {
        if (TextUtils.isEmpty((CharSequence)serviceName)) {
            return;
        }
        if (factory == null) {
            return;
        }
        this.mInstalledServiceMap.put(serviceName, factory);
    }

    public Collection<AbsServiceFetcher> getInstalledServiceCollection() {
        return this.mInstalledServiceMap.values();
    }

    public AbsServiceFetcher getServiceFetcher(String serviceName) {
        return this.mInstalledServiceMap.get(serviceName);
    }

    public AbsPlayer getPlayer(String serviceName) {
        return this.getServiceFetcher(serviceName).getPlayer();
    }
}

