/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock;

import com.pecpwee.lib.envMock.EnvMockInstaller;
import com.pecpwee.lib.envMock.PlayConfig;
import com.pecpwee.lib.envMock.hook.CenterServiceManager;
import com.pecpwee.lib.envMock.utils.reflect.PlayUtils;

public class PlayController {
    private boolean isPlaying = false;
    public static PlayController INSTANCE;

    private PlayController() {
    }

    public static synchronized PlayController getInstance() {
        if (!EnvMockInstaller.isPlayServiceInstalled) {
            throw new RuntimeException("you should installed the envMock service first");
        }
        if (PlayConfig.getInstance().isAutoPlayMode()) {
            throw new RuntimeException("in the auto mode,you should not create PlayController that used for manual control.please config before install the service");
        }
        if (INSTANCE == null) {
            INSTANCE = new PlayController();
        }
        return INSTANCE;
    }

    public synchronized void startPlay() {
        if (this.isPlaying) {
            throw new RuntimeException("you are playing!you should stop the replay before you call play method again");
        }
        this.ensureIsManualMode();
        long time = System.currentTimeMillis();
        PlayUtils.doStartPlay();
        this.isPlaying = true;
    }

    public synchronized void stopPlay() {
        this.ensureIsManualMode();
        if (!this.isPlaying) {
            throw new RuntimeException("there is no module is playing!");
        }
        PlayUtils.doStopPlay();
        this.isPlaying = false;
    }

    public synchronized void setBeginOffsetPercent(float percentOffset) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().setStartPlayPercentage(percentOffset);
    }

    public PlayController setWifiPlayerEnable(boolean isEnable) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().getModuleStateMap().put("wifi", isEnable);
        return this;
    }

    public PlayController setGpsPlayerEnable(boolean isEnable) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().getModuleStateMap().put("location", isEnable);
        return this;
    }

    public PlayController setCellPlayerEnable(boolean isEnable) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().getModuleStateMap().put("phone", isEnable);
        return this;
    }

    public PlayController setGpsMockFilePath(String filepath) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().setGpsRecordFilePath(filepath);
        CenterServiceManager.getInstance().getServiceFetcher("location").getPlayer().notifyDataSourceChanged();
        return this;
    }

    public PlayController setWifiMockFilePath(String filepath) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().setWifiRecordFilePath(filepath);
        CenterServiceManager.getInstance().getServiceFetcher("wifi").getPlayer().notifyDataSourceChanged();
        return this;
    }

    public PlayController setCellMockFilePath(String filepath) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().setCellRecordFilePath(filepath);
        CenterServiceManager.getInstance().getServiceFetcher("phone").getPlayer().notifyDataSourceChanged();
        return this;
    }

    private void ensureNoPlaying() {
        if (this.isPlaying) {
            throw new RuntimeException("you should stop the playing before setting ");
        }
    }

    private void ensureIsManualMode() {
        if (PlayConfig.getInstance().isAutoMode()) {
            throw new RuntimeException("you should not in auto mode ");
        }
    }
}

