/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock;

import android.content.Context;
import android.os.Looper;
import com.pecpwee.lib.envMock.AbsConfig;
import java.util.HashMap;

public class PlayConfig
extends AbsConfig {
    private static PlayConfig CONFIG_INSTANCE;
    private Context context;
    private Looper looper;
    private HashMap<String, Boolean> mModuleStateMap = new HashMap();
    private boolean isAutoPlayMode = true;
    private boolean isAutoStopMode = true;
    private String GpsRecordFilePath = null;
    private String WifiRecordFilePath = null;
    private String CellRecordFilePath = null;
    private float mStartPlayPercentage = 0.0f;

    public static PlayConfig getInstance() {
        return CONFIG_INSTANCE;
    }

    public boolean isAutoMode() {
        return this.isAutoPlayMode || this.isAutoStopMode;
    }

    public static void setInstance(PlayConfig config) {
        CONFIG_INSTANCE = config;
    }

    PlayConfig() {
        this.mModuleStateMap.put("wifi", true);
        this.mModuleStateMap.put("location", true);
        this.mModuleStateMap.put("phone", true);
    }

    public Context getContext() {
        return this.context;
    }

    public Looper getLooper() {
        return this.looper;
    }

    public HashMap<String, Boolean> getModuleStateMap() {
        return this.mModuleStateMap;
    }

    public boolean isAutoPlayMode() {
        return this.isAutoPlayMode;
    }

    public boolean isAutoStopMode() {
        return this.isAutoStopMode;
    }

    public String getGpsRecordFilePath() {
        return this.GpsRecordFilePath;
    }

    public void setGpsRecordFilePath(String gpsRecordFilePath) {
        this.ensureConfigCanChange();
        this.GpsRecordFilePath = gpsRecordFilePath;
    }

    public String getWifiRecordFilePath() {
        return this.WifiRecordFilePath;
    }

    public void setWifiRecordFilePath(String wifiRecordFilePath) {
        this.ensureConfigCanChange();
        this.WifiRecordFilePath = wifiRecordFilePath;
    }

    public String getCellRecordFilePath() {
        return this.CellRecordFilePath;
    }

    public void setCellRecordFilePath(String cellRecordFilePath) {
        this.ensureConfigCanChange();
        this.CellRecordFilePath = cellRecordFilePath;
    }

    public float getStartPlayPercentage() {
        return this.mStartPlayPercentage;
    }

    public void setStartPlayPercentage(float mStartPlayPercentage) {
        this.ensureConfigCanChange();
        this.mStartPlayPercentage = mStartPlayPercentage;
    }

    private void ensureConfigCanChange() {
        if (this.isAutoPlayMode || this.isAutoStopMode) {
            throw new RuntimeException("the config cannot be change");
        }
    }

    public static class Builder {
        private PlayConfig config;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("parameters should not be null");
            }
            this.config = new PlayConfig();
            this.config.context = context;
            this.config.looper = context.getMainLooper();
        }

        public Builder setWorkingLooper(Looper looper) {
            this.config.looper = looper;
            return this;
        }

        public Builder setAutoPlayMode(boolean isEnbale) {
            this.config.isAutoPlayMode = isEnbale;
            return this;
        }

        public Builder setAutoStopMode(boolean isEnbale) {
            this.config.isAutoStopMode = isEnbale;
            return this;
        }

        public Builder setBeginOffsetPercent(float percentOffset) {
            this.config.mStartPlayPercentage = percentOffset;
            return this;
        }

        public Builder setGpsMockFile(String filePath) {
            this.config.GpsRecordFilePath = filePath;
            return this;
        }

        public Builder setWifiMockFilePath(String filePath) {
            this.config.WifiRecordFilePath = filePath;
            return this;
        }

        public Builder setCellMockFilePath(String filePath) {
            this.config.CellRecordFilePath = filePath;
            return this;
        }

        public PlayConfig build() {
            return this.config;
        }
    }
}

