package com.peanut.sdk.updater;

import android.Manifest;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.FileProvider;
import android.util.Log;

import com.peanut.sdk.downloader.DownloadBroadcast;
import com.peanut.sdk.downloader.Downloader;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class Updater {
    private Handler handler;
    private String apkName, versionName, log, repertory,authority;
    private Context context;
    private Activity activity;
    private Channel channel;
    private int versionCode, lastVersionCode;

    public Updater(Activity activity, Context context, int versionCode) {
        handler = new Handler(context.getMainLooper());
        this.versionCode = versionCode;
        this.context = context;
        this.activity = activity;
    }

    public static class Builder {
        Activity activity;
        String repertory,authority;
        Channel channel;
        int currentCode;

        public Builder(Activity activity) {
            this.activity = activity;
        }

        public Builder setRepertory(String repertory) {
            this.repertory = repertory;
            return this;
        }

        public Builder setChanel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public Builder setCurrentCode(int currentCode) {
            this.currentCode = currentCode;
            return this;
        }

        public Builder setAuthority(String authority) {
            this.authority = authority;
            return this;
        }

        public void check() {
            final Updater updater = new Updater(activity, activity, currentCode);
            updater.channel = channel;
            updater.repertory = repertory;
            updater.authority=authority;
            new Thread() {
                public void run() {
                    updater.update$();
                }
            }.start();
        }
    }

    private void update$() {
        analysis(getJSON(repertory + channel.code + "/output.json"));
        if (hasUpdate()) {
            handler.post(() -> {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                builder.setTitle("更新"+versionName)
                        .setMessage(log)
                        .setPositiveButton("更新", (dialog, which) -> {
                            downloadApk(repertory + channel.code + "/" + apkName);
                        })
                        .setNegativeButton("取消", null)
                        .setCancelable(false)
                        .show();
            });
        }
    }

    private boolean hasUpdate() {
        return lastVersionCode > versionCode;
    }

    private void analysis(String json) {
        try {
            JSONObject jsonObject = new JSONArray(json).getJSONObject(0);
            lastVersionCode = Integer.parseInt(jsonObject.getJSONObject("apkInfo").get("versionCode").toString());
            apkName = jsonObject.get("path").toString();
            log = jsonObject.get("properties").toString();
            versionName=jsonObject.getJSONObject("apkInfo").get("versionName").toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getJSON(String url) {
        StringBuilder result = new StringBuilder();
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.connect();
            BufferedReader bufferedReader;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    result.append(line);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private void installApk(File apkFile) {
        Log.v("path",apkFile.toString());
        Intent installApkIntent = new Intent();
        installApkIntent.setAction(Intent.ACTION_VIEW);
        installApkIntent.addCategory(Intent.CATEGORY_DEFAULT);
        installApkIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        Log.v("package", context.getPackageName() + "\n" + apkFile);
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.M) {
            if (Build.VERSION.SDK_INT >= 26) {
                if (!context.getPackageManager().canRequestPackageInstalls()) {
                    ActivityCompat.requestPermissions(activity, new String[]{Manifest.permission.REQUEST_INSTALL_PACKAGES}, 10010);
                }
            }
            installApkIntent.setDataAndType(FileProvider.getUriForFile(context, authority, apkFile), "application/vnd.android.package-archive");
            installApkIntent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
        } else {
            installApkIntent.setDataAndType(Uri.fromFile(apkFile), "application/vnd.android.package-archive");
        }
        context.startActivity(installApkIntent);
    }

    private void downloadApk(String uri){
        File apk=new File(context.getExternalFilesDir("Download")+"/download.apk");
        apk.delete();
        new Downloader(context, apk, uri, new DownloadBroadcast.OnDownloadFinishListener() {
            @Override
            public void OnDownloadFailed(int reason) {

            }

            @Override
            public void OnDownloadPaused(int reason) {

            }

            @Override
            public void OnDownloadPending(int reason) {

            }

            @Override
            public void OnDownloadRunning(int reason) {

            }

            @Override
            public void OnDownloadSuccessful(int reason) {
                installApk(apk);
            }
        }).download();
    }

    private static String md5() {
        char hexDigits[] = {'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j',
                'k', 'l', 'm', 'n', 'o', 'p'};
        StringBuilder stringBuilder=new StringBuilder();
        for (int i = 0; i < 10; i++) {
            stringBuilder.append(hexDigits[(int)(Math.random()*15)]);
        }
        return stringBuilder.toString();
    }

    @SuppressWarnings("ResultOfMethodCallIgnored")
    private void deleteDirWithFile(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory())
            return;
        for (File file : dir.listFiles()) {
            if (file.isFile())
                file.delete();
            else if (file.isDirectory())
                deleteDirWithFile(file);
        }
    }
}

