package com.peanut.sdk.updater;

import android.annotation.SuppressLint;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DownloadBroadcast extends BroadcastReceiver {
    private long id;

    public void setOnDownloadFinishListener(OnDownloadFinishListener onDownloadFinishListener) {
        this.onDownloadFinishListener = onDownloadFinishListener;
    }

    public interface OnDownloadFinishListener{
        void OnDownloadFinish();
    }
    private OnDownloadFinishListener onDownloadFinishListener;

    public DownloadBroadcast( long id) {
        this.id=id;
    }

    @SuppressLint("SimpleDateFormat")
    @Override
    public void onReceive(Context context, Intent intent) {
        if (DownloadManager.ACTION_DOWNLOAD_COMPLETE.equals(intent.getAction())&&intent.getLongExtra(DownloadManager.EXTRA_DOWNLOAD_ID,-1L)==id) {
            onDownloadFinishListener.OnDownloadFinish();
        }
    }
}
