/*
 * Decompiled with CFR 0.152.
 */
package com.peanut.sdk.downloader;

import android.annotation.SuppressLint;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import com.peanut.sdk.downloader.DownloadBroadcast;
import java.io.File;
import java.util.Objects;

public class Downloader {
    private Context context;
    private File file;
    private String url;
    private long downloadId;
    private DownloadBroadcast mDownloadBroadcast;
    private DownloadBroadcast.OnDownloadFinishListener onDownloadFinishListener;

    @SuppressLint(value={"SimpleDateFormat", "InflateParams"})
    public Downloader(Context context, File file, String url, DownloadBroadcast.OnDownloadFinishListener onDownloadFinishListener) {
        this.context = context;
        this.file = file;
        this.url = url;
        this.onDownloadFinishListener = onDownloadFinishListener;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public void download() {
        DownloadManager downloadManager = (DownloadManager)this.context.getSystemService("download");
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)this.url));
        request.setNotificationVisibility(1);
        request.setDestinationUri(Uri.fromFile((File)this.file));
        if (Build.VERSION.SDK_INT >= 19) {
            this.downloadId = Objects.requireNonNull(downloadManager).enqueue(request);
        }
        IntentFilter intentFilter = new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE");
        intentFilter.addAction("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED");
        intentFilter.addAction("android.intent.action.VIEW_DOWNLOADS");
        this.mDownloadBroadcast = new DownloadBroadcast(this.downloadId);
        this.mDownloadBroadcast.setOnDownloadFinishListener(this.onDownloadFinishListener);
        this.mDownloadBroadcast.setOnBroadcastUninstallListener(this::uninstall);
        this.context.registerReceiver((BroadcastReceiver)this.mDownloadBroadcast, intentFilter);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private void uninstall() {
        this.context.unregisterReceiver((BroadcastReceiver)this.mDownloadBroadcast);
    }
}

