/*
 * Decompiled with CFR 0.152.
 */
package com.peanut.sdk.downloader;

import android.annotation.SuppressLint;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.widget.Toast;

public class DownloadBroadcast
extends BroadcastReceiver {
    private long id;
    private OnDownloadFinishListener onDownloadFinishListener;
    private OnBroadcastUninstallListener onBroadcastUninstallListener;

    public void setOnDownloadFinishListener(OnDownloadFinishListener onDownloadFinishListener) {
        this.onDownloadFinishListener = onDownloadFinishListener;
    }

    public void setOnBroadcastUninstallListener(OnBroadcastUninstallListener onBroadcastUninstallListener) {
        this.onBroadcastUninstallListener = onBroadcastUninstallListener;
    }

    public DownloadBroadcast(long id) {
        this.id = id;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public void onReceive(Context context, Intent intent) {
        if ("android.intent.action.DOWNLOAD_COMPLETE".equals(intent.getAction()) && intent.getLongExtra("extra_download_id", -1L) == this.id) {
            long myDownloadID = intent.getLongExtra("extra_download_id", -1L);
            DownloadManager downloadManager = (DownloadManager)context.getSystemService("download");
            DownloadManager.Query query = new DownloadManager.Query();
            query.setFilterById(new long[]{myDownloadID});
            Cursor cursor = downloadManager.query(query);
            if (cursor != null && cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndex("status");
                int status = cursor.getInt(columnIndex);
                int columnReason = cursor.getColumnIndex("reason");
                int reason = cursor.getInt(columnReason);
                switch (status) {
                    case 16: {
                        Toast.makeText((Context)context, (CharSequence)("\u4e0b\u8f7d\u5931\u8d25:" + reason), (int)0).show();
                        this.onDownloadFinishListener.OnDownloadFailed(reason);
                        this.onBroadcastUninstallListener.OnUninstall();
                        break;
                    }
                    case 4: {
                        Toast.makeText((Context)context, (CharSequence)("\u4e0b\u8f7d\u6682\u505c:" + reason), (int)0).show();
                        this.onDownloadFinishListener.OnDownloadPaused(reason);
                        break;
                    }
                    case 1: {
                        Toast.makeText((Context)context, (CharSequence)("\u7b49\u5f85\u4e0b\u8f7d:" + reason), (int)0).show();
                        this.onDownloadFinishListener.OnDownloadPending(reason);
                        break;
                    }
                    case 2: {
                        Toast.makeText((Context)context, (CharSequence)("\u4e0b\u8f7d\u4e2d:" + reason), (int)0).show();
                        this.onDownloadFinishListener.OnDownloadRunning(reason);
                        break;
                    }
                    case 8: {
                        Toast.makeText((Context)context, (CharSequence)("\u4e0b\u8f7d\u5b8c\u6210:" + reason), (int)0).show();
                        this.onDownloadFinishListener.OnDownloadSuccessful(reason);
                        this.onBroadcastUninstallListener.OnUninstall();
                    }
                }
            }
        }
    }

    public static interface OnBroadcastUninstallListener {
        public void OnUninstall();
    }

    public static interface OnDownloadFinishListener {
        public void OnDownloadFailed(int var1);

        public void OnDownloadPaused(int var1);

        public void OnDownloadPending(int var1);

        public void OnDownloadRunning(int var1);

        public void OnDownloadSuccessful(int var1);
    }
}

