/*
 * Decompiled with CFR 0.152.
 */
package com.pdfview;

import android.content.Context;
import android.util.AttributeSet;
import com.pdfview.FileUtils;
import com.pdfview.PDFRegionDecoder;
import com.pdfview.subsamplincscaleimageview.ImageSource;
import com.pdfview.subsamplincscaleimageview.SubsamplingScaleImageView;
import com.pdfview.subsamplincscaleimageview.decoder.DecoderFactory;
import com.pdfview.subsamplincscaleimageview.decoder.ImageRegionDecoder;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/pdfview/PDFView;", "Lcom/pdfview/subsamplincscaleimageview/SubsamplingScaleImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "mScale", "", "mfile", "Ljava/io/File;", "fromAsset", "assetFileName", "", "fromFile", "file", "filePath", "onDetachedFromWindow", "", "scale", "show", "pdfview-library_release"})
public final class PDFView
extends SubsamplingScaleImageView {
    private File mfile;
    private float mScale;

    @NotNull
    public final PDFView fromAsset(@NotNull String assetFileName) {
        Intrinsics.checkParameterIsNotNull((Object)assetFileName, (String)"assetFileName");
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.mfile = FileUtils.INSTANCE.fileFromAsset(context, assetFileName);
        return this;
    }

    @NotNull
    public final PDFView fromFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.mfile = file;
        return this;
    }

    @NotNull
    public final PDFView fromFile(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        this.mfile = new File(filePath);
        return this;
    }

    @NotNull
    public final PDFView scale(float scale) {
        this.mScale = scale;
        return this;
    }

    public final void show() {
        File file = this.mfile;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        ImageSource imageSource = ImageSource.uri(file.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)imageSource, (String)"ImageSource.uri(mfile!!.path)");
        ImageSource source = imageSource;
        this.setRegionDecoderFactory((DecoderFactory<? extends ImageRegionDecoder>)new DecoderFactory<ImageRegionDecoder>(this){
            final /* synthetic */ PDFView this$0;

            @NotNull
            public final PDFRegionDecoder make() {
                File file = PDFView.access$getMfile$p(this.this$0);
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                return new PDFRegionDecoder(this.this$0, file, PDFView.access$getMScale$p(this.this$0), 0, 8, null);
            }
            {
                this.this$0 = pDFView;
            }
        });
        this.setImage(source);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.recycle();
    }

    @JvmOverloads
    public PDFView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.mScale = 8.0f;
        this.setMinimumTileDpi(120);
        this.setMinimumScaleType(4);
    }

    public /* synthetic */ PDFView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @JvmOverloads
    public PDFView(@NotNull Context context) {
        this(context, null, 2, null);
    }

    public static final /* synthetic */ File access$getMfile$p(PDFView $this) {
        return $this.mfile;
    }

    public static final /* synthetic */ void access$setMfile$p(PDFView $this, File file) {
        $this.mfile = file;
    }

    public static final /* synthetic */ float access$getMScale$p(PDFView $this) {
        return $this.mScale;
    }

    public static final /* synthetic */ void access$setMScale$p(PDFView $this, float f) {
        $this.mScale = f;
    }
}

