/*
 * Decompiled with CFR 0.152.
 */
package com.pdfview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.pdf.PdfRenderer;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.annotation.ColorInt;
import com.pdfview.PDFView;
import com.pdfview.subsamplincscaleimageview.decoder.ImageRegionDecoder;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/pdfview/PDFRegionDecoder;", "Lcom/pdfview/subsamplincscaleimageview/decoder/ImageRegionDecoder;", "view", "Lcom/pdfview/PDFView;", "file", "Ljava/io/File;", "scale", "", "backgroundColorPdf", "", "(Lcom/pdfview/PDFView;Ljava/io/File;FI)V", "descriptor", "Landroid/os/ParcelFileDescriptor;", "pageHeight", "pageWidth", "renderer", "Landroid/graphics/pdf/PdfRenderer;", "decodeRegion", "Landroid/graphics/Bitmap;", "rect", "Landroid/graphics/Rect;", "sampleSize", "init", "Landroid/graphics/Point;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "isReady", "", "recycle", "", "pdfview-library_release"})
public final class PDFRegionDecoder
implements ImageRegionDecoder {
    private ParcelFileDescriptor descriptor;
    private PdfRenderer renderer;
    private int pageWidth;
    private int pageHeight;
    private final PDFView view;
    private final File file;
    private final float scale;
    private final int backgroundColorPdf;

    @Override
    @NotNull
    public Point init(@NotNull Context context, @NotNull Uri uri) throws Exception {
        PdfRenderer.Page page;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)this.file, (int)0x10000000);
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelFileDescriptor, (String)"ParcelFileDescriptor.ope\u2026escriptor.MODE_READ_ONLY)");
        ParcelFileDescriptor parcelFileDescriptor2 = this.descriptor = parcelFileDescriptor;
        if (parcelFileDescriptor2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"descriptor");
        }
        PdfRenderer pdfRenderer = this.renderer = new PdfRenderer(parcelFileDescriptor2);
        if (pdfRenderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
        }
        PdfRenderer.Page page2 = page = pdfRenderer.openPage(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"page");
        this.pageWidth = (int)((float)page2.getWidth() * this.scale);
        this.pageHeight = (int)((float)page.getHeight() * this.scale);
        PdfRenderer pdfRenderer2 = this.renderer;
        if (pdfRenderer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
        }
        if (pdfRenderer2.getPageCount() > 15) {
            this.view.setHasBaseLayerTiles(false);
        } else {
            PdfRenderer pdfRenderer3 = this.renderer;
            if (pdfRenderer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
            }
            if (pdfRenderer3.getPageCount() == 1) {
                this.view.setMinimumScaleType(1);
            }
        }
        page.close();
        PdfRenderer pdfRenderer4 = this.renderer;
        if (pdfRenderer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
        }
        return new Point(this.pageWidth, this.pageHeight * pdfRenderer4.getPageCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Bitmap decodeRegion(@NotNull Rect rect, int sampleSize) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        int numPageAtStart = (int)Math.floor((double)rect.top / (double)this.pageHeight);
        int numPageAtEnd = (int)Math.ceil((double)rect.bottom / (double)this.pageHeight) - 1;
        Bitmap bitmap = Bitmap.createBitmap((int)(rect.width() / sampleSize), (int)(rect.height() / sampleSize), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(this.backgroundColorPdf);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        boolean bl = false;
        int n = numPageAtStart;
        Iterator iterator = ((Iterable)new IntRange(n, numPageAtEnd)).iterator();
        while (iterator.hasNext()) {
            void iteration;
            PdfRenderer pdfRenderer;
            int pageIndex = ((IntIterator)iterator).nextInt();
            if (this.renderer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
            }
            boolean bl2 = false;
            boolean bl3 = false;
            synchronized (pdfRenderer) {
                boolean bl4 = false;
                PdfRenderer pdfRenderer2 = this.renderer;
                if (pdfRenderer2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
                }
                PdfRenderer.Page page = pdfRenderer2.openPage(pageIndex);
                Matrix matrix = new Matrix();
                matrix.setScale(this.scale / (float)sampleSize, this.scale / (float)sampleSize);
                matrix.postTranslate((float)(-rect.left / sampleSize), -((float)((rect.top - this.pageHeight * numPageAtStart) / sampleSize)) + (float)this.pageHeight / (float)sampleSize * (float)iteration);
                page.render(bitmap, null, matrix, 1);
                page.close();
                Unit unit = Unit.INSTANCE;
            }
            ++iteration;
        }
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    @Override
    public boolean isReady() {
        return this.pageWidth > 0 && this.pageHeight > 0;
    }

    @Override
    public void recycle() {
        PdfRenderer pdfRenderer = this.renderer;
        if (pdfRenderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
        }
        pdfRenderer.close();
        ParcelFileDescriptor parcelFileDescriptor = this.descriptor;
        if (parcelFileDescriptor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"descriptor");
        }
        parcelFileDescriptor.close();
        this.pageWidth = 0;
        this.pageHeight = 0;
    }

    public PDFRegionDecoder(@NotNull PDFView view, @NotNull File file, float scale, @ColorInt int backgroundColorPdf) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)view), (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.view = view;
        this.file = file;
        this.scale = scale;
        this.backgroundColorPdf = backgroundColorPdf;
    }

    public /* synthetic */ PDFRegionDecoder(PDFView pDFView, File file, float f, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = -1;
        }
        this(pDFView, file, f, n);
    }
}

