package com.payu.gpay.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;

import com.payu.gpay.BuildConfig;
import com.payu.gpay.GPay;
import com.payu.gpay.PaymentResponse;
import com.payu.gpay.R;
import com.payu.payuanalytics.analytics.PayUDeviceAnalytics;
import com.payu.socketverification.widgets.PayUProgressDialog;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;

public class GPayUtil {

    public static PayUProgressDialog progressDialog;

    /**
     * Using Hash map to get all the post data key and value.
     * Later we can use this methods to parase non payu's post data.
     *
     * @param postData Merchant Transction PostData
     * @return
     */

    public static HashMap<String, String> getDataFromPostData(String postData) {
        HashMap<String, String> postParamsMap = new HashMap<>();
        if (null != postData) {
            StringTokenizer tokens = new StringTokenizer(postData, "&");
            L.v("Tokens count "+tokens.countTokens());
            while (tokens.hasMoreTokens()) {
                String[] keyValue = tokens.nextToken().split("=");
                if (null != keyValue && keyValue.length > 0 && null != keyValue[0]) {
                    postParamsMap.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : "");
                }
            }
        }
        return postParamsMap;
    }

    /**
     * Method to get the Base64 Decoded String value
     *
     * @param data - Base64 encoded String
     * @return Base64 decoded String/null in case of Invalid Base64
     */
    public static String getBase64DecodedString(String data)  {
        try {
            return new String(Base64.decode(data, Base64.DEFAULT));
        }catch (IllegalArgumentException e){
            return null;
        }
    }


    /**
     * Return status from Success/Failure based on Api response
     * @param response as received from Api
     * @return Failure{@link com.payu.gpay.utils.GPayConstants#FAILURE}/Success {@link com.payu.gpay.utils.GPayConstants#SUCCESS}
     */
    public static String getTransactionStatus(String response){
        if(response!=null&& !response.isEmpty()) {
            try {
                JSONObject jsonObject = new JSONObject(response);
                if (jsonObject.has(GPayConstants.RESULT)) {
                    JSONObject resultObject = jsonObject.getJSONObject(GPayConstants.RESULT);
                    if (resultObject.has(GPayConstants.STATUS.toLowerCase()))
                        return resultObject.getString(GPayConstants.STATUS.toLowerCase());
                }
            } catch (JSONException e) {
                e.printStackTrace();
                return GPayConstants.FAILURE;
            }
        }
        return GPayConstants.FAILURE;
    }

    /**
     *
     * @param activity
     * @param onClickDialog
     * @param positiveText
     * @param negativeText
     * @param title
     * @param message
     * @return {@link AlertDialog.Builder which is used for onBackButton Call of interface }{@link com.payu.gpay.callbacks.PayUGPayCallback}
     */
    public static AlertDialog.Builder getAlertDialog(Activity activity, DialogInterface.OnClickListener onClickDialog, String positiveText, String negativeText, String title, String message) {
        AlertDialog.Builder alertbox = new AlertDialog.Builder(activity, R.style.payu_network_dialog);
        if (onClickDialog != null){
            if (title != null)
                alertbox.setTitle(title);
            if (message != null)
                alertbox.setMessage(message);
            if (positiveText != null)
                alertbox.setPositiveButton(positiveText, onClickDialog);
            if (negativeText != null)
                alertbox.setNegativeButton(negativeText, onClickDialog);
            alertbox.show();
        }
        return alertbox;

    }

    /**
     * Provide JSONObject for analytics
     *
     * @param context        application context
     * @param key            analytics event ket
     * @param value          event value
     * @param sdkMerchantKey merchant key
     * @param trnxID         transaction  ID
     * @return
     */
    public static String getLogMessage(Context context, String key, String value, String sdkMerchantKey, String trnxID) {
        try {
            JSONObject eventAnalytics = new JSONObject();
           // eventAnalytics.put(GPayConstants.PAYU_ID, getCookie(UpiConstant.PAYUID, context));
            eventAnalytics.put(GPayConstants.TXNID, trnxID);
            eventAnalytics.put(GPayConstants.MERCHANT_KEY, sdkMerchantKey);
            eventAnalytics.put(GPayConstants.EVENT_KEY, key);
            eventAnalytics.put(GPayConstants.VALUE, URLEncoder.encode(value, "UTF-8"));
            eventAnalytics.put(GPayConstants.PACKAGE_NAME, context.getPackageName());
            eventAnalytics.put(GPayConstants.TIMESTAMP, getSystemCurrentTime());
            eventAnalytics.put(GPayConstants.GPAY_SDK_VERSION, BuildConfig.VERSION_NAME);
            if(!TextUtils.isEmpty(GPay.cb_version_name))
                eventAnalytics.put(GPayConstants.CB_VERSION_NAME, GPay.cb_version_name);

            if (!TextUtils.isEmpty(GPay.upi_sdk_version))
            eventAnalytics.put(GPayConstants.UPI_SDK_VERSION_NAME, GPay.upi_sdk_version + "");
            eventAnalytics.put(GPayConstants.VERSION_CODE, getVersionCode(context));
            return eventAnalytics.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return "{}";
        }
    }
    /**
     * Return system current time of system
     *
     * @return system current time in string
     */
    public static String getSystemCurrentTime() {
        try {
            Date currentDate = new Date(System.currentTimeMillis());
            DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date = df.format(currentDate);
            return date;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String getVersionCode(Context context)
    {
        try {
            PackageInfo pInfo =context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pInfo.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return "";
    }


    private static String getDeviceDensity(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.densityDpi + "";
    }



    /**
     * Checking whether GPay enabled or not.
     *
     * @param jsonResponse
     * @return
     */
    public static boolean isGpayEnabledForMerchant(String jsonResponse) {
        try {
            L.v("Json response " + jsonResponse);
            JSONObject response = new JSONObject(jsonResponse);
            if (response.has(GPayConstants.IBIBO_CODES)) {
                JSONObject ibiboCodes = response.getJSONObject(GPayConstants.IBIBO_CODES);
                if (ibiboCodes.has(GPayConstants.UPI_)) {
                    JSONObject tezObject = ibiboCodes.getJSONObject(GPayConstants.UPI_);
                    if (tezObject.has(GPayConstants.TEZAPP.toUpperCase())) {
                        return true;
                    }
                }
            }
        } catch (JSONException e) {
            return false;
        }
        return false;
    }
    /**
     * Check whether the customer has Gpay/GPay app installed or not
     *
     * @param context
     * @return
     */
    public static  boolean isTezAppInstalled(Context context) {

        if (Build.VERSION.SDK_INT >= 19) {
            try {
                context.getPackageManager().getPackageInfo(GPayConstants.GPAY_PACKAGE, 0);
                return true;
            } catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * Showing Dialog
     */
    public static void showProgressDialog(Activity activity, View dialogView) {

       if (activity!=null && !activity.isFinishing() && !activity.isDestroyed()) {
           if (null == progressDialog)
               progressDialog = new com.payu.socketverification.widgets.PayUProgressDialog(activity, dialogView);
           if (null == dialogView)
               progressDialog.setPayUDialogSettings(activity);
           progressDialog.setCancelable(false);
           progressDialog.show();
       }
    }


    /**
     * Hiding the PayU progress dialog
     */
    public static void hideProgressDialog(Activity activity) {

        if (null != progressDialog && progressDialog.isShowing() && null!=activity && !activity.isFinishing() && !activity.isDestroyed())
            progressDialog.dismiss();
        progressDialog = null;

    }


    /**
     * Logging device analytics events.
     *
     * @param sdkMerchantKey, merchant key
     * @param activity       activity instance
     * @param txnId  Merchant Transaction Id
     */
    public static void deviceAnalytics(String sdkMerchantKey, WeakReference<Activity> activity, String txnId) {
        if(null!=activity.get() && !activity.get().isDestroyed() && !activity.get().isFinishing()) {
            JSONObject deviceDetails = new JSONObject();
            PayUDeviceAnalytics payuDeviceAnalytics;
            try {
                deviceDetails.put(GPayConstants.TXNID, txnId);
                deviceDetails.put(GPayConstants.MERCHANT_KEY, sdkMerchantKey);
                deviceDetails.put(GPayConstants.DEVICE_OS_VERSION, Build.VERSION.SDK_INT + "");
                deviceDetails.put(GPayConstants.DEVICE_RESOLUTION, GPayUtil.getDeviceDensity(activity.get()));
                deviceDetails.put(GPayConstants.DEVICE_MANUFACTURE, Build.MANUFACTURER);
                deviceDetails.put(GPayConstants.DEVICE_MODEL, Build.MODEL);
                if (!TextUtils.isEmpty(GPay.upi_sdk_version))
                    deviceDetails.put(GPayConstants.UPI_SDK_VERSION_NAME, GPay.upi_sdk_version);
                deviceDetails.put(GPayConstants.SDK_VERSION_NAME, BuildConfig.VERSION_NAME);
                if (!TextUtils.isEmpty(GPay.cb_version_name))
                    deviceDetails.put(GPayConstants.CB_VERSION_NAME, GPay.cb_version_name);
                deviceDetails.put(GPayConstants.PACKAGE_NAME, activity.get().getPackageName());
                payuDeviceAnalytics = new PayUDeviceAnalytics(activity.get().getApplicationContext(), "cb_local_cache_device");
                payuDeviceAnalytics.log(deviceDetails.toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * Setting of data from manifest file.
     *
     * @param activity
     */
    public static void setMetaData(Activity activity) {
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = activity.getPackageManager().getApplicationInfo(activity.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = applicationInfo.metaData;
            String webServiceUrl = bundle.getString(GPayConstants.PAYU_WEB_SERVICE_URL, GPayConstants.PRODUCTION_BASE_URL);
            webServiceUrl = webServiceUrl + GPayConstants.MERCHANT_POST_SERVICE_FORM;

            String postUrl = bundle.getString(GPayConstants.PAYU_POST_URL, GPayConstants.PRODUCTION_PAYMENT_BASE_URL);
            postUrl = postUrl + GPayConstants._PAYMENT;

            GPayData.SINGLETON.setWebServiceUrl(webServiceUrl);
            GPayData.SINGLETON.setPostUrl(postUrl);
        } catch (PackageManager.NameNotFoundException e) {
            L.v("Exception metadata " + e.getMessage());
            e.printStackTrace();
        }

    }

    public static ArrayList convertCommaSeparatedStringToArrayList(String data) {
        if (data != null && data.length()>0) {
            String[] allowedCardsArr = data.split(",");
            ArrayList list = new ArrayList(Arrays.asList(allowedCardsArr));
            for (int i = 0; i < list.size(); i++) {
                L.v("Value " + list.get(i));
            }
            return list;
        }
        return null;
    }

    /**
     *
     * @param paymentResponse
     * @return
     */
    public static boolean isCardSupported(PaymentResponse paymentResponse) {
        if (paymentResponse!=null) {
            return paymentResponse.getCardSupported();
        }
        return false;
    }
}
