package com.payu.gpay.intent;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;

import com.payu.gpay.PaymentResponse;
import com.payu.gpay.utils.GPayConstants;
import com.payu.gpay.utils.L;
import com.payu.gpay.utils.GPayData;
import com.payu.gpay.utils.GPayUtil;
import com.payu.payuanalytics.analytics.PayUAnalytics;
import com.payu.socketverification.bean.PayUNetworkAsyncTaskData;
import com.payu.socketverification.interfaces.PayuNetworkAsyncTaskInterface;
import com.payu.socketverification.core.PayUNetworkAsyncTask;
import com.payu.socketverification.util.PayUNetworkConstant;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.util.HashMap;

import static com.payu.gpay.utils.GPayUtil.getTransactionStatus;


/**
 * Created by Shahbaz
 * <p>
 * This class is used to call GPay app Intent flow and verify the payment - Only Http fallback flow.
 */
public class GPayIntentAndVerifyHandler implements PayuNetworkAsyncTaskInterface {
    private WeakReference<Activity> activityWeakReference;
    private PayUAnalytics analytics;
    private String postData;

    public GPayIntentAndVerifyHandler(Activity activity, String postData) {
      if (null!= activity&& !activity.isFinishing()&& !activity.isDestroyed())
        activityWeakReference = new WeakReference<>(activity);
        this.postData = postData;
        this.analytics = PayUAnalytics.getInstance(activityWeakReference.get().getApplicationContext(), "local_cache_analytics");
    }

    /**
     * @param jsonObjectString
     * @param postData
     * @param activity
     */
    public void makeIntentPayment( String jsonObjectString, String postData, Activity activity) {

        activityWeakReference = new WeakReference<>(activity);
        Intent i = new Intent();
        StringBuilder path = new StringBuilder();
        i.setPackage(GPayConstants.GPAY_PACKAGE_NAME);
        if (jsonObjectString != null) {
            try {

                JSONObject jsonObject = new JSONObject(jsonObjectString);

                if (jsonObject.has(GPayConstants.MERCHANT_VPA)
                        && jsonObject.has(GPayConstants.MERCHANT_NAME)
                        && jsonObject.has(GPayConstants.AMOUNT)
                        && jsonObject.has(GPayConstants.REFERENCE_ID)
                ) {
                    L.v("JSON: " + jsonObject.toString());
                    path.append(GPayConstants.UPI_INTENT_DATA);

                    path.append(jsonObject.getString(GPayConstants.MERCHANT_VPA));
                    path.append(GPayConstants.INTENT_PAYEE_NAME).append(jsonObject.getString(GPayConstants.MERCHANT_NAME));
                    path.append(GPayConstants.INTENT_AMOUNT).append(jsonObject.getString(GPayConstants.AMOUNT));
                    path.append(GPayConstants.INTENT_TRANSACTION_ID).append(jsonObject.getString(GPayConstants.REFERENCE_ID));
                    HashMap<String, String> hashMap = GPayUtil.getDataFromPostData(postData);
                    if (hashMap.containsKey("txnid")) {
                        L.v("Transaction Id: " + hashMap.get("txnid"));
                        if (path != null) {
                            path.append("&tid=" + hashMap.get("txnid"));
                            L.v("Path >> " + String.valueOf(path));
                            i.setData(Uri.parse(String.valueOf(path)));
                            if(null!=activityWeakReference && null!=activityWeakReference.get() && !activityWeakReference.get().isFinishing() && !activityWeakReference.get().isDestroyed())
                                activityWeakReference.get().startActivityForResult(i, GPayConstants.PAYMENT_REQUEST_CODE);
                        }
                    }


                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }


    }


    private com.payu.socketverification.widgets.PayUProgressDialog progressDialog;
    private String verifyPostData;



    public void verifyPayment(final String transactionStatus, final String errorReason, final Activity activity, final PaymentResponse paymentResponse, String paymentType) {
       if (null!= activity && !activity.isFinishing() && !activity.isDestroyed()) {
           activityWeakReference = new WeakReference<>(activity);
           GPayUtil.showProgressDialog(activityWeakReference.get(), GPayData.SINGLETON.getPayUCustomDialogView());
           String action = transactionStatus.equalsIgnoreCase(GPayConstants.CANCEL) ? "cancelTxn" : (transactionStatus.equalsIgnoreCase(GPayConstants.FAIL)) ? "failTxn" : "finish";
           verifyPostData = GPayConstants.ACTION + "=" + action + "&" + GPayConstants.FAILURE_REASON + "=" + errorReason + "&"+GPayConstants.GPAY_PAYMENT_TYPE +" = "+paymentType;

           PayUNetworkAsyncTaskData browserAsyncTaskData = new PayUNetworkAsyncTaskData();

           browserAsyncTaskData.setHttpMethod(com.payu.socketverification.util.PayUNetworkConstant.METHOD_TYPE_POST);
           browserAsyncTaskData.setPostData(String.valueOf(verifyPostData));
           browserAsyncTaskData.setHttpMethod("POST");
           // browserAsyncTaskData.setContentType(com.payu.socketverification.util.PayUNetworkConstant.CONTENT_TYPE_APPLICATION_JSON);
           L.v("Class Name: " + getClass().getCanonicalName() + "Verify Url " + paymentResponse.getReturnUrl());
           L.v("Class Name: " + getClass().getCanonicalName() + "Verify Postdata " + verifyPostData);
           browserAsyncTaskData.setUrl(paymentResponse.getReturnUrl());
           new PayUNetworkAsyncTask(this, PayUNetworkConstant.VERIFY).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, browserAsyncTaskData);

       }
    }

    @Override
    public void onPayuNetworkAsyncTaskResponse(String payUWebServiceResponse, String tag) {
        switch (tag) {
            case PayUNetworkConstant.VERIFY:
                if(null!=activityWeakReference && null!=activityWeakReference.get() && !activityWeakReference.get().isFinishing() && !activityWeakReference.get().isDestroyed())
                GPayUtil.hideProgressDialog(activityWeakReference.get());
                if (!TextUtils.isEmpty(payUWebServiceResponse)) {
                    String response = GPayUtil.getBase64DecodedString(payUWebServiceResponse);
                  if(null!=response)
                    L.v(response);
                    String status = getTransactionStatus(response);
                    if (status.equalsIgnoreCase(GPayConstants.FAILURE)) {
                        L.v("Status Failure PaymentHandler gpaysdk ");
                        if(null!=activityWeakReference && null!=activityWeakReference.get() && !activityWeakReference.get().isFinishing() && !activityWeakReference.get().isDestroyed())
                            analytics.log(GPayUtil.getLogMessage(activityWeakReference.get().getApplicationContext(), GPayConstants.TRXN_STATUS, GPayConstants.FAILURE_TRANSACTION, GPayUtil.getDataFromPostData(postData).get(GPayConstants.KEY_), GPayUtil.getDataFromPostData(postData).get(GPayConstants.TXNID)));
                        if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                        GPayData.SINGLETON.getPayUGPayCallback().onPaymentFailure(response,null);
                    } else {
                        if(null!=activityWeakReference && null!=activityWeakReference.get() && !activityWeakReference.get().isFinishing() && !activityWeakReference.get().isDestroyed())
                            analytics.log(GPayUtil.getLogMessage(activityWeakReference.get().getApplicationContext(), GPayConstants.TRXN_STATUS, GPayConstants.SUCCESS_TRANSACTION, GPayUtil.getDataFromPostData(postData).get(GPayConstants.KEY_), GPayUtil.getDataFromPostData(postData).get(GPayConstants.TXNID)));
                        if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                        GPayData.SINGLETON.getPayUGPayCallback().onPaymentSuccess(response,null);
                    }
                } else {
                    if(null!=activityWeakReference && null!=activityWeakReference.get() && !activityWeakReference.get().isFinishing() && !activityWeakReference.get().isDestroyed())
                        analytics.log(GPayUtil.getLogMessage(activityWeakReference.get().getApplicationContext
                            (), GPayConstants.TRXN_STATUS, GPayConstants.FAILURE_TRANSACTION, GPayUtil.getDataFromPostData(postData).get(GPayConstants.KEY_), GPayUtil.getDataFromPostData(postData).get(GPayConstants.TXNID)));

                    L.v("Status Failure else PaymentHandler gpaysdk ");
                    if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                    GPayData.SINGLETON.getPayUGPayCallback().onPaymentFailure(null,null);

                }
                if(null!=activityWeakReference && null!=activityWeakReference.get() && !activityWeakReference.get().isFinishing() && !activityWeakReference.get().isDestroyed()) {
                    activityWeakReference.get().finish();
                }

                break;
        }
    }
}
