package com.payu.gpay;


import android.os.Parcel;
import android.os.Parcelable;

import com.payu.socketverification.socket.SocketPaymentResponse;

/**
 * @author shahbaz.ahmmod
 */
public class PaymentResponse implements Parcelable {
    private String merchantName;
    private String returnUrl;
    private String merchantVpa;
    private String referenceId;
    private String amount;
    private String txnId;
//    private String token; // As it is no longer sent by Backend
    private String vpaRegex;
    private SocketPaymentResponse socketParams;
    private String mcc;
    private Boolean isCardSupported;
    private String allowedCardNetworks;

    public Boolean getCardSupported() {
        return isCardSupported;
    }

    public void setCardSupported(Boolean cardSupported) {
        isCardSupported = cardSupported;
    }

    public String getAllowedCardNetworks() {
        return allowedCardNetworks;
    }

    public void setAllowedCardNetworks(String allowedCardNetworks) {
        this.allowedCardNetworks = allowedCardNetworks;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getMerchantVpa() {
        return merchantVpa;
    }

    public void setMerchantVpa(String merchantVpa) {
        this.merchantVpa = merchantVpa;
    }

    public String getReferenceId() {
        return referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getTxnId() {
        return txnId;
    }

    public void setTxnId(String txnId) {
        this.txnId = txnId;
    }

    public String getVpaRegex() {
        return vpaRegex;
    }

    public void setVpaRegex(String vpaRegex) {
        this.vpaRegex = vpaRegex;
    }

    public SocketPaymentResponse getSocketParams() {
        return socketParams;
    }

    public void setSocketParams(SocketPaymentResponse socketParams) {
        this.socketParams = socketParams;
    }

    public String getMcc() {
        return mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.merchantName);
        dest.writeString(this.returnUrl);
        dest.writeString(this.merchantVpa);
        dest.writeString(this.referenceId);
        dest.writeString(this.amount);
        dest.writeString(this.txnId);
        dest.writeString(this.vpaRegex);
        dest.writeString(this.mcc);
        dest.writeParcelable(this.socketParams, flags);
    }

    public PaymentResponse() {
    }

    protected PaymentResponse(Parcel in) {
        this.merchantName = in.readString();
        this.returnUrl = in.readString();
        this.merchantVpa = in.readString();
        this.referenceId = in.readString();
        this.amount = in.readString();
        this.txnId = in.readString();
        this.vpaRegex = in.readString();
        this.mcc = in.readString();
        this.socketParams = in.readParcelable(SocketPaymentResponse.class.getClassLoader());
    }

    public static final Parcelable.Creator<PaymentResponse> CREATOR = new Parcelable.Creator<PaymentResponse>() {
        @Override
        public PaymentResponse createFromParcel(Parcel source) {
            return new PaymentResponse(source);
        }

        @Override
        public PaymentResponse[] newArray(int size) {
            return new PaymentResponse[size];
        }
    };
}
