package com.payu.gpay;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.view.View;


import com.payu.gpay.callbacks.PayUGPayCallback;
import com.payu.gpay.callbacks.PayUGPayCallbackInterface;
import com.payu.gpay.utils.L;
import com.payu.gpay.utils.GPayData;
import com.payu.gpay.utils.GPayUtil;

import java.lang.reflect.Proxy;

public class GPayWrapper {

    private PayUGPayCallbackInterface wrapperListener;
    private GPay GPay;

    public GPayWrapper(java.lang.reflect.InvocationHandler handler) {
        wrapperListener = (PayUGPayCallbackInterface) Proxy.newProxyInstance(
                PayUGPayCallbackInterface.class.getClassLoader(),
                new Class[]{PayUGPayCallbackInterface.class},
                handler);
    }

    /**
     * Function to check whether GPay is available on device or not
     *
     * @param paymentOptionHash Get Payment Related Details Hash
     * @param merchantKey       Merchant key
     * @param user_credentials  User credentials
     */
    public void checkForPaymentAvailability(Context context, String paymentOptionHash, String merchantKey, String user_credentials){
        this.GPay = GPay.getInstance();
        L.v("In tezwrapper checkTezEligibility context "+(context.getPackageName()));
        L.v("paymentOptionHash "+paymentOptionHash+"       merchantKey "+merchantKey+"       user_credentials "+user_credentials);
        GPayData.SINGLETON.setPayUGPayCallback(payUGPayCallback);
        GPay.checkForPaymentAvailability((Activity) context, payUGPayCallback, paymentOptionHash, merchantKey, user_credentials);

    }
    /**
     * Function to make payment using Samsung Pay
     *
     * @param postData Post Data
     */

    public void makePayment(Activity activity, String postData, View dialogView) {
        //GPay.makePayment(activity, postData,payUGPayCallback,"UPI_");
        L.v("MakePAyment Tezwrapper "+postData);
        this.GPay = GPay.getInstance();
        GPay.makePayment( activity, postData, payUGPayCallback, GPayUtil.getDataFromPostData(postData).get("key"), dialogView);

    }

    private PayUGPayCallback payUGPayCallback = new PayUGPayCallback() {

        @Override
        public void onPaymentSuccess(String payuResponse, String merchantResponse) {
            super.onPaymentSuccess(payuResponse, merchantResponse);
            wrapperListener.onPaymentSuccess(payuResponse,merchantResponse);
        }

        @Override
        public void onPaymentFailure(String payuResponse, String merchantResponse) {
            super.onPaymentFailure(payuResponse, merchantResponse);
            wrapperListener.onPaymentFailure(payuResponse,merchantResponse);
        }

        @Override
        public void onPaymentInitialisationSuccess() {
            L.v(" GPay onPaymentInitialisationSuccess");
            wrapperListener.onPaymentInitialisationSuccess();
        }

        @Override
        public void onPaymentInitialisationFailure(int errorCode, String description) {
            L.v(" GPay onPaymentInitialisationFailure");
            wrapperListener.onPaymentInitialisationFailure(errorCode, description);
        }

        @Override
        public void onGpayErrorReceived(int errorCode, String description) {
            super.onGpayErrorReceived(errorCode, description);
            wrapperListener.onGpayErrorReceived(errorCode, description);
        }

        @Override
        public void onPaymentTerminate() {
            super.onPaymentTerminate();
            wrapperListener.onPaymentTerminate();
        }

        @Override
        public void onBackApprove() {
            super.onBackApprove();
            wrapperListener.onBackApprove();
        }

        @Override
        public void onBackDismiss() {
            super.onBackDismiss();
            wrapperListener.onBackDismiss();
        }

        @Override
        public void onBackButton(AlertDialog.Builder alertDialogBuilder) {
            super.onBackButton(alertDialogBuilder);
            wrapperListener.onBackButton(alertDialogBuilder);
        }
    };

}
