package com.payu.gpay;

import android.app.Activity;
import android.support.annotation.IntDef;
import android.support.annotation.NonNull;
import android.view.View;

import com.payu.gpay.callbacks.PayUGPayCallback;
import com.payu.gpay.utils.GPayData;
import com.payu.gpay.utils.PaymentTypeForMerchant;

/**
 * @author shahbaz.ahmmod
 * Entry point of the SDK.
 * Here checking payment available for test initiating payment from this class.
 */
public class GPay {

    private static GPay instance;
    public static String cb_version_name;
    public static String upi_sdk_version;

    private GPay() {
    }


    /**
     * @return
     */
    public static GPay getInstance() {
        synchronized (GPay.class) {
            if (instance == null)
                instance = new GPay();
            return instance;
        }
    }

    /**
     * @param activity
     * @param callback
     * @param paymentOptionHash
     * @param merchantKey
     * @param user_credentials
     */
    public void checkForPaymentAvailability(Activity activity, PayUGPayCallback callback, String paymentOptionHash, String merchantKey, String user_credentials) {
     GPayHandler gPayHandler = new GPayHandler();
        gPayHandler.checkForPaymentAvailability(activity,callback,paymentOptionHash,merchantKey,user_credentials);
    }

    /**
     * Creating payment.
     * Using from {@link GPayWrapper while making payment from Upi SDK or CB / Merchant application while making payment from
     * Standalone Gpay SDK.}
     *
     * @param activity
     * @param postData
     * @param payUGPayCallback
     */
    public void makePayment(Activity activity, String postData, final PayUGPayCallback payUGPayCallback, String merchantKey, View loadingDialogView) {
        makePayment(activity,postData, payUGPayCallback,merchantKey, loadingDialogView,PaymentTypeForMerchant.CARDS_UPI_BOTH);
    }

    /**
     *
     * @param activity
     * @param postData
     * @param payUGPayCallback
     * @param merchantKey
     * @param loadingDialogView
     * @param paymentType
     */
    public void makePayment(Activity activity, String postData, final PayUGPayCallback payUGPayCallback, String merchantKey, View loadingDialogView,@NonNull PaymentTypeForMerchant paymentType) {
        GPayData.SINGLETON.setPaymentTypeForMerchant(paymentType);
        GPayHandler gPayHandler = new GPayHandler();
        gPayHandler.makePayment(activity,postData,payUGPayCallback,merchantKey,loadingDialogView);

    }

}
