package com.payu.custombrowser;

/**
 * Created by himanshu.gupta on 20/04/18.
 */


import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.appcompat.app.AppCompatActivity;
import android.text.TextUtils;

import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.NH;
import com.payu.payuanalytics.analytics.PayUAnalytics;

import org.json.JSONObject;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;

public class PreLollipopPaymentsActivity extends AppCompatActivity {

    private W s;
    private String url;
    private String htmlData;
    private String txnId;
    private String merchantKey;
    private String postDataValue;
    private String s2sRetryUrl;
    private JSONObject postData;
    String packageName = "com.android.chrome";
    boolean ok;
    CustomTabsClient customTabsClient;
    CustomTabsIntent.Builder builder;
    CustomTabsServiceConnection customTabsServiceConnection;
    PayUAnalytics mAnalytics;
    private boolean isCustomTabsLaunched = false;
    private String payUResponse = null;

    /**
     * Called when the activity is first created.
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mAnalytics = PayUAnalytics.getInstance(getApplicationContext(), "local_cache_analytics");
        if(getIntent().getBundleExtra("data")!=null) {
            url = getIntent().getBundleExtra("data").getString("url");
            txnId = getIntent().getBundleExtra("data").getString("txnId");
            merchantKey = getIntent().getBundleExtra("data").getString("key");
            htmlData = getIntent().getBundleExtra("data").getString("html");
            postDataValue = getIntent().getBundleExtra("data").getString("postdata");
            s2sRetryUrl = getIntent().getBundleExtra("data").getString(CBConstant.S2S_RETRY_URL);
//        if (url != null || htmlData != null) {
            s = new W();
            try {
                s.st();
            } catch (IOException ioe) {
                if (Bank.DEBUG)
                    ioe.printStackTrace();
            }
            customTabsServiceConnection = new CustomTabsServiceConnection() {
                @Override
                public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                    customTabsClient = client;
                    customTabsClient.warmup(1);
                    builder = new CustomTabsIntent.Builder();
                    builder.enableUrlBarHiding();
                    builder.setShowTitle(false);
                    CustomTabsIntent customTabsIntent = builder.build();
                    if (packageName != null) {
                        customTabsIntent.intent.setPackage(packageName);
                    }
                    if (!TextUtils.isEmpty(htmlData)) {//Load s2s html data in CCT
                        addEventAnalytics(CBAnalyticsConstant.CB_STATUS, CBAnalyticsConstant.CUSTOM_TABS_LOAD_HTML);
                        customTabsIntent.launchUrl(PreLollipopPaymentsActivity.this, Uri.parse("http://127.0.0.1:8080/htmldata"));
                        isCustomTabsLaunched = true;
                    }else if(!TextUtils.isEmpty(s2sRetryUrl)){//Load s2s url in CCT
                        addEventAnalytics(CBAnalyticsConstant.CB_STATUS, CBAnalyticsConstant.CUSTOM_TABS_LOAD_HTML);
                        customTabsIntent.launchUrl(PreLollipopPaymentsActivity.this, Uri.parse(s2sRetryUrl));
                        isCustomTabsLaunched = true;
                    }else if(!TextUtils.isEmpty(url) && !TextUtils.isEmpty(postDataValue)) {
                        CBUtil cbUtil = new CBUtil();
                        postData = new JSONObject(cbUtil.getDataFromPostData(postDataValue));
                        customTabsIntent.launchUrl(PreLollipopPaymentsActivity.this, Uri.parse("http://127.0.0.1:8080"));
                        isCustomTabsLaunched = true;
                    }else {
                        isCustomTabsLaunched = false;
                        if(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()!=null)
                            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onCBErrorReceived(CBConstant.POST_DATA_OR_HTML_DATA_NOT_PRESENT_CODE, CBConstant.POST_DATA_OR_HTML_DATA_NOT_PRESENT);
                        finishChromeTab();
                    }

                }

                @Override
                public void onServiceDisconnected(ComponentName name) {
                }
            };
            ok = CustomTabsClient.bindCustomTabsService(this, packageName, customTabsServiceConnection);
        } else {
            if (getIntent() != null && getIntent().getData() != null && !TextUtils.isEmpty(getIntent().getData().getQuery())) {
                String scheme = getIntent().getData().getScheme();
//                Log.d(TAG, "onCreate: " + getIntent().getData().getScheme());
//                Log.d(TAG, "onCreate: " + getIntent().getData().getQuery());
                String response = getIntent().getData().getQuery();
                    String[] responseArray = response.split("[$][|]");
                    String res = responseArray[0];
                String merchantResponse = convertUriToJson(res);
                    if (responseArray.length > 1) {
                        String payRes = responseArray[1];
                        payUResponse = convertUriToJson(payRes);
                    }
                    if (scheme.contains(CBConstant.SUCCESS)) {
                        addEventAnalytics(CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.SUCCESS_TRANSACTION_CUSTOM_TABS);
                        if(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()!=null)
                              CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentSuccess(payUResponse, merchantResponse);
                    } else {
                        addEventAnalytics(CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.FAILURE_TRANSACTION_CUSTOM_TABS);
                        if(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()!=null)
                            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentFailure(payUResponse, merchantResponse);
                    }
            } else {
                if(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()!=null)
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onCBErrorReceived(CBConstant.RESPONSE_NOT_PRESENT_CODE, CBConstant.RESPONSE_NOT_PRESENT);
            }
            finishChromeTab();
//            finish();
        }

    }

    private String convertUriToJson(String a) {
        String res = "{\"";

        for (int i = 0; i < a.length(); i++) {
            if (a.charAt(i) == '=') {
                res += "\"" + ":" + "\"";
            } else if (a.charAt(i) == '&') {
                res += "\"" + "," + "\"";
            } else {
                res += a.charAt(i);
            }
        }
        res += "\"" + "}";
        return res;
    }

    @Override
    public void onNewIntent(Intent intent) {
        this.setIntent(intent);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (s != null)
            s.stop();
        if (customTabsServiceConnection != null)
            unbindService(customTabsServiceConnection);
        customTabsServiceConnection = null;
    }

    private class W extends NH {

        W() {
            super(8080);
        }

        @Override
        public R serve(String uri, Method method,
                       Map<String, String> header,
                       Map<String, String> parameters,
                       Map<String, String> files) {
            String msg = null;
            if (uri.endsWith("/htmldata")) {
                msg = htmlData;
            } else if(!TextUtils.isEmpty(url) && postData!=null) {
                msg = "<html><head><link rel=\"icon\" type=\"image/png\" href=\"data:image/png;base64,iVBORw0KGgo=\">" +
                        "</head>" +
                        "<body>" +
                        " <SCRIPT TYPE=\"text/JavaScript\">" +
                        "var f = document.createElement(\"form\");\n" +
                        "f.setAttribute('method',\"post\");\n" +
                        "f.setAttribute('name',\"dynamic\");\n" +
                        "f.setAttribute('action',\"" + url + "\");\n" +
//                        "f.setAttribute('action',\"" + "app://payment" + "\");\n"+
                        "var json = " + postData.toString() + ";" +
                        "var objVal = Object.keys(json);" +
                        "for(var count=0 ; count<objVal.length;count++){" +
                        "var i = document.createElement(\"input\");" +
                        "i.setAttribute('type',\"hidden\");" +
                        "i.name = objVal[count];" +
                        "i.value = json[objVal[count]];" +
                        "f.appendChild(i);}" +
                        "var button = document.createElement(\"input\");" +
                        "button.setAttribute('type',\"submit\");" +
                        "button.setAttribute('style',\"display: none;\");" +
                        "f.appendChild(button);" +
                        "document.getElementsByTagName('body')[0].appendChild(f);" +
                        "</SCRIPT><SCRIPT TYPE=\"text/JavaScript\">document.forms[\"dynamic\"].submit();</SCRIPT></body></html>";
            }
            // return newFixedLengthResponse(msg + "</body></html>\n");
//            Log.i(TAG, "local s requesting uri " + msg + " with parameters " + parameters.toString());

            return new R(msg);
            // return new Response(Response.Status.OK, "image/jpg", imageFile);
        }

    }

    @Override
    protected void onResume() {
        super.onResume();
        if (isCustomTabsLaunched) {
            addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.CUSTOM_TABS_CANCELLED);
            if(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()!=null)
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackApprove();
            isCustomTabsLaunched = false;
            finishChromeTab();
        }
    }

    /**
     * Logging events with txnid and package name.
     * Mixpannel used only in debug mode.
     *
     * @param key   analytics event key
     * @param value analytics event value
     */
    void addEventAnalytics(String key, String value) {
        try {
            if (value != null && !value.trim().equalsIgnoreCase("")) {
                mAnalytics.log(getLogMessage(getApplicationContext(), key, value.toLowerCase(), null, Bank.keyAnalytics, Bank.transactionID, ""));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Provide JSONObject for analytics
     *
     * @param context        application context
     * @param key            analytics event ket
     * @param value          event value
     * @param bank           name of the bank
     * @param sdkMerchantKey merchant key
     * @param trnxID         transaction  ID
     * @return
     */
    public String getLogMessage(Context context, String key, String value, String bank, String sdkMerchantKey, String trnxID, String pageType) {
        try {
            JSONObject eventAnalytics = new JSONObject();
//            eventAnalytics.put(CBAnalyticsConstant.PAYU_ID, getCookie(CBConstant.PAYUID, context));
            eventAnalytics.put(CBAnalyticsConstant.TRANSACTION_ID, txnId);
            eventAnalytics.put(CBAnalyticsConstant.MERCHANT_KEY, merchantKey);
            eventAnalytics.put(CBAnalyticsConstant.PAGE_TYPE, pageType);
            eventAnalytics.put(CBAnalyticsConstant.KEY, key);
            eventAnalytics.put(CBAnalyticsConstant.VALUE, URLEncoder.encode(value, "UTF-8"));
            eventAnalytics.put(CBAnalyticsConstant.BANK_NAME, (bank == null ? "" : bank));
            eventAnalytics.put(CBAnalyticsConstant.PAKAGE_NAME, context.getPackageName());
            eventAnalytics.put(CBAnalyticsConstant.TIMESTAMP, CBUtil.getSystemCurrentTime());
            return eventAnalytics.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return "{}";
        }
    }
    private void finishChromeTab(){
        Intent intent = new Intent(this,PrePaymentsActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
        this.overridePendingTransition(0,0);
    }

}
