package com.payu.custombrowser.bean;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.IntDef;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.view.View;
import android.widget.ArrayAdapter;

import com.payu.custombrowser.Bank;
import com.payu.custombrowser.R;
import com.payu.custombrowser.upiintent.Payment;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CustomBrowserConfig implements Parcelable {

    public static final int WARN_MODE = CBConstant.WARN_MODE;
    public static final int FAIL_MODE = CBConstant.FAIL_MODE;
    public static final int ENABLE = CBConstant.ENABLE;
    public static final int TRUE = CBConstant.ENABLE;
    public static final int DISABLE = CBConstant.DISABLE;
    public static final int FALSE = CBConstant.DISABLE;

    public String getPayUOptionPaymentHash() {
        return payUOptionPaymentHash;
    }

    public void setPayUOptionPaymentHash(String payUOptionPaymentHash) {
        this.payUOptionPaymentHash = payUOptionPaymentHash;
    }

    private String payUOptionPaymentHash;
    private int viewPortWideEnable;
    private int autoApprove;
    private int autoSelectOTP;
    private String transactionID;
    private String merchantKey;
    private String sdkVersionName;
    private int showCustombrowser;
    private int disableBackButtonDialog;
//    private int magicRetry = 1;
    private int merchantSMSPermission;
    private int enableSurePay; // 0 to disable snooze, +ive inter to configure number of times snooze window can appear for a transaction.
    private String merchantCheckoutActivityPath;
    private String postURL;
    private String payuPostData;
    private String htmlData;
    // Sure pay notification id.
    private int surePayNotificationIcon;
    // sPN sure pay notification
    // title, header, body of forward journey
    private String surePayNotificationGoodNetworkTitle;
    private String surePayNotificationGoodNetWorkHeader;
    private String surePayNotificationGoodNetWorkBody;
    // sPN sure pay notification
    // title, header, body of could not identify internet with int SNOOZE_TTL (30 min)
    private String surePayNotificationPoorNetWorkTitle;
    private String surePayNotificationPoorNetWorkHeader;
    private String surePayNotificationPoorNetWorkBody;
    // title, header, body of Transaction verified. - success response.
    private String surePayNotificationTransactionVerifiedTitle;
    private String surePayNotificationTransactionVerifiedHeader;

    private String surePayNotificationTransactionVerifiedBody;
    // title, header, body of Transaction verified. - success response.
    private String surePayNotificationTransactionNotVerifiedTitle;
    private String surePayNotificationTransactionNotVerifiedHeader;
    private String surePayNotificationTransactionNotVerifiedBody;
    private int surePayMode;
    // Living time of Snooze service.
    private int surePayBackgroundTTL;

    private int internetRestoredWindowTTL;
    //Merchant surl/furl loading timeout
    private int merchantResponseTimeout;
    private String surePayNotificationChannelId;

    public ArrayAdapter getCbMenuAdapter() {
        return cbMenuAdapter;
    }

    public void setCbMenuAdapter(ArrayAdapter cbMenuAdapter) {
        this.cbMenuAdapter = cbMenuAdapter;
    }

    private ArrayAdapter cbMenuAdapter;

    // Review order config
    private int enableReviewOrder; // Can have value ENABLE or DISABLE to enable or disable Review order resp.
    private String reviewOrderButtonText; // Custom text for review order button
    private int reviewOrderButtonTextColor; // Custom color for review order
    private transient  ReviewOrderBundle reviewOrderDefaultViewData; // Bundle data for review order screen. Can hace key value pairs
    private int reviewOrderCustomView; // Custom review order view set by merchant
    private static View toolBarView;
    private int cbDrawerCustomMenu;
    private int enableWebFlow;
    private int gmsProviderUpdatedStatus ;
    private String surepayS2Surl;
    private String reactVersion;
    private int isPhonePeUserCacheEnabled;
    private View progressDialogCustomView;

    private List<String> domainUrlListToUnclear= new ArrayList<>();
    private String paymentType;
    private StringBuffer analyticsBuffer;
    private String packageNameForSpecificApp;
    private String webServiceUrl;

    private int disableIntentSeamlessFailure=DISABLE;
    @IntDef({ENABLE, DISABLE})
    public @interface DisableIntentSeamlessFailure{

    }
    public String getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public String getPackageNameForSpecificApp() {
        return packageNameForSpecificApp;
    }

    public void setPackageNameForSpecificApp(String packageNameForSpecificApp) {
        this.packageNameForSpecificApp = packageNameForSpecificApp;
    }

    public int getCbDrawerCustomMenu() {
        return cbDrawerCustomMenu;
    }

    public void setCbDrawerCustomMenu(int cbDrawerCustomMenu) {
        this.cbDrawerCustomMenu = cbDrawerCustomMenu;
    }


    public int getDisableIntentSeamlessFailure() {
        return disableIntentSeamlessFailure;
    }

    public void setDisableIntentSeamlessFailure(@DisableIntentSeamlessFailure  int disableIntentSeamlessFailure) {
        this.disableIntentSeamlessFailure = disableIntentSeamlessFailure;
    }


    public View getToolBarView() {
        return toolBarView;
    }

    public void setToolBarView(View toolBarView) {
        this.toolBarView = toolBarView;
    }

    public static final Creator<CustomBrowserConfig> CREATOR = new Creator<CustomBrowserConfig>() {
        @Override
        public CustomBrowserConfig createFromParcel(Parcel in) {
            return new CustomBrowserConfig(in);
        }

        @Override
        public CustomBrowserConfig[] newArray(int size) {
            return new CustomBrowserConfig[size];
        }
    };

    private CustomBrowserConfig() {
    }

    protected CustomBrowserConfig(Parcel in) {
        viewPortWideEnable = in.readInt();
        autoApprove = in.readInt();
        autoSelectOTP = in.readInt();
        transactionID = in.readString();
        merchantKey = in.readString();
        sdkVersionName = in.readString();
        showCustombrowser = in.readInt();
        disableBackButtonDialog = in.readInt();
//        magicRetry = in.readInt();
        merchantSMSPermission = in.readInt();
        enableSurePay = in.readInt();
        merchantCheckoutActivityPath = in.readString();
        postURL = in.readString();
        payuPostData = in.readString();
        htmlData = in.readString();
        surePayNotificationIcon = in.readInt();
        surePayNotificationGoodNetworkTitle = in.readString();
        surePayNotificationGoodNetWorkHeader = in.readString();
        surePayNotificationGoodNetWorkBody = in.readString();
        surePayNotificationPoorNetWorkTitle = in.readString();
        surePayNotificationPoorNetWorkHeader = in.readString();
        surePayNotificationPoorNetWorkBody = in.readString();
        surePayNotificationTransactionVerifiedTitle = in.readString();
        surePayNotificationTransactionVerifiedHeader = in.readString();
        surePayNotificationTransactionVerifiedBody = in.readString();
        surePayNotificationTransactionNotVerifiedTitle = in.readString();
        surePayNotificationTransactionNotVerifiedHeader = in.readString();
        surePayNotificationTransactionNotVerifiedBody = in.readString();
        surePayNotificationChannelId = in.readString();
        surePayMode = in.readInt();
        surePayBackgroundTTL = in.readInt();
        internetRestoredWindowTTL = in.readInt();
        reviewOrderCustomView = in.readInt();
        enableReviewOrder = in.readInt();
        reviewOrderButtonText = in.readString();
        reviewOrderButtonTextColor = in.readInt();
        cbDrawerCustomMenu = in.readInt();
        enableWebFlow = in.readInt();
        gmsProviderUpdatedStatus = in.readInt();
        surepayS2Surl = in.readString();
        isPhonePeUserCacheEnabled = in.readInt();
        merchantResponseTimeout = in.readInt();

        paymentType = in.readString();
        webServiceUrl = in.readString();
        analyticsBuffer= new StringBuffer(in.readString());
        domainUrlListToUnclear = in.readArrayList(null);
        packageNameForSpecificApp= in.readString();
    }

    public CustomBrowserConfig(@NonNull @Size(min = 6, max = 6) String merchantKey, @NonNull String transactionID) {
        this.analyticsBuffer = new StringBuffer();
        this.transactionID = transactionID;
        this.merchantKey = merchantKey;

        this.surePayNotificationIcon = R.drawable.surepay_logo;
        this.surePayNotificationGoodNetworkTitle = "Internet Restored";
        this.surePayNotificationGoodNetWorkHeader = "You can now resume the transaction";

        this.surePayNotificationPoorNetWorkTitle = "No Internet Found";
        this.surePayNotificationPoorNetWorkHeader = "We could not detect internet on your device";

        this.surePayNotificationTransactionVerifiedTitle = "Transaction Verified";
        this.surePayNotificationTransactionVerifiedHeader = "The bank has verified this transaction and we are good to go.";

        this.surePayNotificationTransactionNotVerifiedTitle = "Transaction Status Unknown";
        this.surePayNotificationTransactionNotVerifiedHeader = "The bank could not verify the transaction at this time.";
        //Default value of Notification Channel Id for Sdk level > Android O
        this.surePayNotificationChannelId = CBConstant.NOTIFICATION_CHANNEL_ID;
        // Default value of maximum snooze count is three.(disable snooze by setting value to 0)
        this.enableSurePay = 0;

        // Default snooze mode is snooze + mr (Warn mode)
        this.surePayMode = CBConstant.WARN_MODE;

        this.surePayBackgroundTTL = CBConstant.DEFAULT_SURE_PAY_TTL;

        this.internetRestoredWindowTTL = CBConstant.INTERNET_RESTORED_WINDOW_TTL;
        this.reviewOrderCustomView = -1;
        this.enableReviewOrder = CBConstant.DISABLE;
        this.reviewOrderButtonTextColor = -1;
        //Default value of webflow payment is true
        this.enableWebFlow = 1;
        //Default value of ProviderChangeHandled is false
        this.gmsProviderUpdatedStatus = FALSE;
        this.isPhonePeUserCacheEnabled = TRUE;
        this.merchantResponseTimeout = CBConstant.MERCHANT_URL_LOADING_TIMEOUT;
        this.webServiceUrl = CBConstant.PRODUCTION_FETCH_DATA_URL;
    }


    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(viewPortWideEnable);
        dest.writeInt(autoApprove);
        dest.writeInt(autoSelectOTP);
        dest.writeString(transactionID);
        dest.writeString(merchantKey);
        dest.writeString(sdkVersionName);
        dest.writeInt(showCustombrowser);
        dest.writeInt(disableBackButtonDialog);
//        dest.writeInt(magicRetry);
        dest.writeInt(merchantSMSPermission);
        dest.writeInt(enableSurePay);
        dest.writeString(merchantCheckoutActivityPath);
        dest.writeString(postURL);
        dest.writeString(payuPostData);
        dest.writeString(htmlData);
        dest.writeInt(surePayNotificationIcon);
        dest.writeString(surePayNotificationGoodNetworkTitle);
        dest.writeString(surePayNotificationGoodNetWorkHeader);
        dest.writeString(surePayNotificationGoodNetWorkBody);
        dest.writeString(surePayNotificationPoorNetWorkTitle);
        dest.writeString(surePayNotificationPoorNetWorkHeader);
        dest.writeString(surePayNotificationPoorNetWorkBody);
        dest.writeString(surePayNotificationTransactionVerifiedTitle);
        dest.writeString(surePayNotificationTransactionVerifiedHeader);
        dest.writeString(surePayNotificationTransactionVerifiedBody);
        dest.writeString(surePayNotificationTransactionNotVerifiedTitle);
        dest.writeString(surePayNotificationTransactionNotVerifiedHeader);
        dest.writeString(surePayNotificationTransactionNotVerifiedBody);
        dest.writeString(surePayNotificationChannelId);
        dest.writeInt(surePayMode);
        dest.writeInt(surePayBackgroundTTL);
        dest.writeInt(internetRestoredWindowTTL);
        dest.writeInt(reviewOrderCustomView);
        dest.writeInt(enableReviewOrder);
        dest.writeString(reviewOrderButtonText);
        dest.writeInt(reviewOrderButtonTextColor);
        dest.writeInt(cbDrawerCustomMenu);
        dest.writeInt(enableWebFlow);
        dest.writeInt(gmsProviderUpdatedStatus);
        dest.writeString(surepayS2Surl);
        dest.writeInt(isPhonePeUserCacheEnabled);
        dest.writeInt(merchantResponseTimeout);
        dest.writeString(paymentType);
        dest.writeString(webServiceUrl);
        dest.writeString(analyticsBuffer.toString());
        dest.writeList(domainUrlListToUnclear);
        dest.writeString(packageNameForSpecificApp);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getPostURL() {
        return postURL;
    }

    public void setPostURL(String postURL) {
        this.postURL = postURL;
    }

    public String getPayuPostData() {
        return payuPostData;
    }

    public void setPayuPostData(String payuPostData) {
        this.payuPostData = payuPostData;

        // here we set the sure pay notification values also.
        HashMap<String, String> postParams = new CBUtil().getDataFromPostData(payuPostData);
        String defaultText = "Product info: " + postParams.get("productinfo") + "\nAmount: " + postParams.get("amount");
        if (null == this.surePayNotificationGoodNetWorkBody) {
            this.surePayNotificationGoodNetWorkBody = defaultText;//Changed as we don't want this data in our analytics
        }
        if (null == this.surePayNotificationPoorNetWorkBody) {
            this.surePayNotificationPoorNetWorkBody= defaultText;
        }
        if (null == this.surePayNotificationTransactionVerifiedBody) {
            this.surePayNotificationTransactionVerifiedBody = defaultText;
        }
        if (null == this.surePayNotificationTransactionNotVerifiedBody) {
            this.surePayNotificationTransactionNotVerifiedBody = defaultText;
        }

        // We set the merchant key once the user set post data in cb config.
        if (null != postParams.get(CBConstant.KEY)) {
            this.setMerchantKey(null == Bank.keyAnalytics ? postParams.get(CBConstant.KEY) : Bank.keyAnalytics);
        }

    }

    public int getEnableSurePay() {
        return enableSurePay;
    }

    public void setEnableSurePay(@IntRange(from=0, to=3) int enableSurePay) {
        this.enableSurePay = enableSurePay > 3 ? 3 : enableSurePay;
        addAnalyticsData("esp_",this.enableSurePay+"");
    }

    public int getMerchantSMSPermission() {
        return merchantSMSPermission;
    }

    public void setMerchantSMSPermission(boolean merchantSMSPermission) {
        this.merchantSMSPermission = merchantSMSPermission ? 1 : 0;
        addAnalyticsData("msp_",this.merchantSMSPermission+"");
    }

    public int getEnableWebFlow() {
        return enableWebFlow;
    }

    @Deprecated
    public void setEnableWebFlow(Payment payment, boolean enableWebFlow) {
        payment.setWebFlowSupported(enableWebFlow);
    }

//    public int getMagicretry() {
//        return magicRetry;
//    }
//
//    public void setmagicRetry(boolean magicRetry) {
//        this.magicRetry = magicRetry ? 1 : 0;
//        addAnalyticsData("mr_",this.magicRetry+"");
//    }

    public String getMerchantCheckoutActivityPath() {
        return merchantCheckoutActivityPath;
    }

    public void setMerchantCheckoutActivityPath(String merchantCheckoutActivityPath) {
        this.merchantCheckoutActivityPath = merchantCheckoutActivityPath;
        addAnalyticsData("mcap_",this.merchantCheckoutActivityPath!=null?"1":"0");
    }

    public int getDisableBackButtonDialog() {
        return disableBackButtonDialog;
    }

    public void setDisableBackButtonDialog(boolean disableBackButtonDialog) {
        this.disableBackButtonDialog = disableBackButtonDialog ? 1 : 0;
        addAnalyticsData("dbbd_",this.disableBackButtonDialog+"");
    }

    public int getViewPortWideEnable() {
        return viewPortWideEnable;
    }

    public void setViewPortWideEnable(boolean viewPortWideEnable) {
        this.viewPortWideEnable = viewPortWideEnable ? 1 : 0;
        addAnalyticsData("vpwe_",this.disableBackButtonDialog+"");
    }

    public int getAutoApprove() {
        return autoApprove;
    }

    public void setAutoApprove(boolean autoApprove) {
        this.autoApprove = autoApprove ? 1 : 0;
        addAnalyticsData("aa_",this.autoApprove+"");
    }

    public String getTransactionID() {
        return transactionID;
    }


    public int getAutoSelectOTP() {
        return autoSelectOTP;
    }

    public void setAutoSelectOTP(boolean autoSelectOTP) {
        this.autoSelectOTP = autoSelectOTP ? 1 : 0;
        addAnalyticsData("aso_",this.autoSelectOTP+"");
    }

    public String getMerchantKey() {
        return merchantKey;
    }

    /**
     * Setter for merchant key.
     * it should take the values in the following order.
     * 1. {@link Bank#keyAnalytics}
     * 2. {@link CustomBrowserConfig#setPayuPostData(String)}
     * 3. {@link CustomBrowserConfig#setMerchantKey(String)}
     *
     * @param merchantKey
     */
    public void setMerchantKey(String merchantKey) {
        this.merchantKey = Bank.keyAnalytics;
        if (null == this.merchantKey || this.merchantKey.trim().length() < 1) {
            this.merchantKey = merchantKey;
            Bank.keyAnalytics = merchantKey;
        }
        addAnalyticsData("mk_",this.merchantKey);
    }

    public String getSdkVersionName() {
        return sdkVersionName;
    }

    public void setSdkVersionName(String sdkVersionName) {
        this.sdkVersionName = sdkVersionName;
        addAnalyticsData("svn_",this.surePayMode+"");
    }

    public int getShowCustombrowser() {
        return showCustombrowser;
    }

    public void setShowCustombrowser(boolean showCustombrowser) {
        this.showCustombrowser = showCustombrowser ? 1 : 0;
        addAnalyticsData("scb_",this.showCustombrowser+"");
    }

    public String getSurePayNotificationGoodNetworkTitle() {
        return surePayNotificationGoodNetworkTitle;
    }

    public void setSurePayNotificationGoodNetworkTitle(String surePayNotificationGoodNetworkTitle) {
        this.surePayNotificationGoodNetworkTitle = surePayNotificationGoodNetworkTitle;
        addAnalyticsData("spngnt_",this.surePayNotificationGoodNetworkTitle!=null?"1":"0");
    }

    public String getSurePayNotificationGoodNetWorkHeader() {
        return surePayNotificationGoodNetWorkHeader;
    }

    public void setSurePayNotificationGoodNetWorkHeader(String surePayNotificationGoodNetWorkHeader) {
        this.surePayNotificationGoodNetWorkHeader = surePayNotificationGoodNetWorkHeader;
        addAnalyticsData("spngnh_",this.surePayNotificationGoodNetWorkHeader!=null?"1":"0");
    }

    public String getSurePayNotificationGoodNetWorkBody() {
        return surePayNotificationGoodNetWorkBody;
    }

    public void setSurePayNotificationGoodNetWorkBody(String surePayNotificationGoodNetWorkBody) {
        this.surePayNotificationGoodNetWorkBody = surePayNotificationGoodNetWorkBody;
        addAnalyticsData("spngnb_",this.surePayNotificationGoodNetWorkBody!=null?"1":"0");
    }

    public String getSurePayNotificationPoorNetWorkTitle() {
        return surePayNotificationPoorNetWorkTitle;
    }

    public void setSurePayNotificationPoorNetWorkTitle(String surePayNotificationPoorNetWorkTitle) {
        this.surePayNotificationPoorNetWorkTitle = surePayNotificationPoorNetWorkTitle;
        addAnalyticsData("spnpnt_",this.surePayNotificationPoorNetWorkTitle!=null?"1":"0");
    }

    public String getSurePayNotificationPoorNetWorkHeader() {
        return surePayNotificationPoorNetWorkHeader;
    }

    public void setSurePayNotificationPoorNetWorkHeader(String surePayNotificationPoorNetWorkHeader) {
        this.surePayNotificationPoorNetWorkHeader = surePayNotificationPoorNetWorkHeader;
        addAnalyticsData("spnpnh_",this.surePayNotificationPoorNetWorkHeader!=null?"1":"0");
    }

    public String getSurePayNotificationPoorNetWorkBody() {
        return surePayNotificationPoorNetWorkBody;
    }

    public void setSurePayNotificationPoorNetWorkBody(String surePayNotificationPoorNetWorkBody) {
        this.surePayNotificationPoorNetWorkBody = surePayNotificationPoorNetWorkBody;
        addAnalyticsData("spnpnb_",this.surePayNotificationPoorNetWorkBody!=null?"1":"0");
    }

    public String getSurePayNotificationTransactionVerifiedTitle() {
        return surePayNotificationTransactionVerifiedTitle;
    }

    public void setSurePayNotificationTransactionVerifiedTitle(String surePayNotificationTransactionVerifiedTitle) {
        this.surePayNotificationTransactionVerifiedTitle = surePayNotificationTransactionVerifiedTitle;
        addAnalyticsData("spntvt_",this.surePayNotificationTransactionVerifiedTitle!=null?"1":"0");
    }

    public String getSurePayNotificationTransactionVerifiedHeader() {
        return surePayNotificationTransactionVerifiedHeader;
    }

    public void setSurePayNotificationTransactionVerifiedHeader(String surePayNotificationTransactionVerifiedHeader) {
        this.surePayNotificationTransactionVerifiedHeader = surePayNotificationTransactionVerifiedHeader;
        addAnalyticsData("spntvh_",this.surePayNotificationTransactionVerifiedHeader!=null?"1":"0");
    }

    public String getSurePayNotificationTransactionVerifiedBody() {
        return surePayNotificationTransactionVerifiedBody;
    }

    public void setSurePayNotificationTransactionVerifiedBody(String surePayNotificationTransactionVerifiedBody) {
        this.surePayNotificationTransactionVerifiedBody = surePayNotificationTransactionVerifiedBody;
        addAnalyticsData("spntvb_",this.surePayNotificationTransactionVerifiedBody!=null?"1":"0");
    }

    public String getSurePayNotificationTransactionNotVerifiedTitle() {
        return surePayNotificationTransactionNotVerifiedTitle;
    }

    public void setSurePayNotificationTransactionNotVerifiedTitle(String surePayNotificationTransactionNotVerifiedTitle) {
        this.surePayNotificationTransactionNotVerifiedTitle = surePayNotificationTransactionNotVerifiedTitle;
        addAnalyticsData("spntnvt_",this.surePayNotificationTransactionNotVerifiedTitle!=null?"1":"0");
    }

    public String getSurePayNotificationTransactionNotVerifiedHeader() {
        return surePayNotificationTransactionNotVerifiedHeader;
    }

    public void setSurePayNotificationTransactionNotVerifiedHeader(String surePayNotificationTransactionNotVerifiedHeader) {
        this.surePayNotificationTransactionNotVerifiedHeader = surePayNotificationTransactionNotVerifiedHeader;
        addAnalyticsData("spntnvh_",this.surePayNotificationTransactionNotVerifiedHeader!=null?"1":"0");
    }

    public String getSurePayNotificationTransactionNotVerifiedBody() {
        return surePayNotificationTransactionNotVerifiedBody;
    }

    public void setSurePayNotificationTransactionNotVerifiedBody(String surePayNotificationTransactionNotVerifiedBody) {
        this.surePayNotificationTransactionNotVerifiedBody = surePayNotificationTransactionNotVerifiedBody;
        addAnalyticsData("spntnvb_",this.surePayNotificationTransactionNotVerifiedBody!=null?"1":"0");
    }

    public int getSurePayNotificationIcon() {
        return surePayNotificationIcon;
    }

    public void setSurePayNotificationIcon(int surePayNotificationIcon) {
        this.surePayNotificationIcon = surePayNotificationIcon;
        addAnalyticsData("irwttl_",this.surePayNotificationIcon>0?"1":"0");
    }

    public int getSurePayMode() {
        return surePayMode;
    }

    public void setSurePayMode(@SnoozeMode int surePayMode) {
        this.surePayMode = surePayMode;
        addAnalyticsData("spm_",this.surePayMode+"");
    }

    public int getInternetRestoredWindowTTL() {
        return internetRestoredWindowTTL;
    }

    public void setInternetRestoredWindowTTL(int internetRestoredWindowTTL) {
        this.internetRestoredWindowTTL = internetRestoredWindowTTL;
        addAnalyticsData("irwttl_",this.internetRestoredWindowTTL+"");
    }


    @IntDef({ENABLE, DISABLE})
    public @interface ReviewOrder{

    }

    @IntDef({WARN_MODE, FAIL_MODE})
    @Retention(RetentionPolicy.SOURCE)
    public @interface SnoozeMode {
    }


    public String getReviewOrderButtonText() {
        return reviewOrderButtonText;
    }

    public void setReviewOrderButtonText(@NonNull @Size(max = 16)  String reviewOrderButtonText) {
        if(reviewOrderButtonText==null){
          throw new RuntimeException("ReviewOrderButtonText cannot be null");
        }else if(reviewOrderButtonText.length() >16){
           throw new RuntimeException("ReviewOrderButtonText size should be less than 16");
        }else {
            this.reviewOrderButtonText = reviewOrderButtonText;
        }
        addAnalyticsData("robt_",this.reviewOrderButtonText);
    }

    public int getReviewOrderButtonTextColor() {
        return reviewOrderButtonTextColor;
    }

    public void setReviewOrderButtonTextColor(@ColorRes  int reviewOrderButtonTextColor) {
        this.reviewOrderButtonTextColor = reviewOrderButtonTextColor;
        addAnalyticsData("robtc_",this.reviewOrderButtonTextColor>0?"1":"0");
    }

    public int getEnableReviewOrder() {
        return enableReviewOrder;
    }

    public void setEnableReviewOrder(@ReviewOrder  int enableReviewOrder) {
        this.enableReviewOrder = enableReviewOrder;
        addAnalyticsData("ero_",this.enableReviewOrder+"");
    }

    public int getSurePayBackgroundTTL() {
        return surePayBackgroundTTL;
    }

    public void setSurePayBackgroundTTL(int surePayBackgroundTTL) {
        this.surePayBackgroundTTL = surePayBackgroundTTL;
        addAnalyticsData("spbttl_",this.surePayBackgroundTTL+"");
    }

    public int getReviewOrderCustomView() {
        return reviewOrderCustomView;
    }

    public void setReviewOrderCustomView(@LayoutRes int reviewOrderCustomView) {
        this.reviewOrderCustomView = reviewOrderCustomView;
        addAnalyticsData("rocv_",this.reviewOrderCustomView>0?"1":"0");
    }

    public ReviewOrderBundle getReviewOrderDefaultViewData() {
        return reviewOrderDefaultViewData;
    }

    public void setReviewOrderDefaultViewData(ReviewOrderBundle reviewOrderDefaultViewData) {
        this.reviewOrderDefaultViewData = reviewOrderDefaultViewData;
    }

    public int getGmsProviderUpdatedStatus() {
        return gmsProviderUpdatedStatus;
    }

    public void setGmsProviderUpdatedStatus(int gmsProviderUpdatedStatus) {
        this.gmsProviderUpdatedStatus = gmsProviderUpdatedStatus;
        addAnalyticsData("gpus_",this.gmsProviderUpdatedStatus+"");
    }

    public String getHtmlData() {
        return htmlData;
    }

    public void setHtmlData(String htmlData) {
        this.htmlData = htmlData;
        addAnalyticsData("hd_",this.htmlData!=null?"1":"0");
    }
    /**
     * Function to get SurePay Notification Channel Id
     *
     * @return SurePay Notification Channel Id
     */
    public String getSurePayNotificationChannelId() {
        return surePayNotificationChannelId;
    }

    public void setSurePayNotificationChannelId(String surePayNotificationChannelId) {
        this.surePayNotificationChannelId = surePayNotificationChannelId;
        addAnalyticsData("spnci_",this.surePayNotificationChannelId);
    }


    public String getSurepayS2Surl() {
        return surepayS2Surl;
    }

    public void setSurepayS2Surl(String surepayS2Surl) {
        this.surepayS2Surl = surepayS2Surl;
        addAnalyticsData("spsu_",this.surepayS2Surl);
    }

    public void setReactVersion(String reactVersion) {
        this.reactVersion = reactVersion;
        addAnalyticsData("rv_",this.reactVersion);
    }

    public String getReactVersion() {
        return reactVersion;
    }

    public int getIsPhonePeUserCacheEnabled() {
        return isPhonePeUserCacheEnabled;
    }

    public void setIsPhonePeUserCacheEnabled(int isPhonePeUserCacheEnabled) {
        this.isPhonePeUserCacheEnabled = isPhonePeUserCacheEnabled;
        addAnalyticsData("ipuce_",this.isPhonePeUserCacheEnabled+"");
    }

    public int getMerchantResponseTimeout() {
        return merchantResponseTimeout;
    }

    public void setMerchantResponseTimeout(int merchantResponseTimeout) {
        this.merchantResponseTimeout = merchantResponseTimeout;
        addAnalyticsData("mrt_",this.merchantResponseTimeout+"");
    }

    public View getProgressDialogCustomView() {
        return progressDialogCustomView;
    }

    public void setProgressDialogCustomView(View progressDialogCustomView) {
        this.progressDialogCustomView = progressDialogCustomView;
        addAnalyticsData("pdcv_",this.progressDialogCustomView!=null?"1":"0");
    }

    public String getWebServiceUrl() {
        return webServiceUrl;
    }

    public void setWebServiceUrl(String webServiceUrl) {
        this.webServiceUrl = webServiceUrl;
        addAnalyticsData("wsu_",this.webServiceUrl!=null?"1":"0");
    }

    private void addAnalyticsData(String key,String value){
        this.analyticsBuffer.append(key);
        this.analyticsBuffer.append(value);
        this.analyticsBuffer.append("|");
    }

    public String getAnalyticsString(){
        return analyticsBuffer.toString();
    }

    public List<String> getDomainUrlListToUnclear() {
        return domainUrlListToUnclear;
    }

    public void setDomainUrlListToUnclear(List<String> domainUrlListToUnclear) {
        this.domainUrlListToUnclear.addAll(domainUrlListToUnclear);
    }
}
