package com.payu.custombrowser;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.bean.CustomBrowserResultData;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.util.PaymentOption;
import com.payu.custombrowser.wrapper.UpiWrapper;
import com.payu.payuanalytics.analytics.PayUAnalytics;

import static android.content.Context.NOTIFICATION_SERVICE;


public class CustomBrowser {

    /**
     * Function to check if payment is supported
     *
     * @param activity                  Activity instance
     * @param paymentOption             {@link com.payu.custombrowser.util.PaymentOption}Payment Type
     * @param payUCustomBrowserCallback {@link com.payu.custombrowser.PayUCustomBrowserCallback}PayUCustomBrowserCallback instance
     * @param paymentOptionHash         Hash for Payment Related Details api
     * @param merchantKey               Merchant Key
     * @param user_credentials          User Credentials
     */

    public void checkForPaymentAvailability(Activity activity, @NonNull PaymentOption paymentOption, @NonNull PayUCustomBrowserCallback payUCustomBrowserCallback, String paymentOptionHash, String merchantKey, String user_credentials) {
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(payUCustomBrowserCallback);
        CBUtil.settingMetaDataValues(activity);
        UpiWrapper upiWrapper = new UpiWrapper();
        switch (paymentOption) {
            case SAMSUNGPAY:
                if (CBUtil.isPaymentModuleAvailable(paymentOption)) {
                    upiWrapper.checkForPaymentOptionAvailability(activity, paymentOptionHash, merchantKey, user_credentials, PaymentOption.SAMSUNGPAY.getPaymentName());
                } else {
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED, CBConstant.DEVICE_NOT_SUPPORTED_OR + paymentOption.getPackageName() + CBConstant.IS_MISSING);
                }
                break;
           /*     case TEZ:

                if(CBUtil.isPaymentModuleAvailable(paymentOption)){
                    upiWrapper.checkForPaymentOptionAvailability(activity, paymentOptionHash, merchantKey, user_credentials, PaymentOption.TEZ.getPaymentName());
                }else{
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED,CBConstant.DEVICE_NOT_SUPPORTED_OR+paymentOption.getPackageName()+CBConstant.IS_MISSING);
                }
                break;*/
            case PHONEPE:
                if (CBUtil.isPaymentModuleAvailable(paymentOption)) {
                    upiWrapper.checkForPaymentOptionAvailability(activity, paymentOptionHash, merchantKey, user_credentials, PaymentOption.PHONEPE.getPaymentName());
                } else {
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED, CBConstant.DEVICE_NOT_SUPPORTED_OR + paymentOption.getPackageName() + CBConstant.IS_MISSING);
                }
                break;
            case TEZ:
            case UPI_INTENT:
            case UPI_COLLECT:
                if (CBUtil.isPaymentModuleAvailable(paymentOption)) {
                    CustomBrowserResultData customBrowserResultData = new CustomBrowserResultData();
                    customBrowserResultData.setPaymentOption(paymentOption);
                    customBrowserResultData.setPaymentOptionAvailable(true);

                    CustomBrowserData.SINGLETON.setPaymentOption(paymentOption);
                    payUCustomBrowserCallback.isPaymentOptionAvailable(customBrowserResultData);
                    //upiWrapper.checkForPaymentOptionAvailability(activity, paymentOptionHash, merchantKey, user_credentials, "UPI");

                } else {
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED, CBConstant.DEVICE_NOT_SUPPORTED_OR + paymentOption.getPackageName() + CBConstant.IS_MISSING);
                }
                break;
        }

    }

    /**
     * Call this method to add CustomBrowser to application
     *
     * @param activity                    base class activity
     * @param cbCustomBrowserConfig       contain the specification of CB
     * @param cbPayUCustomBrowserCallback provide callbacks
     */
    public void addCustomBrowser(Activity activity, @NonNull CustomBrowserConfig cbCustomBrowserConfig, @NonNull PayUCustomBrowserCallback cbPayUCustomBrowserCallback) {

        CBUtil.settingMetaDataValues(activity);
        PayUAnalytics analytics = PayUAnalytics.getInstance(activity.getApplicationContext(), "local_cache_analytics");
        analytics.log(CBUtil.getLogMessage(activity, "cb_config", cbCustomBrowserConfig.getAnalyticsString(), null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(cbPayUCustomBrowserCallback);
        cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData().concat("&sdk_platform="+new CBUtil().getAnalyticsData(cbCustomBrowserConfig.getPayuPostData())));
        PaymentOption paymentOptionName = new CBUtil().getPaymentOptionFromPostData(cbCustomBrowserConfig.getPayuPostData());
        if (!TextUtils.isEmpty(cbCustomBrowserConfig.getReactVersion()))
            analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.REACT_VERSION_NAME, cbCustomBrowserConfig.getReactVersion(), null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
        //Check if payment option is supported
        L.v("Class Name: " + getClass().getCanonicalName() + "Payment option name:" + paymentOptionName);
        //We have payment which is supported by UPI Sdk.Lets call UPI SDK
        if (paymentOptionName != null) {

            L.v("Class Name: " + getClass().getCanonicalName() + "PaymentOptionName CB " + paymentOptionName.getPaymentName());
            if (paymentOptionName.isDefault()){
                if(CBUtil.isPaymentModuleAvailable(paymentOptionName)) {
                    callUpiWrapper(paymentOptionName, cbCustomBrowserConfig, activity);
                }else {
                    cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED, paymentOptionName.getPackageName() + CBConstant.IS_MISSING);
                }
            } else if (CustomBrowserData.SINGLETON.isPaymentOptionAvailabilityCalled(paymentOptionName)) {
                callUpiWrapper(paymentOptionName, cbCustomBrowserConfig,activity);
            } else {
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), paymentOptionName.getAnalyticsKey().toLowerCase(), paymentOptionName.getAnalyticsKey().toLowerCase() + CBAnalyticsConstant.LAUNCH_FAILED, null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.CHECK_PAYMENT_NOT_CALLED, CBConstant.CHECK_PAYMENT_NOT_CALLED_MSG +" for "+paymentOptionName.getPaymentName());
            }
        } else if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
            //We don't support payments below JB
            analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.OS_NOT_SUPPORTED, Build.VERSION.SDK_INT + "", null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
            cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.OS_NOT_SUPPORTED_CODE, CBConstant.OS_NOT_SUPPORTED);
        } else if ((Build.VERSION.SDK_INT < 19)
                || (Build.VERSION.SDK_INT == 19 &&
                cbCustomBrowserConfig.getGmsProviderUpdatedStatus() == CustomBrowserConfig.FALSE)) {
            //For OS b/w JB & KK payment is by Chrome tabs only
            if (CBUtil.isCustomTabSupported(activity.getApplicationContext())) {
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.CUSTOM_TABS, CBAnalyticsConstant.CUSTOM_TABS_LAUNCHED, null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                Intent intent = new Intent(activity, PrePaymentsActivity.class);
                intent.putExtra("url", cbCustomBrowserConfig.getPostURL());
                intent.putExtra("html", cbCustomBrowserConfig.getHtmlData());
                intent.putExtra("postdata", cbCustomBrowserConfig.getPayuPostData());
                intent.putExtra(CBConstant.S2S_RETRY_URL, cbCustomBrowserConfig.getSurepayS2Surl());
                intent.putExtra("txnId", cbCustomBrowserConfig.getTransactionID());
                intent.putExtra("key", cbCustomBrowserConfig.getMerchantKey());
                activity.startActivity(intent);
            } else {
                //We support payment via Chrome tabs only below KK ,No Chrome tabs found,hence payment could not proceed.
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.CUSTOM_TABS, CBAnalyticsConstant.CUSTOM_TABS_LAUNCH_FAILED, null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.CHROME_NOT_PRESENT_CODE, CBConstant.CHROME_NOT_PRESENT);
            }
        } else {

            if (null != cbCustomBrowserConfig.getPayuPostData() && cbCustomBrowserConfig.getEnableSurePay() > 0 && (null != cbCustomBrowserConfig.getPostURL() && (cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL)
                    || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.MOBILE_TEST_PAYMENT_URL_SEAMLESS) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PRODUCTION_PAYMENT_URL_SEAMLESS)))) {
                // Sometimes post data contains & at the end, just removing it from the postdata
                if (cbCustomBrowserConfig.getPayuPostData().trim().endsWith("&")) {
                    cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData().substring(0, cbCustomBrowserConfig.getPayuPostData().length() - 1));
                }
                // Adding snooze=<snooze_count> in the post data being sent to payu server (_payment)
                cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData() + "&snooze=" + cbCustomBrowserConfig.getEnableSurePay());
            }
            //If merchant hasn't created a channel we create our default
            if (cbCustomBrowserConfig.getSurePayNotificationChannelId().equalsIgnoreCase(CBConstant.NOTIFICATION_CHANNEL_ID)) {
                createNotificationChannel(activity);
            }
            CBActivity.cbDrawerAdapter = cbCustomBrowserConfig.getCbMenuAdapter();
            CBActivity.cbConfigToolbarView = cbCustomBrowserConfig.getToolBarView();
            CBActivity.cbConfigProgressDialogView = cbCustomBrowserConfig.getProgressDialogCustomView();
            Intent intent = new Intent(activity, CBActivity.class);
            intent.putExtra("cb_config", cbCustomBrowserConfig);
            if (cbCustomBrowserConfig.getReviewOrderDefaultViewData() != null && cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas() != null) {
                intent.putExtra(CBConstant.ORDER_DETAILS, cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas());
            }
            activity.startActivity(intent);

        }
    }

    private void callUpiWrapper(PaymentOption paymentOptionName, CustomBrowserConfig cbCustomBrowserConfig, Activity activity) {
        UpiWrapper upiWrapper = new UpiWrapper();
        cbCustomBrowserConfig.setPaymentType(paymentOptionName.getPaymentName());
        CBUtil.setVariableReflection(CBConstant.UPI_SDK_PACKAGE, BuildConfig.VERSION_NAME, CBConstant.CB_VERSION); //Update cb version name in UPI sdk
        L.v("Class Name: " + getClass().getCanonicalName() + "< postdata >" + cbCustomBrowserConfig.getPayuPostData());
        upiWrapper.makePayment(activity, cbCustomBrowserConfig);
    }

    /**
     * Function to create Default Notification Channel
     * If parameters are same channel creation is ignored
     *
     * @param activity base class activity
     */
    @TargetApi(26)
    private void createNotificationChannel(Activity activity) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            @SuppressLint("WrongConstant")
            NotificationChannel mChannel = new NotificationChannel(CBConstant.NOTIFICATION_CHANNEL_ID, CBConstant.NOTIFICATION_CHANNEL_NAME, NotificationManager.IMPORTANCE_DEFAULT);
            mChannel.setDescription(CBConstant.NOTIFICATION_CHANNEL_DESCRIPTION);
            // Register the channel with the system; you can't change the importance
            // or other notification behaviors after this
            NotificationManager notificationManager = (NotificationManager) activity.getSystemService(
                    NOTIFICATION_SERVICE);
            if (null != notificationManager)
                notificationManager.createNotificationChannel(mChannel);
        }
    }

}
