package com.payu.custombrowser.wrapper;

import android.app.Activity;
import android.content.Context;
import android.view.View;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.bean.CustomBrowserResultData;
import com.payu.custombrowser.PackageListDialogFragment;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.util.PaymentOption;
import com.payu.payuanalytics.analytics.PayUAnalytics;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class UpiWrapper extends PaymentOptionWrapper {

    private ClassLoader upiWrapperClassLoader;
    private Constructor upiWrapperConstructor;
    private Class upiWrapperClass;
    private Object upiWrapperObject;
    private PayUAnalytics analytics;
    private Activity activity;
    private CustomBrowserConfig customBrowserConfig;
    private CBUtil cbUtil;
    private Method method;
    private PackageListDialogFragment packageListDialogFragment;
    /**
     * Reflection Callback mapping with PayUCustomBrowserCallback and wrapper callback and SamsungPay Wrapper Callback
     */
    private java.lang.reflect.InvocationHandler cbCallback = new java.lang.reflect.InvocationHandler() {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equalsIgnoreCase(CBConstant.PAYMENT_OPTION_SUCCESS)) {
                L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"   Success cb UpiWrapper " + args[0]);
                if (customBrowserConfig != null)
                    analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.SUCCESS_TRANSACTION, null, cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.KEY), cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.TXNID), null));
                if (cbListener != null)
                    cbListener.onPaymentSuccess(args[0] + "", null);
            } else if (method.getName().equalsIgnoreCase(CBConstant.PAYMENT_OPTION_FAILURE)) {
                L.v("PayU", "Failure cb Upiwrapper " + args[0]);
                if (customBrowserConfig != null)
                    analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.FAILURE_TRANSACTION, null, cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.KEY), cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.TXNID), null));
                L.v("PayU","Class Name: "+getClass().getCanonicalName()+"CbListener "+cbListener);
                if (cbListener != null)
                    cbListener.onPaymentFailure(args[0] + "", null);

            } else if (method.getName().equalsIgnoreCase(CBConstant.ON_UPI_ERROR_RECEIVED)) {
                L.v("PayU", "Failure cb Upiwrapper " + args[0]);
                if (customBrowserConfig != null)
                    analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.FAILURE_TRANSACTION, null, cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.KEY), cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.TXNID), null));
                L.v("PayU","Class Name: "+getClass().getCanonicalName()+"CbListener "+cbListener);
                if (cbListener != null)
                    cbListener.onCBErrorReceived((Integer) args[0], ""+args[1]);

            } else if (method.getName().equalsIgnoreCase(CBConstant.PAYMENT_OPTION_INIT_SUCCESS)) {
                L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"Payment Option cbInit Success");
                CustomBrowserResultData resultData = new CustomBrowserResultData();
                resultData.setPaymentOption(PaymentOption.PHONEPE);
                L.v("PayU", "Class Name: "+getClass().getCanonicalName()+ "paymentoptioninitsuccess  type>> "+resultData.getPaymentOption());
                resultData.setPaymentOptionAvailable(true);
                if (cbListener != null)
                    cbListener.isPaymentOptionAvailable(resultData);

            } else if (method.getName().equalsIgnoreCase(CBConstant.IS_PAYMENT_OPTION_AVAILABLE)) {
                L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"Payment Option isPaymentOptionAvailable cb");
                CustomBrowserResultData resultData = new CustomBrowserResultData();
                L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"paymentoption available cb type>> "+args[1] +(Boolean) args[0]);
                if (args[1].toString().equals("PPINTENT")) {
                    resultData.setPaymentOption(PaymentOption.PHONEPE);
                }
                else if (args[1].toString().equals("SAMPAY")){
                    resultData.setPaymentOption(PaymentOption.SAMSUNGPAY);
                }
                else if (args[1].toString().equals("Tez")){
                    resultData.setPaymentOption(PaymentOption.TEZ);
                }
                resultData.setPaymentOptionAvailable((Boolean) args[0]);
                CustomBrowserData.SINGLETON.setPaymentOption(resultData.getPaymentOption());
                resultData.setErrorMessage(args[1] + "");
                if (cbListener != null)
                    cbListener.isPaymentOptionAvailable(resultData);
            }
            if (method.getName().equalsIgnoreCase(CBConstant.ON_PAYMENT_FAILURE)) {
                L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"onPayment Failure UpiWrapper Cb " + args[0]);
                if (customBrowserConfig != null)
                    analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.FAILURE_TRANSACTION, null, cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.KEY), cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.TXNID), null));
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentFailure(args[0] + "", null);
            }
            if (method.getName().equalsIgnoreCase(CBConstant.ON_PAYMENT_SUCCESS)) {
                L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"onPayment Success UpiWrapper Cb " + args[0]);
                if (customBrowserConfig != null)
                    analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.SUCCESS_TRANSACTION, null, cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.KEY), cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.TXNID), null));
                cbListener.onPaymentSuccess(args[0] + "", null);
            } else if (method.getName().equalsIgnoreCase(CBConstant.ON_PAYMENT_TERMINATED)) {
                L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"onPaymentTerminate UpiWrapper Cb ");
                cbListener.onPaymentTerminate();
                if (customBrowserConfig != null)
                    analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.FAILURE_TRANSACTION, null, cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.KEY), cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.TXNID), null));
                // cbListener.onPaymentFailure(args[0] + "", null);
            } else if (method.getName().equalsIgnoreCase(CBConstant.PAYMENT_OPTION_INIT_SUCCESS)) {
                L.v("PayU","Class Name: "+getClass().getCanonicalName()+"PAYMENT_OPTION_INIT_SUCCESS");
                CustomBrowserResultData resultData = new CustomBrowserResultData();
                resultData.setPaymentOption(PaymentOption.PHONEPE);
                resultData.setPaymentOptionAvailable(true);
                cbListener.isPaymentOptionAvailable(resultData);
                CustomBrowserData.SINGLETON.setPaymentOption(PaymentOption.PHONEPE);
            } else if (method.getName().equalsIgnoreCase(CBConstant.PAYMENT_OPTION_INIT_FAILURE)) {
                L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"PAYMENT_OPTION_INIT_FAILURE type>> "+args[1]);
                CustomBrowserResultData resultData = new CustomBrowserResultData();

                if (args[1]!=null) {
                    String description = (String) args[1];
                    L.v("PayU","Check description "+description.toLowerCase());
                    String s = description.toLowerCase();
                    if (s.contains("tez")) {
                        resultData.setPaymentOption(PaymentOption.TEZ);

                    } else if (s.contains("ppintent")) {
                        resultData.setPaymentOption(PaymentOption.PHONEPE);

                    } else if (s.contains("sampay")) {
                        resultData.setPaymentOption(PaymentOption.SAMSUNGPAY);

                    }
                }

                CustomBrowserData.SINGLETON.removePaymentOption(resultData.getPaymentOption());
                resultData.setPaymentOptionAvailable(false);
                resultData.setErrorMessage(args[1] + "");
                cbListener.isPaymentOptionAvailable(resultData);
            } else if (method.getName().equalsIgnoreCase(CBConstant.ON_VPA_ENTERED)) {
                L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"Check Validilty upiwrapper cb");
                packageListDialogFragment = new PackageListDialogFragment();
                cbListener.onVpaEntered(args[0] + "",packageListDialogFragment);
                // CustomBrowserData.SINGLETON.setiPackageListDialogFragment(iPackageListDialogFragment);
            }
            return null;
        }
    };


    private void initUpi() {
        try {
            upiWrapperClassLoader = UpiWrapper.class.getClassLoader();
            upiWrapperClass = upiWrapperClassLoader.loadClass("com.payu.upisdk.UpiWrapper");
            upiWrapperConstructor = upiWrapperClass.getDeclaredConstructor(java.lang.reflect.InvocationHandler.class);
            upiWrapperConstructor.setAccessible(true);
            upiWrapperObject = upiWrapperConstructor.newInstance(cbCallback);
            L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"UpiWrapper Initiated");
        } catch (Exception e) {
            L.v("PayU", "Class Name: "+getClass().getCanonicalName()+"Exception " + e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * Function to call checkForPaymentAvailability in UPI SDK
     * @param context
     * @param paymentOptionHash
     * @param merchantKey
     * @param user_credentials
     * @param paymentType
     */
    @Override
    public void checkForPaymentOptionAvailability(Context context, String paymentOptionHash, String merchantKey, String user_credentials, String paymentType) {
        L.v("PayU","paymentType "+paymentType);
        if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null)
            this.cbListener = CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback();
        try {
            initUpi();
            Method method = upiWrapperObject.getClass().getMethod("checkForPaymentAvailability", Context.class, String.class, String.class, String.class, String.class);
            method.invoke(upiWrapperObject, context, paymentOptionHash, user_credentials, paymentType, merchantKey );
        } catch (Exception e) {
            L.v("PayU","Class Name: "+getClass().getCanonicalName() +" Exception catch "+e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void makePayment(Activity activity, CustomBrowserConfig customBrowserConfig) {
        try {
            L.v("PayU","Class Name: "+getClass().getCanonicalName()+"Make Payment params "+customBrowserConfig.getPayuPostData() +" - -- -  "+customBrowserConfig.getIsPhonePeUserCacheEnabled()+" - --  "+customBrowserConfig.getPaymentType());
            if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null)
                this.cbListener = CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback();
            if (null == upiWrapperObject)
                initUpi();

            this.activity = activity;
            this.cbUtil = new CBUtil();
            this.customBrowserConfig = customBrowserConfig;
            this.analytics = PayUAnalytics.getInstance(activity.getApplicationContext(), "local_cache_analytics");

            method = upiWrapperObject.getClass().getMethod("makePayment", Activity.class, String.class, Boolean.class, String.class, Integer.class,Integer.class, View.class, String.class);
            method.invoke(upiWrapperObject, activity, customBrowserConfig.getPayuPostData(), customBrowserConfig.getIsPhonePeUserCacheEnabled() == CustomBrowserConfig.TRUE,
                    customBrowserConfig.getPaymentType(), customBrowserConfig.getMerchantResponseTimeout(),customBrowserConfig.getGmsProviderUpdatedStatus(),customBrowserConfig.getProgressDialogCustomView(),
                    customBrowserConfig.getPostURL());

        } catch (Exception e) {
            L.v("PayU","Class Name: "+getClass().getCanonicalName()+"Exception make payment "+e.getMessage());
            L.v("PayU","Class Name: "+getClass().getCanonicalName()+"Cause make payment "+e.getCause());
            e.printStackTrace();
        }
    }

    /**
     * Utility method to call verifyVpa of UPI SDK in case of Generic Intent UPI Collect
     * @param verifyVpaHash
     */
    public void verifyVpa(String verifyVpaHash){
        try {
            L.v("PayU","Class Name: "+getClass().getCanonicalName()+"verifyVpa called with Hash"+verifyVpaHash);
            if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null)
                this.cbListener = CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback();
            if (null == upiWrapperObject)
                initUpi();

            method = upiWrapperObject.getClass().getMethod("verifyVpa",String.class);
            method.invoke(upiWrapperObject,verifyVpaHash);

        } catch (Exception e) {
            L.v("PayU","Class Name: "+getClass().getCanonicalName()+"Exception make payment "+e.getMessage());
            L.v("PayU","Class Name: "+getClass().getCanonicalName()+"Cause make payment "+e.getCause());
            e.printStackTrace();
        }
    }
}
