package com.payu.custombrowser.util;

import android.content.Context;
import android.content.SharedPreferences;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by shoaib on 10/13/15.
 */
public class SharedPreferenceUtil {

    public static void addStringToSharedPreference(Context context, String spFileName, String spKey, String spValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(spKey, spValue);
        editor.commit();
    }

    public static void addIntToSharedPreference(Context context, String spFileName, String spKey, int spValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(spKey, spValue);
        editor.commit();
    }

    public static void addBooleanToSharedPreference(Context context, String spFileName, String spKey, boolean spValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(spKey, spValue);
        editor.commit();
    }

    public static String getStringFromSharedPreference(Context context, String spFileName, String spKey, String defaultValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, Context.MODE_PRIVATE);
        return sharedPref.getString(spKey, defaultValue);
    }

    public static int getIntFromSharedPreference(Context context, String spFileName, String spKey, int defaultValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, Context.MODE_PRIVATE);
        return sharedPref.getInt(spKey, defaultValue);
    }

    public static boolean getBooleanFromSharedPreference(Context context, String spFileName, String spKey, boolean defaultValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, Context.MODE_PRIVATE);
        return sharedPref.getBoolean(spKey, defaultValue);
    }

    /**
     * Simple helper method read a preference and return all the values as hashmap<String, Object> format.
     *
     * @param context  context
     * @param prefName name of the perference file.
     * @return hashmap.
     */
    public static Map<String, ?> getSharedPrefMap(Context context, String prefName) {
        HashMap<String, Object> sharedPrefHashMap = new HashMap<>();
        SharedPreferences snoozeSharedPref = context.getSharedPreferences(prefName, Context.MODE_PRIVATE);
        Map<String, ?> allEntries = snoozeSharedPref.getAll();

        return allEntries;
    }

    /**
     * Simple helper method to remove all the keys from given shared pref file.
     *
     * @param context
     * @param prefName
     */
    public static void removeAllFromSharedPref(Context context, String prefName) {
        SharedPreferences settings = context.getSharedPreferences(prefName, Context.MODE_PRIVATE);
        settings.edit().clear().commit();
    }
}
