package com.payu.custombrowser.util;

import android.util.Log;


/**
 * Custom log class which can control logging based on the logging level set
 *
 * @author Shoaib
 */
public class L {

    public static final int VERBOSE = 2;

    public static final int INFO = 3;

    public static final int DEBUG = 4;

    public static final int WARN = 5;

    public static final int ERROR = 6;

    public static final int NONE = 7;

    private static final String DEFAULT_LOG_TAG = "### PAYU ####";
    private static final String DEFAULT_TIMESTAMP_TAG = "PAYU-TIMESTAMP";

    /**
     * Set the desired log level here - based on one of the above values
     * VERBOSE for all logs, NONE to hide all logs
     */
    public static int sLogLevel = /*VERBOSE;*/ VERBOSE;

    public static synchronized void t(String message) {

        if (sLogLevel <= VERBOSE) {
            Log.v(DEFAULT_TIMESTAMP_TAG, message);
        }

    }

    public static synchronized void v(String tag, String message) {
        if (sLogLevel <= VERBOSE) {
            Log.v(tag, message);
        }
    }

    public static synchronized void v(String message) {
        if (sLogLevel <= VERBOSE) {
            Log.v(DEFAULT_LOG_TAG, message);
        }

    }

    public static synchronized void v(int message) {
        if (sLogLevel <= VERBOSE) {
            v(DEFAULT_LOG_TAG, message + "");
        }
    }

    public static synchronized void v(String tag, int message) {
        if (sLogLevel <= VERBOSE) {
            v(tag, message + "");
        }
    }

    public static synchronized void d(String tag, String message) {
        if (sLogLevel <= DEBUG) {
            Log.d(tag, message);
        }
    }

    public static synchronized void w(String tag, String message) {
        if (sLogLevel <= WARN) {
            Log.w(tag, message);
        }
    }

    public static synchronized void i(String tag, String message) {
        if (sLogLevel <= INFO) {
            Log.i(tag, message);
        }
    }

    public static synchronized void e(String tag, String message) {
        if (sLogLevel <= ERROR) {
            Log.e(tag, message);
        }
    }

}
