// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser.util;

/**
 * Created by minie on 30/6/15.
 * Constants for analytics.
 */

public class CBAnalyticsConstant {

    //Event keys for CBAnalytics
    public static final String PAYMENT_INITIATED = "payment_initiated";
    public static final String CUSTOM_BROWSER = "CUSTOM_BROWSER";
    public static final String NON_CUSTOM_BROWSER = "NON_CUSTOM_BROWSER";
    public static final String PASSWORD = "password_click";
    public static final String OTP = "otp_click";
    public static final String RECEIVED_OTP_DIRECT = "received_otp_direct";
    public static final String RECEIVED_OTP_SELECTED = "received_otp_selected";
    public static final String RECEIVED_OTP_REGENERATE = "received_otp_regenerate";
    public static final String OTP_WEB = "otp_web";

    public static final String REGENERATE = "regenerate_click";
    public static final String ENTER_MANUALLY = "enter_manually_click";
    public static final String ENTER_MANUALLY_ONTIMER_CLICK = "enter_manually_ontimer_click";
    public static final String APPROVED_OTP = "approved_otp";
    public static final String SUCCESS_TRANSACTION = "success_transaction";
    public static final String FAILURE_TRANSACTION = "failure_transaction";
    public static final String TERMINATE_TRANSACTION = "terminate_transaction";

    //Keys for Device Tracking for transaction
    public static final String SDK_VERSION_NAME = "sdk_version_name";
    public static final String CB_VERSION_NAME = "cb_version_name";
    public static final String DEVICE_OS_VERSION = "device_os_version";
    public static final String NETWORK_INFO = "network_info";
    public static final String NETWORK_STRENGTH = "network_strength";
    public static final String DEVICE_RESOLUTION = "device_resolution";
    public static final String DEVICE_MANUFACTURE = "device_manufacturer";
    public static final String DEVICE_MODEL = "device_model";
    public static final String MERCHANT_KEY = "merchant_key";
    public static final String ANALYTICS_KEY = "merchantid";
    public static final String TRANSACTION_ID = "txnid";
    public static final String REACT_VERSION_NAME = "react_version_name";

    //Event Analyitcs
    public static final String BANK_NAME = "bank";
    public static final String PAKAGE_NAME = "package_name";
    public static final String KEY = "event_key";
    public static final String VALUE = "event_value";
    public static final String PAGE_TYPE = "page_type";
    public static final String PAYU_ID = "payu_id";
    public static final String TIMESTAMP = "ts";
    public static final String VERSION_CODE = "application_version";

    //Key for Event CBAnalytics
    public static final String USER_INPUT = "user_input";
    public static final String LAST_URL = "last_url";
    public static final String CB_STATUS = "cb_status";
    public static final String OTP_RECIEVED = "otp_received";
    public static final String TRNX_STATUS = "trxn_status";
    public static final String MERCHANT_BACK_BUTTON_CLICK = "m_back_button";
    public static final String PAYU_BACK_BUTTON_CLICK = "payu_back_button";
    public static final String BACK_BUTTON_OK_CLICK = "back_button_ok";
    public static final String BACK_BUTTON_CANCEL_CLICK = "back_button_cancel";
    public static final String CHOOSE_SCREEN = "Choose Screen"; // bank page
    public static final String PIN_PAGE = "PIN Page"; // pin page(enterPin)
    public static final String OTP_PAGE = "OTP Page"; // otp page (enter_otp)
    public static final String REGISTER_PAGE = "Register Page"; // Register page (Register)
    public static final String NBLOGIN_PAGE = "NBLogin Page"; //Net Banking Page (Peek password View page)
    public static final String APPROVE_BTN_CLICK_TIME = "Approve_btn_clicked_time"; // approve button click

    public static final String PAYU_PREFERENCE = "PayuPreference";
    public static final String DEFAULT = "default";
    public static final String CARD_TOKEN = "card_token";
    public static final String MERCHANT_HASH = "merchant_hash";
    public static final String CB_AUTO_APPROVE = "auto_approve";
    public static final String CB_AUTO_OTP_SELECT = "auto_otp_select";
    public static final String CB_LOAD_HTML = "load_html";

    public static final int STORE_ONE_CLICK_HASH_MOBILE = 2;
    public static final int STORE_ONE_CLICK_HASH_NONE = 0;
    public static final int STORE_ONE_CLICK_HASH_SERVER = 1;


    // SNOOZE CONSTANTS.
/*
    snooze_window_status           visible
    snooze_window_status           not_visible
    snooze_notification_status      notification_launched
    snooze_notification_status      notification_clicked (if sender is snooze service then we fire notification clicked event.)
    snooze_notification_status      better_network_identified (Tells, are we able to identify good network with in time out)
    snooze_notification_status      cb_notification_prepared (Notification can be prepared for Merchant checkout page or CB)
    snooze_notification_status      merchant_checkout_notification_prepared (Notification can be prepared for Merchant checkout page or CB, need to figure out a way to do this, webview is dead here.)
    snooze_enable_count              number which identifies the maximum number of times snooze window should appear, since this value is set by merchant better to have it in analytics.
    snooze_count                           number of times snooze window appeared for a transaction
    snooze_appear_url                   url when snooze window appear
    snooze_load_url                        url when snooze button clicked
    snooze_user_input                    snooze_click
    snooze_user_input                    snooze_retry_click
    snooze_user_input                    snooze_cancel_transaction_click
    snooze_user_input                    snooze_cancel_window_click

1. Custom browser killing snooze window.
2. snooze_resume_url
3. snooze_window_killed_by_CB
4. time taken to fire notification once snooze clicked
5. time difference between snooze dialog appearance and snooze/retry/cancel clicking.
6. retry_now_resume_url.

    */

    // Keys set

    public static String SNOOZE_BACKWARD_WINDOW_ACTION ="snooze_backward_window_action";
    public static String SNOOZE_BACKWARD_WINDOW_SMS_RECEIVED ="snooze_backward_window_sms_received";

    public static final String SNOOZE_WINDOW_STATUS = "snooze_window_status";
    public static final String SNOOZE_NOTIFICATION_STATUS = "snooze_notification_status";
    public static final String SNOOZE_ENABLE_COUNT = "snooze_enable_count";
    public static final String SNOOZE_COUNT = "snooze_count";
    public static final String SNOOZE_APPEAR_URL = "snooze_appear_url";
    public static final String SNOOZE_LOAD_URL = "snooze_load_url";
    public static final String SNOOZE_RESUME_URL = "snooze_resume_url";
    public static final String SNOOZE_RETRY_NOW_URL = "snooze_retry_now_url";
    public static final String SNOOZE_WINDOW_ACTION = "snooze_window_action";
    public static final String SNOOZE_NOTIFICATION_PREPARE_TIME = "snooze_notification_prepare_time";
    public static final String SNOOZE_INTERACTION_TIME = "snooze_interaction_time";
    public static final String SNOOZE_VERIFY_API_STATUS = "snooze_verify_api_status";
    public static final String SNOOZE_WINDOW_LAUNCH_MODE = "snooze_window_launch_mode";
    public static final String SNOOZE_APPEAR_TIME = "snooze_window_appear_time";
    public static final String SNOOZE_WINDOW_AUTOMATICALLY_DISAPPEAR_TIME = "snooze_window_automatically_disappear_time";
    public static final String SNOOZE_BACKWARD_VISIBLE = "snooze_backward_visible";

    public static final String SNOOZE_NOTIFICATION_TYPE = "snooze_notification_type";


    public static final String SNOOZE_NOTIFICATION_EXPECTED_ACTION = "snooze_notification_expected_action";

    // TODO - Remove this key from analytics after confirming with product.
    public static final String SNOOZE_NOTIFICATION_ACTION = "snooze_notification_action";

    // TODO - Remove this key from analytics after confirming with product.
    public static final String SNOOZE_NOTIFICATION_TIME = "snooze_notification_time";

    public static final String ARRIVAL = "arrival";
    public static final String DEPARTURE = "departure";
    public static final String SNOOZE_VERIFY_API_RESPONSE_RECEIVED = "snooze_verify_api_response_received";
    public static final String SURE_PAY_CANCELLED = "sure_pay_cancelled";
    public static final String SNOOZE_TRANSACTION_STATUS_UPDATE = "snooze_transaction_status_update";

  //  public static final String SNOOZE_TXN_PAUSED_WINDOW_APPEAR_TIME = "snooze_txn_paused_window_appear_time";
    public static final String SNOOZE_TXN_PAUSED_USER_INTERACTION_TIME = "snooze_txn_paused_user_interaction_time";
    public static final String SNOOZE_TXN_PAUSED_WINDOW_ACTION = "snooze_txn_paused_window_action";

    public static final String SNOOZE_MODE_SET_MERCHANT = "snooze_mode_set_merchant";

    public static final String INTERNET_RESTORED_NOTIFICATION = "internet_restored_notification";
    public static final String INTERNET_NOT_RESTORED_NOTIFICATION = "internet_not_restored_notification";
    public static final String INTERNET_RESTORED_DIALOG_FOREGROUND = "internet_restored_dialog_foreground";
    public static final String INTERNET_NOT_RESTORED_DIALOG_FOREGROUND = "internet_not_restored_dialog_foreground";
    public static final String INTERNET_RESTORED_DIALOG_RECENT_APP = "internet_restored_dialog_recent_app";
    public static final String INTERNET_NOT_RESTORED_DIALOG_RECENT_APP = "internet_not_restored_dialog_recent_app";
    public static final String INTERNET_RESTORED_NOTIFICATION_CLICK = "internet_restored_notification_click";
    public static final String TRANSACTION_VERIFIED_NOTIFICATION = "transaction_verified_notification";
    public static final String TRANSACTION_NOT_VERIFIED_NOTIFICATION = "transaction_not_verified_notification";
    public static final String TRANSACTION_VERIFIED_DIALOG_FOREGROUND = "transaction_verified_dialog_foreground";
    public static final String TRANSACTION_NOT_VERIFIED_DIALOG_FOREGROUND = "transaction_not_verified_dialog_foreground";
    public static final String TRANSACTION_VERIFIED_DIALOG_RECENT_APP = "transaction_verified_dialog_recent_app";
    public static final String TRANSACTION_NOT_VERIFIED_DIALOG_RECENT_APP = "transaction_not_verified_dialog_recent_app";
    public static final String TRANSACTION_VERIFIED_NOTIFICATION_CLICK = "transaction_verified_notification_click";
    public static final String TRANSACTION_NOT_VERIFIED_NOTIFICATION_CLICK = "transaction_not_verified_notification_click";





    // Values set
    public static final String SNOOZE_VISIBLE = "snooze_visible";
    public static final String SNOOZE_NOT_VISIBLE = "snooze_not_visible";
    public static final String SNOOZE_WINDOW_DISMISSED_BY_CB = "snooze_window_dismissed_by_cb";
    public static final String SNOOZE_CLICK = "snooze_click";
    public static final String SNOOZE_RETRY_CLICK = "snooze_retry_click";
    public static final String SNOOZE_CANCEL_TRANSACTION_CLICK = "snooze_cancel_transaction_click";
    public static final String SNOOZE_CANCEL_WINDOW_CLICK = "snooze_cancel_window_click";

    public static final String SNOOZE_WITH_CONFIRM_DEDUCTION_VISIBLE = "snooze_with_confirm_deduction_visible";
    public static final String SNOOZE_CONFIRM_DEDUCTION_Y = "confirm_deduction_y";
    public static final String SNOOZE_CONFIRM_DEDUCTION_N = "confirm_deduction_n";
    public static final String CONFIRM_DEDUCTION_MESSAGE_Y = "confirm_deduction_message_y";

    public static final String SNOOZE_VERIFY_API_CALLED = "snooze_verify_api_called";
  //  public static final String SNOOZE_TRANSACTION_STATUS_NOTIFICATION = "snooze_tranx_status_notification_visible";
    public static final String INTERNET_RESTORED = "internet_restored";
    public static final String TRANSACTION_VERIFIED = "transaction_verified";
    public static final String TRANSACTION_STATUS_UNKNOWN = "transaction_status_unknown";
    public static final String NO_INTERNET_FOUND = "no_internet_found";
    public static final String SNOOZE_TRANSACTION_RESUMED = "snooze_transaction_resumed";
    public static final String TXN_NOT_CONFIRMED = "txn_not_confirmed";
    public static final String SUCCESS_SCREEN = "success_screen";
    public static final String MERCHANT_CHECKOUT_PAGE = "merchant_checkout_page";
    public static final String SMS_RETRIEVER = "sms_retriever";


    public static String NB_CUSTOM_BROWSER = "NB_CUSTOM_BROWSER";
    public static String NB_BUTTON_CLICK = "button_click_";
    public static String USER_NAME_CHECKBOX_STATUS = "nb_remember_login_";

    public static String INITIAL_USER_NAME_CHECKBOX_STATUS = "nb_checkbox_init_state";

    public static final String SNOOZE_RELOAD="data_repost";
    public static final String SNOOZE_POST_SURL="post_to_surl";

    public static final String BROAD_CAST_FROM_SNOOZE_SERVICE = "BROAD_CAST_FROM_SNOOZE_SERVICE";
    public static String RECEIVED ="received";

    public static final String RETRY_ANYWAY_CLICK = "retry_anyway_click";

    // if a cb event just loges current time stamp as value, use "DEFAULT_ANALYTICS_EVENT_VALUE" constant,
    // Since all analytics events will automatically adds current timestamp at the time of logging.
    public static final String DEFAULT_ANALYTICS_EVENT_VALUE = "-1";

    public static final String SSL_ERROR = "SSL_ERROR";
    public static final String ERROR_RECEIVED = "ERROR_RECEIVED";

    public static final String KEY_REVIEW_ORDER_TYPE =  "review_order_type";
    public static final String VAL_RO_CUSTOM_BROWSER =  "review_order_custom_browser";
    public static final String VAL_REVIEW_ORDER_CLICK =  "review_order_btn_click";
    public static final String VAL_REVIEW_ORDER_CLOSE_CLICK =  "review_order_close_click";
    public static final String VAL_REVIEW_ORDER_DEFAULT =  "review_order_default";
    public static final String VAL_REVIEW_ORDER_CUSTOM =  "review_order_custom";

    // CatchAll JS Events
    public static final String KEY_BANK_PAGE_OTP_FIELDS =  "bank_page_otp_fields";
    public static final String KEY_BANK_PAGE_HOST_NAME =  "bank_page_host_name";

    //Chrome Custom tabs Events Keys
    public static final String CUSTOM_TABS =  "custom_tabs";
    public static final String SAMSUNG_PAY =  "samsung_pay";
    public static final String CUSTOM_TABS_LAUNCHED =  "custom_tabs_launched";
    public static final String CUSTOM_TABS_LAUNCH_FAILED =  "custom_tabs_launch_failed";
    public static final String CUSTOM_TABS_LOAD_HTML =  "custom_tabs_load_html";
    public static final String CUSTOM_TABS_CANCELLED =  "custom_tabs_cancelled";
    public static final String SUCCESS_TRANSACTION_CUSTOM_TABS = "success_transaction_custom_tabs";
    public static final String FAILURE_TRANSACTION_CUSTOM_TABS = "failure_transaction_custom_tabs";
    public static final String SAMSUNG_PAY_LAUNCHED =  "samsung_pay_launched";
    public static final String SAMSUNG_PAY_LAUNCH_FAILED =  "samsung_pay_launch_failed";
    public static final String OS_NOT_SUPPORTED =  "os_not_supported";
    public static final String LAUNCHED = "_launched";
    public static final String LAUNCH_FAILED = "_launch_failed";
    //Generic Intent Analytics
    public static final String PAYMENT_APP="_payment_app";
    public static final String NO_UPI_APPS_PRESENT="no_upi_apps_present";
    //Custom View Analytics
    public static final String CB_LOADER_TYPE_KEY = "cb_loader_type";
    public static final String CB_LOADER_TYPE_CUSTOM = "custom";

}