package com.payu.custombrowser.util;

import android.text.TextUtils;

import java.util.HashMap;

/**
 * Created by franklin.michael on 20/06/16.
 */

public class SnoozeConfigMap extends HashMap {
    @Override
    public Object get(Object key) {
        return super.get(key);
    }


    public int[] getPercentageAndTimeout(String url) {
        // Array which holds the sure pay config
        // [0] - sure pay load percentage
        // [1] - sure pay time out
        // [2] - sure pay disable mode {CBConstant.DISABLE_WARN, DISABLE_FAIL}
        String[] surePayConfig;

        if (null == get(url)) {
            url = CBConstant.DEFAULT_PAYMENT_URLS;
        }
        // split needs pipes to be escaped.

        surePayConfig = get(url) == null ? new String[]{} : get(url).toString().split("\\|\\|");


        return new int[]{
                surePayConfig.length > 0 && surePayConfig[0].length() > 0 && TextUtils.isDigitsOnly(surePayConfig[0]) ? Integer.parseInt(surePayConfig[0]) : CBConstant.SNOOZE_DEFAULT_URL_LOAD_PERCENTAGE,
                surePayConfig.length > 1 && surePayConfig[1].length() > 0 && TextUtils.isDigitsOnly(surePayConfig[1]) ? Integer.parseInt(surePayConfig[1]) : CBConstant.SNOOZE_DEFAULT_URL_LOAD_TIME_OUT,
                surePayConfig.length > 2 && surePayConfig[2].length() > 0 && TextUtils.isDigitsOnly(surePayConfig[2]) ? Integer.parseInt(surePayConfig[2]) : CBConstant.DISABLE_WARN_MODE // By default enable sure pay for both modes.
        };

    }
}
