package com.payu.custombrowser.upiintent;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.View;

import com.payu.custombrowser.PayUCustomBrowserCallback;
import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.cbinterface.GenericUPICallbacks;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.widgets.PayUProgressDialog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import static com.payu.custombrowser.upiintent.UPIPaymentConstants.AMOUNT;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.APPS;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.COMBINE_VERIFY_AND_PAY_BUTTON;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.DISABLE_INTENT_SEAMLESS_FAILURE;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.MERCHANT_NAME;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.MERCHANT_VPA;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.REFERENCE_ID;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.RETURN_URL;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.TOKEN;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.TXNID;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.VPA_REGEX;

/**
 * Created by himanshu.gupta on 17/01/18.
 */
class PaymentHandler {
    private WeakReference<Activity> mActivity;
    private String postData;
    private String verifyPostData;
    private PayUCustomBrowserCallback payUCustomBrowserCallback;
    private PayUProgressDialog progressDialog;
    private String paymentUrl;
    private String verifyPaymentUrl;
    private String merchantVpa;
    private String merchantName;
    private String referenceId;
    private UPIUtil upiUtil;
    private Payment payment;
    private Timer transactionTimeout;
    private GenericUPICallbacks callbacks;
    private long TRANSACTION_TIMEOUT = 20 * 60 * 1000;//20 Minutes
    private String amount;
    private boolean isGenericPayment;
    private String txnId;
    private String combineVerifyAndPayButton;
    private String disableIntentSeamlessFailure;
    private String token;
    private String vpaRegex;
    private List<PackageBean> apps;
    private CBAnalytics analytics;
    private View progressDialogCustomView;

    PaymentHandler(Activity mActivity, String postData,String paymentUrl,PayUCustomBrowserCallback payUCustomBrowserCallback,View progressDialogCustomView) {
        this.mActivity = new WeakReference<Activity>(mActivity);
        this.postData = postData;
        this.upiUtil = new UPIUtil();
        this.callbacks = (GenericUPICallbacks) mActivity;
        this.payUCustomBrowserCallback = payUCustomBrowserCallback;
        this.payment = upiUtil.getSupportedPayment(postData);
        this.isGenericPayment = this.payment==Payment.GENERIC_INTENT;
        this.progressDialogCustomView = progressDialogCustomView;
        this.paymentUrl = paymentUrl;
        this.analytics = CBAnalytics.getInstance(mActivity.getApplicationContext(),"local_cache_analytics");
    }

    void initiatePayment() {
        AsyncTask asyncTask = new AsyncTask<String, Void, PaymentResponse>() {

            @Override
            protected void onPreExecute() {
                super.onPreExecute();
                if (mActivity.get() != null && !mActivity.get().isFinishing()) {
                    if(null==progressDialog)
                        progressDialog = new PayUProgressDialog(mActivity.get(),progressDialogCustomView);
                    progressDialog.setCancelable(false);
                    if(null==progressDialogCustomView)
                        progressDialog.setPayUDialogSettings(mActivity.get());
                    progressDialog.show();
                }
            }

            @Override
            protected PaymentResponse doInBackground(String... params) {
                try {
                    CBUtil cbUtil = new CBUtil();
                    postData = postData.concat("&" + UPIPaymentConstants.TXN_S2S_FLOW + "=2");
                    HttpURLConnection conn = cbUtil.getHttpsConn(paymentUrl, postData);
                    if (conn != null) {
                        int responseCode = conn.getResponseCode();
                        if (responseCode == HttpURLConnection.HTTP_OK) {
                            try {
                                InputStream responseInputStream = conn.getInputStream();
                                StringBuffer responseStringBuffer = cbUtil.getStringBufferFromInputStream(responseInputStream);
                                if (responseStringBuffer != null) {
                                    JSONObject jsonObject = new JSONObject(responseStringBuffer.toString());
                                    merchantName = jsonObject.optString(MERCHANT_NAME);
                                    verifyPaymentUrl = jsonObject.optString(RETURN_URL);
                                    merchantVpa = jsonObject.optString(MERCHANT_VPA);
                                    referenceId = jsonObject.optString(REFERENCE_ID);
                                    amount = jsonObject.optString(AMOUNT);
                                    txnId = jsonObject.optString(TXNID);
                                    token = jsonObject.optString(TOKEN);
                                    disableIntentSeamlessFailure = jsonObject.optString(DISABLE_INTENT_SEAMLESS_FAILURE);
                                    combineVerifyAndPayButton = jsonObject.optString(COMBINE_VERIFY_AND_PAY_BUTTON);
                                    apps = parseAppResponse(jsonObject.optJSONArray(APPS));
                                    vpaRegex = jsonObject.optString(VPA_REGEX);
                                    if (TextUtils.isEmpty(merchantName) || TextUtils.isEmpty(verifyPaymentUrl) || TextUtils.isEmpty(merchantVpa) || TextUtils.isEmpty(referenceId))
                                        return null;
                                    PaymentResponse paymentResponse = new PaymentResponse();
                                    paymentResponse.setMerchantName(merchantName);
                                    paymentResponse.setMerchantVpa(merchantVpa);
                                    paymentResponse.setReferenceId(referenceId);
                                    paymentResponse.setReturnUrl(verifyPaymentUrl);
                                    paymentResponse.setAmount(amount);
                                    paymentResponse.setToken(token);
                                    paymentResponse.setReturnUrl(verifyPaymentUrl);
                                    if(!(TextUtils.isEmpty(combineVerifyAndPayButton) || combineVerifyAndPayButton.equalsIgnoreCase("null")))
                                        paymentResponse.setCombineVerifyAndPayButton(combineVerifyAndPayButton);
                                    paymentResponse.setDisableIntentSeamlessFailure(disableIntentSeamlessFailure);
                                    paymentResponse.setTxnId(txnId);
                                    paymentResponse.setApps(apps);
                                    paymentResponse.setVpaRegex(vpaRegex);
                                    return paymentResponse;
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }

            @Override
            protected void onPostExecute(PaymentResponse paymentResponse) {
                super.onPostExecute(paymentResponse);
                if (null != progressDialog && progressDialog.isShowing() && !mActivity.get().isFinishing())
                    progressDialog.dismiss();
                if (null!=paymentResponse) {
                     callbacks.onResponse(paymentResponse);
                } else {
                    payUCustomBrowserCallback.onCBErrorReceived(UPIPaymentConstants.MERCHANT_INFO_NOT_PRESENT_CODE, UPIPaymentConstants.MERCHANT_INFO_NOT_PRESENT);
                    mActivity.get().finish();
                }
            }
        };
        asyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{""});
    }

    /**
     * Start Payment with selected package
     * @param packageName Selected Package Id
     */
    void makePayment(String packageName) {
        Intent i = new Intent();
        i.setPackage(packageName);
        i.setAction(Intent.ACTION_VIEW);
        String txnAmount = TextUtils.isEmpty(amount)?upiUtil.getValuePostData(postData, UPIPaymentConstants.AMOUNT):amount;
        i.setData(Uri.parse(upiUtil.getUPIIntent(merchantVpa, merchantName, txnAmount,
                upiUtil.getValuePostData(postData, UPIPaymentConstants.TXNID), referenceId,UPIPaymentConstants.CURRENCY_INR)));
        mActivity.get().startActivityForResult(i, UPIPaymentConstants.PAYMENT_REQUEST_CODE);
        startTimer();
    }

    /**
     * Utility function to start transaction timer
     */
    private void startTimer() {
        if (transactionTimeout != null)
            new CBUtil().cancelTimer(transactionTimeout);
        transactionTimeout = new Timer();
        transactionTimeout.schedule(new TimerTask() {
            @Override
            public void run() {
                if (mActivity.get() != null && !mActivity.get().isFinishing()) {
                    mActivity.get().runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            verifyPayment(UPIPaymentConstants.FAILURE, "timeout");
                        }
                    });
                }
            }
        }, TRANSACTION_TIMEOUT);
    }

    /**
     * Verify Api handler function
     * @param transactionStatus Txn status
     * @param errorReason Error reason in case of Failure transaction(Optional)
     */
    void verifyPayment(final String transactionStatus, final String errorReason) {
        AsyncTask asyncTask = new AsyncTask<String, Void, String>() {

            @Override
            protected void onPreExecute() {
                super.onPreExecute();
                if (mActivity.get() != null && !mActivity.get().isFinishing()) {
                    if(null== progressDialog)
                        progressDialog = new PayUProgressDialog(mActivity.get(),progressDialogCustomView);
                    if(null==progressDialogCustomView)
                        progressDialog.setPayUDialogSettings(mActivity.get());
                    progressDialog.show();
                }
            }

            @Override
            protected String doInBackground(String... params) {
                try {
                    CBUtil cbUtil = new CBUtil();
                    if(!isGenericPayment) {
                        verifyPostData = UPIPaymentConstants.TRANSACTION_STATUS + "=" + transactionStatus + "&" + UPIPaymentConstants.FAILURE_REASON + "=" + errorReason;
                    } else {
                        String action = transactionStatus.equalsIgnoreCase(UPIPaymentConstants.CANCEL)? "cancelTxn":(transactionStatus.equalsIgnoreCase(UPIPaymentConstants.FAIL))?"failTxn":"finish";
                        verifyPostData = UPIPaymentConstants.TOKEN+"="+token+"&"+UPIPaymentConstants.ACTION +"="+action + "&"+UPIPaymentConstants.FAILURE_REASON+"="+errorReason;
                    }
                    HttpURLConnection conn = cbUtil.getHttpsConn(verifyPaymentUrl, verifyPostData);
                    if (conn != null) {
                        int responseCode = conn.getResponseCode();
                        if (responseCode == HttpURLConnection.HTTP_OK) {
                            try {
                                InputStream responseInputStream = conn.getInputStream();
                                StringBuffer responseStringBuffer = cbUtil.getStringBufferFromInputStream(responseInputStream);
                                if (responseStringBuffer != null) {
                                    String response = cbUtil.getBase64DecodedString(responseStringBuffer.toString());
                                    return response;
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();

                }
                return null;
            }

            @Override
            protected void onPostExecute(String result) {
                super.onPostExecute(result);
                if (null != progressDialog && progressDialog.isShowing() && !mActivity.get().isFinishing())
                    progressDialog.dismiss();
                if (!TextUtils.isEmpty(result)) {
                    String status = getTransactionStatus(result);
                    if (status.equalsIgnoreCase(UPIPaymentConstants.FAILURE)) {
                        analytics.log(CBUtil.getLogMessage(mActivity.get().getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.FAILURE_TRANSACTION, null,upiUtil.getValuePostData(postData,CBConstant.KEY) , upiUtil.getValuePostData(postData,UPIPaymentConstants.TXNID), null));
                        payUCustomBrowserCallback.onPaymentFailure(result, null);
                    } else {
                        analytics.log(CBUtil.getLogMessage(mActivity.get().getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.SUCCESS_TRANSACTION, null,upiUtil.getValuePostData(postData,CBConstant.KEY) , upiUtil.getValuePostData(postData,UPIPaymentConstants.TXNID), null));
                        payUCustomBrowserCallback.onPaymentSuccess(result, null);
                    }
                } else {
                    analytics.log(CBUtil.getLogMessage(mActivity.get().getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.FAILURE_TRANSACTION, null,upiUtil.getValuePostData(postData,CBConstant.KEY) , upiUtil.getValuePostData(postData,UPIPaymentConstants.TXNID), null));
                    payUCustomBrowserCallback.onPaymentFailure(null, null);
                }
                if (transactionTimeout != null)
                    new CBUtil().cancelTimer(transactionTimeout);
                mActivity.get().finish();

            }
        };
        asyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{""});
    }

    /**
     * Parses the api response to create list of Upi apps
     * @param appArray JSONArray of backend prioritised apps
     * @return List of PackageBean having backend prioritised apps along with installed apps
     */
    private List<PackageBean> parseAppResponse(JSONArray appArray){
        if(null!=appArray && appArray.length()>0) {
            List<PackageBean> result = new ArrayList<>();
            for (int i = 0; i < appArray.length(); i++) {
                try {
                    JSONObject jsonObject = appArray.getJSONObject(i);
                    PackageBean object = new PackageBean(jsonObject.optString(UPIPaymentConstants.NAME), null,
                            jsonObject.optString(UPIPaymentConstants.PACKAGE));
                    result.add(object);

                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }
            return result;
        }
        return null;
    }

    /**
     * Function to parse backend Verify api response
     * @param response Verify api response
     * @return {@link UPIPaymentConstants#FAILURE}or{@link UPIPaymentConstants#SUCCESS}
     */
    private String getTransactionStatus(String response){
        try {
            JSONObject jsonObject = new JSONObject(response);
            if(jsonObject.has(UPIPaymentConstants.RESULT)){
                JSONObject resultObject = jsonObject.getJSONObject(UPIPaymentConstants.RESULT);
                if(resultObject.has(UPIPaymentConstants.STATUS.toLowerCase()))
                    return resultObject.getString(UPIPaymentConstants.STATUS.toLowerCase());
            }
        }catch (JSONException e){
            e.printStackTrace();
            return UPIPaymentConstants.FAILURE;
        }
        return UPIPaymentConstants.FAILURE;
    }
}
