// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.support.annotation.NonNull;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;

import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.MagicRetryFragment;
import com.payu.magicretry.WebClient.MagicRetryWebViewClient;

/**
 * Created by minie on 1/7/15.
 * Custom payu web view client.
 */
public class PayUWebViewClient extends MagicRetryWebViewClient {

    private boolean loadingFinished = true;
    private boolean redirect = false;
    private String mainUrl = "";
    private Bank bank;


    /**
     * Customize payu web view contorller for merchants.
     *
     * @param bank name of the  bank
     */
    public PayUWebViewClient(@NonNull Bank bank, @NonNull String merchantKey) {
        this.bank = bank;
        if (Bank.keyAnalytics == null)
            Bank.keyAnalytics = merchantKey;

    }

    public PayUWebViewClient(@NonNull Bank bank, @NonNull MagicRetryFragment magicRetryFragment, @NonNull String merchantKey) {
        super(magicRetryFragment);
        this.bank = bank;
        if (Bank.keyAnalytics == null)
            Bank.keyAnalytics = merchantKey;
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {

        super.onPageStarted(view, url, favicon);

        loadingFinished = false;
        if (bank != null) {
            bank.onPageStartedWebclient(url); // set the current url
        }
    }

    @Override
    public void onPageFinished(WebView view, String url) {

        super.onPageFinished(view, url);

        if (!redirect) {
            loadingFinished = true;
        }

        if (url.equals(mainUrl)) {
            loadingFinished = true;
            redirect = false;
        } else {
            redirect = false;
        }

        if (bank != null) {
            bank.onPageFinishWebclient(url); // notify bank.java that page loading is done.
        }
    }

    @Override
    public void onLoadResource(WebView view, String url) {
        if (bank != null)
            bank.onLoadResourse(view, url);
        super.onLoadResource(view, url);

    }


    @Override
    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        if (failingUrl != null)
            if (bank != null ) {
                if (Build.VERSION.SDK_INT < 23) {
                    bank.onReceivedErrorWebClient(errorCode, description);
                }
            }
    }

    @TargetApi(23)
    @Override
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        // TODO Need to handle this properly for CB
        if (bank != null) {
            bank.onReceivedErrorWebClient(error.getErrorCode(), error.getDescription().toString());
        }
    }


    // TODO : Remove the inner if else.
    @Override
    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        bank.onReceivedSslError(view, handler, error);
//        if (Build.VERSION.SDK_INT <= 10) {
//            handler.proceed();
//        } else {
//            if (Build.VERSION.SDK_INT >= 14) {
//                /*if(error.getUrl().contains(CBAnalyticsConstant.JANTA_URL))
//                {
//                    handler.proceed();
//                }else{
//                    if(bank!=null)
//                        bank.onReceivedErrorWebClient(-1, null);
//                }*/
//            } else {
//
//               /* if(error.getCertificate().toString().contains(CBAnalyticsConstant.JANTA_DOMAIN)){
//                    handler.proceed();
//                }else{
//                    if(bank!=null)
//                        bank.onReceivedErrorWebClient(-1, null);
//                }*/
//            }
//        }
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        this.mainUrl = url;

        if(CBUtil.isPlayStoreUrl(url)){
            CBUtil.launchPlayStore(bank.getContext(), url, CBUtil.getWebViewVersion(view));
            // returning true to tell the webview not to load this url,
            // since we have taken care of it.
            return true;
        }
        if(url.startsWith(CBConstant.DEEP_LINK_INTENT_URI)) {
            //In case of webview don't entertain deep link intent as it would open PreLollipopPayment activity
            return true;
        }

        if (!loadingFinished) {
            redirect = true;
        }
        loadingFinished = false;
        if (bank != null) {
            bank.onOverrideURL(url);
        }
        return false;
    }

}