package com.payu.custombrowser.upiintent;

import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;

import com.payu.custombrowser.PackageListDialogFragment;
import com.payu.custombrowser.R;
import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.cbinterface.GenericUPICallbacks;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import static android.support.v4.app.DialogFragment.STYLE_NORMAL;

public class PaymentResponseActivity extends FragmentActivity implements GenericUPICallbacks {
    PaymentHandler paymentHandler;
    String postData;
    String merchantKey;
    Payment payment;
    ArrayList<PackageBean> packageBeanList;
    ArrayList<PackageBean> filteredList;
    private CustomBrowserConfig customBrowserConfig;
    private CBAnalytics analytics;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        analytics = CBAnalytics.getInstance(getApplicationContext(),"local_cache_analytics");
        customBrowserConfig = getIntent().getParcelableExtra(CBConstant.CB_CONFIG);
        postData = customBrowserConfig.getPayuPostData();
        merchantKey = customBrowserConfig.getMerchantKey();
        payment = (Payment) getIntent().getSerializableExtra(CBConstant.PAYMENT_TYPE);
        paymentHandler = new PaymentHandler(this, postData, CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback());
        if (payment == Payment.TEZ) {
            paymentHandler.initiatePayment();
        } else {
            getUPIPackagesList();
            paymentHandler.initiatePayment();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == UPIPaymentConstants.PAYMENT_REQUEST_CODE) {
            if (resultCode == RESULT_OK && data!=null) {//data is null in case of whatsapp payment
                String status = data.getStringExtra(UPIPaymentConstants.STATUS);
                if (UPIPaymentConstants.SUCCESS.equalsIgnoreCase(status)) {
                    paymentHandler.verifyPayment(UPIPaymentConstants.SUCCESS, null);
                } else {
                    paymentHandler.verifyPayment(UPIPaymentConstants.FAILURE, null);
                }
            } else {
                paymentHandler.verifyPayment(UPIPaymentConstants.CANCEL, null);
            }
        }
    }

    @Override
    public void onResponse(PaymentResponse paymentResponse) {
        if(payment ==Payment.TEZ){
            paymentHandler.makePayment(payment.getPackageName());
        }else {
            filteredList = new ArrayList<>();
            if (paymentResponse.getApps() != null && paymentResponse.getApps().size() > 0) {
                for (PackageBean bean : paymentResponse.getApps()) {
                    Iterator iterator = packageBeanList.iterator();
                    while (iterator.hasNext()) {
                        PackageBean packageBean = (PackageBean) iterator.next();
                        if (packageBean.equals(bean)) {
                            packageBean.setPackageName(bean.getPackageName());
                            filteredList.add(packageBean);
                            iterator.remove();
                        }
                    }
                }
            }
            filteredList.addAll(packageBeanList);
            PackageListDialogFragment packageListDialogFragment = PackageListDialogFragment.newInstance(filteredList, paymentResponse, customBrowserConfig);
            packageListDialogFragment.setStyle(STYLE_NORMAL, R.style.FullScreenDialogStyle);
            packageListDialogFragment.show(getSupportFragmentManager(), "packageList");
        }
    }

    private void getUPIPackagesList() {
        packageBeanList = new ArrayList<>();
        Intent intent = new Intent();
        intent.setData(Uri.parse(UPIPaymentConstants.UPI_INTENT_PREFIX));
        List<ResolveInfo> resolveInfos = getPackageManager().queryIntentActivities(intent, PackageManager.MATCH_DEFAULT_ONLY);
        for (ResolveInfo resolveInfo : resolveInfos) {
            PackageInfo packageInfo = null;
            try {
                packageInfo = getPackageManager().getPackageInfo(resolveInfo.activityInfo.packageName, 0);
                Drawable packageDrawable = getPackageManager().getApplicationIcon(packageInfo.applicationInfo);
                String name = (String) getPackageManager().getApplicationLabel(packageInfo.applicationInfo);
                packageBeanList.add(new PackageBean(name, packageDrawable, packageInfo.packageName));
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onAppSelected(String packageName) {
        analytics.log(CBUtil.getLogMessage(getApplicationContext(), payment.toString().toLowerCase()+CBAnalyticsConstant.PAYMENT_APP, packageName, null,customBrowserConfig.getMerchantKey() , customBrowserConfig.getTransactionID(), null));
        paymentHandler.makePayment(packageName);
    }

    @Override
    public void onDialogCancelled(boolean isValidPaymentMethodPresent) {
        if(isValidPaymentMethodPresent){
            analytics.log(CBUtil.getLogMessage(getApplicationContext(), payment.toString().toLowerCase(), CBAnalyticsConstant.BACK_BUTTON_CANCEL_CLICK, null,customBrowserConfig.getMerchantKey() , customBrowserConfig.getTransactionID(), null));
            paymentHandler.verifyPayment(UPIPaymentConstants.CANCEL, null);
        }else {
            analytics.log(CBUtil.getLogMessage(getApplicationContext(), payment.toString().toLowerCase(), CBAnalyticsConstant.NO_UPI_APPS_PRESENT, null,customBrowserConfig.getMerchantKey() , customBrowserConfig.getTransactionID(), null));
            paymentHandler.verifyPayment(UPIPaymentConstants.FAIL, UPIPaymentConstants.NO_UPI_APPS_PRESENT);
        }
    }
}
