package com.payu.custombrowser.wrapper;

import android.app.Activity;
import android.content.Context;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.bean.CustomBrowserResultData;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.PaymentOption;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/**
 * Created by minie.sahni on 2/19/18.
 */

public class SamsungPayWrapper extends PaymentOptionWrapper {

    private ClassLoader samsungWrapperClassLoader;
    private Constructor samsungWrapperConstructor;
    private Class samsungWrapperClass;
    private Object samsungWrapperObject;

    /**
     *  Function to check for SamsungPay availability
     *
     * @param context Context
     * @param paymentOptionHash Payment Related Details Hash
     * @param merchantKey Merchant Key
     * @param user_credentials User Credentials
     */
    @Override
    public void checkForPaymentOptionAvailability(Context context, String paymentOptionHash, String merchantKey, String user_credentials) {
        if(CustomBrowserData.SINGLETON!=null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()!=null)
            this.cbListener = CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback();
        try {
            samsungWrapperClassLoader = SamsungPayWrapper.class.getClassLoader();
            samsungWrapperClass = samsungWrapperClassLoader.loadClass("com.payu.samsungpay.SamsungWrapper");
            samsungWrapperConstructor = samsungWrapperClass.getDeclaredConstructor(java.lang.reflect.InvocationHandler.class);
            samsungWrapperConstructor.setAccessible(true);
            samsungWrapperObject = samsungWrapperConstructor.newInstance(cbCallback);

            Method method = samsungWrapperObject.getClass().getMethod("checkSamsungPayAvailability", String.class,String.class,String.class, Context.class);
            method.invoke(samsungWrapperObject, paymentOptionHash,merchantKey,user_credentials,context);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void makePayment(Activity activity, CustomBrowserConfig customBrowserConfig) {
        try {
            if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null)
                this.cbListener = CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback();
            Method method = samsungWrapperObject.getClass().getMethod("makePayment", Activity.class, String.class);
            method.invoke(samsungWrapperObject, activity, customBrowserConfig.getPayuPostData());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Reflection Callback mapping with PayUCustomBrowserCallback and wrapper callback and SamsungPay Wrapper Callback
     */
    private java.lang.reflect.InvocationHandler cbCallback = new java.lang.reflect.InvocationHandler() {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equalsIgnoreCase(CBConstant.SAMSUNGPAY_SUCCESS)) {
                cbListener.onPaymentSuccess(args[0] + "", null);
            } else if (method.getName().equalsIgnoreCase(CBConstant.SAMSUNGPAY_FAILURE)) {
                cbListener.onPaymentFailure(args[0] + "", null);
            } else if (method.getName().equalsIgnoreCase(CBConstant.SAMSUNGPAY_INIT_SUCCESS)) {
                CustomBrowserResultData resultData = new CustomBrowserResultData();
                resultData.setPaymentOption(PaymentOption.SAMSUNGPAY);
                resultData.setSamsungPayVpa((String) args[0]);
                resultData.setPaymentOptionAvailable(true);
                cbListener.isPaymentOptionAvailable(resultData);
                CustomBrowserData.SINGLETON.setPaymentOption(PaymentOption.SAMSUNGPAY);
            } else if (method.getName().equalsIgnoreCase(CBConstant.SAMSUNGPAY_INIT_FAILURE)) {
                CustomBrowserResultData resultData = new CustomBrowserResultData();
                resultData.setPaymentOption(PaymentOption.SAMSUNGPAY);
                resultData.setPaymentOptionAvailable(false);
                resultData.setErrorMessage(args[1] + "");
                cbListener.isPaymentOptionAvailable(resultData);
                CustomBrowserData.SINGLETON.removePaymentOption(PaymentOption.SAMSUNGPAY);
            }
            return null;
        }
    };
}
