package com.payu.custombrowser;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.factory.PaymentOptionFactory;
import com.payu.custombrowser.upiintent.Payment;
import com.payu.custombrowser.upiintent.PaymentResponseActivity;
import com.payu.custombrowser.upiintent.UPIPaymentConstants;
import com.payu.custombrowser.upiintent.UPIUtil;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.PaymentOption;
import com.payu.custombrowser.wrapper.PaymentOptionWrapper;


public class CustomBrowser {

    /**
     * Function to check if payment is supported
     *
     * @param activity Activity instance
     * @param paymentOption {@link com.payu.custombrowser.util.PaymentOption}Payment Type
     * @param payUCustomBrowserCallback {@link com.payu.custombrowser.PayUCustomBrowserCallback}PayUCustomBrowserCallback instance
     * @param paymentOptionHash Hash for Payment Related Details api
     * @param merchantKey Merchant Key
     * @param user_credentials User Credentials
     */

    public void checkForPaymentAvailability(Activity activity, @NonNull PaymentOption paymentOption, @NonNull PayUCustomBrowserCallback payUCustomBrowserCallback, String paymentOptionHash, String merchantKey, String user_credentials){
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(payUCustomBrowserCallback);
        switch (paymentOption){
            case SAMSUNGPAY:
            case PHONEPE:
                if(CBUtil.isPaymentModuleAvailable(paymentOption)){
                    PaymentOptionWrapper paymentOptionWrapper = new PaymentOptionFactory(paymentOption).getPaymentWrapper();
                    paymentOptionWrapper.checkForPaymentOptionAvailability(activity, paymentOptionHash, merchantKey, user_credentials);
                }else{
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED,CBConstant.DEVICE_NOT_SUPPORTED_OR+"com.payu."+paymentOption.toString().toLowerCase()+CBConstant.IS_MISSING);
                }
                break;
        }

    }

    /**
     * Call this method to add CustomBrowser to application
     *
     * @param activity                    base class activity
     * @param cbCustomBrowserConfig       contain the specification of CB
     * @param cbPayUCustomBrowserCallback provide callbacks
     */
    public void addCustomBrowser(Activity activity, @NonNull CustomBrowserConfig cbCustomBrowserConfig, @NonNull PayUCustomBrowserCallback cbPayUCustomBrowserCallback) {

        CBAnalytics analytics = CBAnalytics.getInstance(activity.getApplicationContext(),"local_cache_analytics");
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(cbPayUCustomBrowserCallback);
        PaymentOption paymentOptionName = new CBUtil().getPaymentOptionFromPostData(cbCustomBrowserConfig.getPayuPostData());
        if(!TextUtils.isEmpty(cbCustomBrowserConfig.getReactVersion()))
            analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.REACT_VERSION_NAME,cbCustomBrowserConfig.getReactVersion(),null,cbCustomBrowserConfig.getMerchantKey(),cbCustomBrowserConfig.getTransactionID(),null));
        //Check if payment option is supported
        if (null != paymentOptionName) {
            if (CustomBrowserData.SINGLETON.isPaymentOptionAvailabilityCalled(paymentOptionName)) {
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), paymentOptionName.toString(), paymentOptionName.toString() + CBAnalyticsConstant.LAUNCHED, null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                new PaymentOptionFactory(paymentOptionName).getPaymentWrapper().makePayment(activity, cbCustomBrowserConfig);
            } else {
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), paymentOptionName.toString(), paymentOptionName.toString() + CBAnalyticsConstant.LAUNCH_FAILED, null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.CHECK_PAYMENT_NOT_CALLED, CBConstant.CHECK_PAYMENT_NOT_CALLED_MSG);
            }
        } else if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
               //We don't support payments below JB
            analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.OS_NOT_SUPPORTED,Build.VERSION.SDK_INT+"",null,cbCustomBrowserConfig.getMerchantKey(),cbCustomBrowserConfig.getTransactionID(),null));
            cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.OS_NOT_SUPPORTED_CODE, CBConstant.OS_NOT_SUPPORTED);
        } else if ((Build.VERSION.SDK_INT < 19)
                || (Build.VERSION.SDK_INT == 19 && cbCustomBrowserConfig.getGmsProviderUpdatedStatus()==CustomBrowserConfig.FALSE)) {
            //For OS b/w JB & KK payment is by Chrome tabs only
            if(CBUtil.isCustomTabSupported(activity.getApplicationContext())) {
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(),CBAnalyticsConstant.CUSTOM_TABS,CBAnalyticsConstant.CUSTOM_TABS_LAUNCHED,null,cbCustomBrowserConfig.getMerchantKey(),cbCustomBrowserConfig.getTransactionID(),null));
                Intent intent = new Intent(activity, PrePaymentsActivity.class);
                intent.putExtra("url", cbCustomBrowserConfig.getPostURL());
                intent.putExtra("html", cbCustomBrowserConfig.getHtmlData());
                intent.putExtra("postdata", cbCustomBrowserConfig.getPayuPostData());
                intent.putExtra(CBConstant.S2S_RETRY_URL, cbCustomBrowserConfig.getSurepayS2Surl());
                intent.putExtra("txnId", cbCustomBrowserConfig.getTransactionID());
                intent.putExtra("key", cbCustomBrowserConfig.getMerchantKey());
                activity.startActivity(intent);
            } else {
                //We support payment via Chrome tabs only below KK ,No Chrome tabs found,hence payment could not proceed.
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.CUSTOM_TABS,CBAnalyticsConstant.CUSTOM_TABS_LAUNCH_FAILED,null,cbCustomBrowserConfig.getMerchantKey(),cbCustomBrowserConfig.getTransactionID(),null));
                cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.CHROME_NOT_PRESENT_CODE, CBConstant.CHROME_NOT_PRESENT);
            }
        } else {
            // CustomBrowserData.SINGLETON.setPayuCustomBrowserConfig(cbCustomBrowserConfig);

            if (null != cbCustomBrowserConfig.getPayuPostData() && cbCustomBrowserConfig.getEnableSurePay() > 0 && (cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL)
                    || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.MOBILE_TEST_PAYMENT_URL_SEAMLESS) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PRODUCTION_PAYMENT_URL_SEAMLESS))) {
                // Sometimes post data contains & at the end, just removing it from the postdata
                if (cbCustomBrowserConfig.getPayuPostData().trim().endsWith("&")) {
                    cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData().substring(0, cbCustomBrowserConfig.getPayuPostData().length() - 1));
                }
                // Adding snooze=<snooze_count> in the post data being sent to payu server (_payment)
                cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData() + "&snooze=" + cbCustomBrowserConfig.getEnableSurePay());
            }
            UPIUtil upiUtil = new UPIUtil();
            Payment payment = upiUtil.getSupportedPayment(cbCustomBrowserConfig.getPayuPostData());

             if (null != payment && upiUtil.isPaymentMethodSupported(activity, payment)) {
                Intent intent = new Intent(activity, PaymentResponseActivity.class);
                intent.putExtra(CBConstant.POST_DATA, cbCustomBrowserConfig.getPayuPostData());
                activity.startActivity(intent);
            } else if (null != payment && !payment.isWebFlowSupported()) { //Payment is supported but on device its not possible
                cbPayUCustomBrowserCallback.onCBErrorReceived(UPIPaymentConstants.DEVICE_NOT_SUPPORTED_CODE, UPIPaymentConstants.DEVICE_NOT_SUPPORTED);
            } else {
                CBActivity.cbDrawerAdapter = cbCustomBrowserConfig.getCbMenuAdapter();
                CBActivity.cbConfigToolbarView = cbCustomBrowserConfig.getToolBarView();
                Intent intent = new Intent(activity, CBActivity.class);
                intent.putExtra("cb_config", cbCustomBrowserConfig);
                if (cbCustomBrowserConfig.getReviewOrderDefaultViewData() != null && cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas() != null) {
                    intent.putExtra(CBConstant.ORDER_DETAILS, cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas());
                }
                activity.startActivity(intent);
            }
        }
    }

}
