package com.payu.custombrowser.util;

import android.os.AsyncTask;

import com.payu.custombrowser.bean.CustomBrowserAsyncTaskData;
import com.payu.custombrowser.cbinterface.CustomBrowserAsyncTaskInterface;

import java.io.InputStream;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

/**
 * Created by franklin.michael on 23/06/16.
 *
 * Custom browser Generic async task.
 * Should be initialized with {@link CustomBrowserAsyncTaskInterface}
 * The response will be send the implemented class as string.
 * CustomBrowserAsyncTask takes {@link CustomBrowserAsyncTaskData} as input.
 */

public class CustomBrowserAsyncTask extends AsyncTask<CustomBrowserAsyncTaskData, String, String> {

    private CustomBrowserAsyncTaskInterface mCustomBrowserAsyncTaskInterface;

    private CustomBrowserAsyncTask(){} // no object without interface

    public CustomBrowserAsyncTask(CustomBrowserAsyncTaskInterface customBrowserAsyncTaskInterface){
        mCustomBrowserAsyncTaskInterface = customBrowserAsyncTaskInterface;
    }


    @Override
    protected void onPreExecute() {
        super.onPreExecute();
    }

    /**
     * following should be the possitions
     * @param customBrowserAsyncTaskData
     * @return
     */
    @Override
    protected String doInBackground(CustomBrowserAsyncTaskData... customBrowserAsyncTaskData) {
        CustomBrowserAsyncTaskData mCustomBrowserAsyncTaskData = customBrowserAsyncTaskData[0];
        try {
            URL url = new URL(mCustomBrowserAsyncTaskData.getUrl());
            HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
            conn.setRequestMethod(mCustomBrowserAsyncTaskData.getHttpMethod());
            conn.setSSLSocketFactory(new TLSSocketFactory());
            conn.setRequestProperty("Content-Type", mCustomBrowserAsyncTaskData.getContentType());
            conn.setRequestProperty("Content-Length", "" + (null != mCustomBrowserAsyncTaskData.getPostData() ? mCustomBrowserAsyncTaskData.getPostData().length() : 0));
            byte[] postParamsByte = mCustomBrowserAsyncTaskData.getPostData().getBytes();
            conn.getOutputStream().write(postParamsByte);
            InputStream responseInputStream = conn.getInputStream();
            StringBuffer responseStringBuffer = new StringBuffer();
            byte[] byteContainer = new byte[1024];
            for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                responseStringBuffer.append(new String(byteContainer, 0, i));
            }
            return responseStringBuffer.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return e.getMessage().toString();
        }
    }


    @Override
    protected void onPostExecute(String s) {
        super.onPostExecute(s);
        mCustomBrowserAsyncTaskInterface.onCustomBrowserAsyncTaskResponse(s);
    }
}
